/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.StOverdueDetail;
import com.bcxin.ins.models.order.policy.dao.InsOverdueDetailDao;
import com.bcxin.ins.models.order.policy.service.InsOverdueDetailService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OverdueDetailVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsOverdueDetailServiceImpl
extends ServiceImpl<InsOverdueDetailDao, StOverdueDetail>
implements InsOverdueDetailService {
    @Autowired
    private InsOverdueDetailDao dao;

    @Override
    public List<StOverdueDetail> selectInsOverdueDetailByInsBadDebt(Long oid) {
        return this.dao.selectInsOverdueDetailByInsBadDebt(oid);
    }

    @Override
    public void accordingToTheOverdueDetailVoSetUpInsOverdueDetail(OverdueDetailVo vo, Long bad_debt_id) {
        StOverdueDetail insOverdueDetail = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            insOverdueDetail = this.dao.selectById(Long.parseLong(vo.getOid()));
        } else {
            insOverdueDetail = new StOverdueDetail();
            insOverdueDetail.getBad_debt().setSt_bad_debt_id(bad_debt_id);
            this.dao.insert(insOverdueDetail);
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insOverdueDetail);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.updateById(insOverdueDetail);
    }

    @Override
    public void setOverdueDetailByOverdueDetailVo(List<OverdueDetailVo> voList, Long bad_debt_id) {
        if (voList != null && voList.size() > ConstProp.INT_NUMBER_ZERO) {
            this.ruleOutDoesNotExist(voList, bad_debt_id);
            for (OverdueDetailVo vo : voList) {
                this.accordingToTheOverdueDetailVoSetUpInsOverdueDetail(vo, bad_debt_id);
            }
        }
    }

    private void ruleOutDoesNotExist(List<OverdueDetailVo> voList, Long bad_debt_id) {
        List<StOverdueDetail> iodList = this.selectInsOverdueDetailByInsBadDebt(bad_debt_id);
        for (StOverdueDetail iod : iodList) {
            int i = ConstProp.INT_NUMBER_ZERO;
            for (OverdueDetailVo vo : voList) {
                if (!StrUtil.isNotBlank((CharSequence)vo.getOid()) || iod.getSt_overdue_detail_id() != Long.parseLong(vo.getOid())) continue;
                i = ConstProp.INT_NUMBER_ONE;
            }
            if (i != ConstProp.INT_NUMBER_ZERO) continue;
            this.dao.deleteById(iod.getSt_overdue_detail_id());
        }
    }

    @Override
    public List<OverdueDetailVo> getOverdueDetailVoListByInsOverdueDetailList(List<StOverdueDetail> odList) {
        ArrayList<OverdueDetailVo> voList = new ArrayList<OverdueDetailVo>();
        if (odList != null && odList.size() > ConstProp.INT_NUMBER_ZERO) {
            for (StOverdueDetail od : odList) {
                voList.add(this.accordingToInsOverdueDetailIntoOverdueDetailVo(od));
            }
        }
        return voList;
    }

    @Override
    public OverdueDetailVo accordingToInsOverdueDetailIntoOverdueDetailVo(StOverdueDetail od) {
        OverdueDetailVo vo = new OverdueDetailVo();
        if (od != null) {
            vo.setOid(String.valueOf(od.getSt_overdue_detail_id()));
            try {
                MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)od), (Object)vo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return vo;
    }
}

