/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.StForecastedDetail;
import com.bcxin.ins.models.order.policy.dao.InsForecastedDetailDao;
import com.bcxin.ins.models.order.policy.service.InsForecastedDetailService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ForecastedDetailVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsForecastedDetailServiceImpl
extends ServiceImpl<InsForecastedDetailDao, StForecastedDetail>
implements InsForecastedDetailService {
    @Autowired
    private InsForecastedDetailDao dao;

    @Override
    public List<StForecastedDetail> selectInsForecastedDetailByTurnover(Long oid) {
        return this.dao.selectInsForecastedDetailByTurnover(oid);
    }

    @Override
    public void setForecastedDetailByForecastedDetailVo(List<ForecastedDetailVo> voList, Long turnover_id) {
        if (voList != null && voList.size() > ConstProp.INT_NUMBER_ZERO) {
            this.ruleOutDoesNotExist(voList, turnover_id);
            for (ForecastedDetailVo vo : voList) {
                this.accordingToTheForecastedDetailVoSetUpInsForecastedDetail(vo, turnover_id);
            }
        }
    }

    private void ruleOutDoesNotExist(List<ForecastedDetailVo> voList, Long turnover_id) {
        List<StForecastedDetail> fdList = this.selectInsForecastedDetailByTurnover(turnover_id);
        for (StForecastedDetail ifd : fdList) {
            int i = ConstProp.INT_NUMBER_ZERO;
            for (ForecastedDetailVo vo : voList) {
                if (!StrUtil.isNotBlank((CharSequence)vo.getOid()) || ifd.getSt_forecasted_detail_id() != Long.parseLong(vo.getOid())) continue;
                i = ConstProp.INT_NUMBER_ONE;
            }
            if (i != ConstProp.INT_NUMBER_ZERO) continue;
            this.dao.deleteById(ifd.getSt_forecasted_detail_id());
        }
    }

    @Override
    public void accordingToTheForecastedDetailVoSetUpInsForecastedDetail(ForecastedDetailVo vo, Long turnover_id) {
        StForecastedDetail insForecastedDetail = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            insForecastedDetail = this.dao.selectById(Long.parseLong(vo.getOid()));
        } else {
            insForecastedDetail = new StForecastedDetail();
            insForecastedDetail.getTurnover().setSt_turnover_id(turnover_id);
            this.dao.insert(insForecastedDetail);
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insForecastedDetail);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.updateById(insForecastedDetail);
    }

    @Override
    public List<ForecastedDetailVo> packagingForecastedDetailVoListByInsForecastedDetailList(List<StForecastedDetail> fdList) {
        ArrayList<ForecastedDetailVo> voList = new ArrayList<ForecastedDetailVo>();
        for (StForecastedDetail ifd : fdList) {
            voList.add(this.accordingToInsForecastedDetailIntoForecastedDetailVo(ifd));
        }
        return voList;
    }

    @Override
    public ForecastedDetailVo accordingToInsForecastedDetailIntoForecastedDetailVo(StForecastedDetail insForecastedDetail) {
        ForecastedDetailVo vo = new ForecastedDetailVo();
        vo.setOid(String.valueOf(insForecastedDetail.getSt_forecasted_detail_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insForecastedDetail), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vo;
    }
}

