/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.StBadAnalysis;
import com.bcxin.ins.models.order.policy.dao.InsBadAnalysisDao;
import com.bcxin.ins.models.order.policy.service.InsBadAnalysisService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.BadAnalysisVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsBadAnalysisServiceImpl
extends ServiceImpl<InsBadAnalysisDao, StBadAnalysis>
implements InsBadAnalysisService {
    @Autowired
    private InsBadAnalysisDao dao;

    @Override
    public List<StBadAnalysis> selectInsBadAnalysisByInsBadDebt(Long oid) {
        return this.dao.selectInsBadAnalysisByInsBadDebt(oid);
    }

    @Override
    public void accordingToTheBadAnalysisVoSetUpInsBadAnalysis(BadAnalysisVo vo, Long bad_debt_id) {
        StBadAnalysis insBadAnalysis = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            insBadAnalysis = this.dao.selectById(Long.parseLong(vo.getOid()));
        } else {
            insBadAnalysis = new StBadAnalysis();
            insBadAnalysis.getBad_debt().setSt_bad_debt_id(bad_debt_id);
            this.dao.insert(insBadAnalysis);
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insBadAnalysis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.updateById(insBadAnalysis);
    }

    @Override
    public void setBadAnalysisByBadAnalysisVo(List<BadAnalysisVo> voList, Long bad_debt_id) {
        if (voList != null && voList.size() > 0) {
            for (BadAnalysisVo vo : voList) {
                this.accordingToTheBadAnalysisVoSetUpInsBadAnalysis(vo, bad_debt_id);
            }
        }
    }

    @Override
    public List<BadAnalysisVo> getBadAnalysisVoListByInsBadAnalysisList(List<StBadAnalysis> ibaList) {
        ArrayList<BadAnalysisVo> voList = new ArrayList<BadAnalysisVo>();
        if (ibaList != null && ibaList.size() > 0) {
            for (StBadAnalysis iba : ibaList) {
                voList.add(this.accordingToInsBadAnalysisIntoBadAnalysisVo(iba));
            }
        }
        return voList;
    }

    @Override
    public BadAnalysisVo accordingToInsBadAnalysisIntoBadAnalysisVo(StBadAnalysis iba) {
        BadAnalysisVo vo = new BadAnalysisVo();
        vo.setOid(String.valueOf(iba.getSt_bad_analysis_id()));
        if (iba != null) {
            try {
                MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)iba), (Object)vo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return vo;
    }
}

