/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.Hireling;
import com.bcxin.ins.models.order.policy.dao.HirelingDao;
import com.bcxin.ins.models.order.policy.service.HirelingService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class HirelingServiceImpl
extends ServiceImpl<HirelingDao, Hireling>
implements HirelingService {
    @Autowired
    private HirelingDao dao;

    @Override
    public void accordingToTheHirelingVoSetUpHireling(SpecialHirelingVo vo, Long order_id) {
        List hvoList = vo.getHirelingVoList();
        Hireling hireling = null;
        for (HirelingVo hvo : hvoList) {
            if (StringUtils.isNotEmpty((CharSequence)hvo.getOid())) {
                hireling = (Hireling)this.dao.selectById(Long.valueOf(Long.parseLong(hvo.getOid())));
                try {
                    MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)hvo), (Object)hireling);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.dao.updateById(hireling);
                continue;
            }
            hireling = new Hireling();
            try {
                MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)hvo), (Object)hireling);
                hireling.setIns_insurance_slip_id(order_id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dao.insert(hireling);
        }
    }

    @Override
    public void getSpecialHirelingVoByOrderID(SpecialHirelingVo vo, Long order_id) {
        List<HirelingVo> list = this.dao.selectHirelingVoByOrderId(order_id);
        int count = 0;
        if (list != null) {
            count = list.size() < 3 ? list.size() : 100;
        }
        if (count == 100) {
            for (int i = count; i < 3; ++i) {
                list.add(new HirelingVo());
            }
        }
        vo.setHirelingVoList(list);
    }

    @Override
    public boolean delectHirelingByOid(Long oid) {
        try {
            this.dao.deleteById(oid);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean delectAllHireling(Long oid) {
        try {
            HashMap map = Maps.newHashMap();
            map.put("ins_insurance_slip_id", oid);
            this.dao.deleteByMap(map);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

