/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.claim.service.impl;

import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.entity.policy_report.InsCommonReport;
import com.bcxin.ins.models.claim.dao.InsCommonReportDao;
import com.bcxin.ins.models.claim.service.InsCaseInfoService;
import com.bcxin.ins.models.claim.service.InsCaseScheduleService;
import com.bcxin.ins.models.claim.service.InsClaimInformationService;
import com.bcxin.ins.models.claim.service.InsCommonReportService;
import com.bcxin.ins.models.claim.service.InsPaymentInfoService;
import com.bcxin.ins.models.order.policy.service.InsuranceOperationService;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.ins.vo.report_pac.InsPaymentInfoVo;
import com.bcxin.ins.vo.report_pac.ReportCodeVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsCommonReportServiceImpl
extends ServiceImpl<InsCommonReportDao, InsCommonReport>
implements InsCommonReportService {
    @Autowired
    private InsCommonReportDao dao;
    @Autowired
    private InsuranceOperationService insuranceOperationService;
    @Autowired
    private InsPaymentInfoService insPaymentInfoService;
    @Autowired
    private InsClaimInformationService insClaimInformationService;
    @Autowired
    private InsCaseScheduleService insCaseScheduleService;
    @Autowired
    private InsCaseInfoService insCaseInfoService;

    @Override
    public InsCommonReportVo getInsCommonReportVoById(Long oid) {
        return this.dao.getInsCommonReportVoById(oid);
    }

    @Override
    public InsCommonReportVo getInsCommonReportVoInfoById(Long oid) {
        InsCommonReportVo insCommonReportVo = this.getInsCommonReportVoById(oid);
        if (insCommonReportVo == null) {
            return insCommonReportVo;
        }
        OrderFormVo order = this.insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(insCommonReportVo.getIns_insurance_slip_id()));
        InsPaymentInfoVo insPaymentInfoVo = this.insPaymentInfoService.getInsPaymentInfoVo(Long.parseLong(insCommonReportVo.getIns_payment_info_id()));
        insCommonReportVo.setInsPaymentInfoVo(insPaymentInfoVo);
        this.insClaimInformationService.getInsCommonReportVoByReportID(insCommonReportVo, oid);
        this.insCaseInfoService.getInsCommonReportVoByReportID(insCommonReportVo, oid);
        this.insCaseScheduleService.getInsCommonReportVoByReportID(insCommonReportVo, oid);
        String accident_address = RegionUtils.getRegionNameByALLCode((String)insCommonReportVo.getAccident_province_code(), (String)insCommonReportVo.getAccident_city_code(), (String)insCommonReportVo.getAccident_county_code()) + insCommonReportVo.getAccident_place();
        insCommonReportVo.setAccident_address(accident_address);
        String sign = order == null ? "" : (order.getProduct_code().contains("GZZRX-CA") ? "CA" : "");
        ReportCodeVo rcvo = new ReportCodeVo(sign);
        if ("CA".equals(sign)) {
            insCommonReportVo.setAccident_cause_level(rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_1()));
        } else if ("0".equals(insCommonReportVo.getIs_sync())) {
            insCommonReportVo.setAccident_cause_level(rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_1()) + "\uff1a" + rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_2()));
        } else {
            insCommonReportVo.setAccident_cause_level(rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_2()));
        }
        insCommonReportVo.setInjured_detail_content(this.setInj(insCommonReportVo.getInjured_detail(), insCommonReportVo.getOutpatient_list(), insCommonReportVo.getMaim_list(), insCommonReportVo.getDemise_list()));
        return insCommonReportVo;
    }

    @Override
    public void settleALawsuitByID(Long oid) {
        this.dao.settleALawsuitByID(oid);
    }

    private String setInj(String injured_detail, String outpatient_list, String maim_list, String demise_list) {
        String[] injs;
        String content = "";
        if (StringUtils.isEmpty((CharSequence)injured_detail)) {
            return content;
        }
        for (String str : injs = injured_detail.split(",")) {
            if (str.equals("01")) {
                content = content + "\u95e8\u8bca\uff1a" + outpatient_list + "\uff1b";
                continue;
            }
            if (str.equals("02")) {
                content = content + "\u4f4f\u9662\u3001\u4f24\u6b8b\uff1a" + maim_list + "\uff1b";
                continue;
            }
            if (!str.equals("03")) continue;
            content = content + "\u6b7b\u4ea1\uff1a" + demise_list + "\uff1b";
        }
        return content;
    }

    @Override
    public PageResult selectInsCommonReportVoListByOrderID(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.selectInsCommonReportVoListByOrderIDCnt(p)), this.dao.selectInsCommonReportVoListByOrderID(p));
    }
}

