/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.apply.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.service.SysLogService;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.core.util.JwtUtil;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.models.apply.service.PreseverApplyService;
import com.bcxin.ins.models.order.policy.service.InsuranceOperationService;
import com.bcxin.ins.util.OSSFileUtil;
import com.bcxin.ins.vo.InsPreservationPayVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"${apiPath}/myApply"})
public class PreserverApplyActionController
extends BaseController {
    @Autowired
    private InsuranceOperationService insuranceOperationService;
    @Autowired
    private PreseverApplyService preseverApplyService;
    @Autowired
    private SysLogService logService;
    private static final String PRESERVER_LIST = PreserverApplyActionController.getViewPath((String)"admin/apply/api/preserver_apply_list");
    private static final String PRESERVER_DETAIL_ADD_SUB = PreserverApplyActionController.getViewPath((String)"admin/apply/api/perserver_detail_add_sub");
    private static final String PRESERVER_DETAIL_ADD_SUB1 = PreserverApplyActionController.getViewPath((String)"admin/apply/api/order_detail");
    private static final String ORDER_LIST = PreserverApplyActionController.getViewPath((String)"admin/order/api/order_manager_list");
    private static final String PRESERVER_DETAIL_MODIFY = PreserverApplyActionController.getViewPath((String)"admin/apply/api/perserver_detail_modify");
    private static final String PRESERVER_PAY_LIST = PreserverApplyActionController.getViewPath((String)"admin/apply/api/preserver_pay_list");
    private static final String PRESERVER_SETTLEMENT_PAY_LIST = PreserverApplyActionController.getViewPath((String)"admin/apply/api/preserver_settlement_pay_list");
    private static final String PRESERVER_CHILD_BILL_PAY = PreserverApplyActionController.getViewPath((String)"admin/apply/api/perserver_child_bill_pay");
    private static final String PRESERVER_CHILD_SETTLEMENT_PAY = PreserverApplyActionController.getViewPath((String)"admin/apply/api/perserver_child_settlement_pay");
    private static final String PRESERVER_DETAIL_PAY = PreserverApplyActionController.getViewPath((String)"admin/apply/api/perserver_detail_pay");
    private static final String APPLY_REPAIR = PreserverApplyActionController.getViewPath((String)"admin/apply/api/apply_repair");
    private static String MIN = "min";
    private static String MAX = "max";

    @RequestMapping(value={"/findApplyList/{sup_id}"})
    public String findOrderList(ModelMap model, @PathVariable String sup_id) throws Exception {
        if (!"sup_admin".equals(sup_id)) {
            throw new Exception("403-\u65e0\u8bbf\u95ee\u6743\u9650\uff01");
        }
        model.addAttribute("sup_id", (Object)sup_id);
        return PRESERVER_LIST;
    }

    @RequestMapping(value={"/applyList_table/{sup_id}"})
    @ResponseBody
    public Object query(@RequestParam Map<Object, Object> params, @PathVariable String sup_id, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        if ("sup_admin".equals(sup_id)) {
            sup_id = "";
        }
        params.put("sup_id", sup_id);
        CTLUtil.out((Object)this.preseverApplyService.query(p), (HttpServletResponse)resp);
        return null;
    }

    @RequestMapping(value={"/down_record_result_set"})
    public void downRecordResultSet(HttpServletRequest req, HttpServletResponse resp) {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String name = req.getParameter("name");
        this.preseverApplyService.downRecordResultSet(keyword, name, start_time, end_time, resp);
    }

    @RequestMapping(value={"/down_record_detail"})
    public void downRecordDetail(HttpServletRequest req, HttpServletResponse resp) {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String name = req.getParameter("name");
        this.preseverApplyService.downRecordDetail(keyword, name, start_time, end_time, resp);
    }

    @RequestMapping(value={"/down_success_result_set"})
    public void downSuccessResultSet(HttpServletRequest req, HttpServletResponse resp) {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String type = req.getParameter("type");
        String name = req.getParameter("name");
        String isGQ = req.getParameter("isGQ");
        this.preseverApplyService.downSuccessResultSet(keyword, name, start_time, end_time, type, isGQ, resp);
    }

    @RequestMapping(value={"/getDZPD/{id}"})
    @ResponseBody
    public R getDZPD(@PathVariable Long id) {
        return this.preseverApplyService.getDZPD(id);
    }

    @RequestMapping(value={"/perserverDetailAddByID/{id}/{sup_id}"})
    public String perserverDetailAddByID(ModelMap model, @PathVariable Long id, @PathVariable String sup_id) {
        InsPreservationRecordVo preservationRecordVo = this.preseverApplyService.accordingToApplyIDToGetpreservationRecordVo(id);
        model.addAttribute("preservationRecordVo", (Object)preservationRecordVo);
        model.addAttribute("logList", (Object)this.logService.findSysLogByOrderID(String.valueOf(id)));
        model.addAttribute("sup_id", (Object)sup_id);
        OrderFormVo order = this.insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(preservationRecordVo.getIns_insurance_slip_id()));
        model.addAttribute("apprSign", (Object)(StringUtils.isEmpty((CharSequence)order.getProduct_code()) ? 0 : (order.getProduct_code().contains("GZZRX-CA") ? 1 : 0)));
        return PRESERVER_DETAIL_ADD_SUB;
    }

    @RequestMapping(value={"/perserverDetail/{id}/{status}"})
    @ResponseBody
    public Object queryDetail(@RequestParam Map<Object, Object> params, @PathVariable String id, @PathVariable String status, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        params.put("id", id);
        params.put("status", status);
        CTLUtil.out((Object)this.preseverApplyService.queryDetail(params), (HttpServletResponse)resp);
        return null;
    }

    @RequestMapping(value={"/perserverUpdataButton/{id}"})
    @ResponseBody
    public boolean queryStatus(@PathVariable Long id) {
        return this.preseverApplyService.accordingToApplyIDToGetStatus(id);
    }

    @RequestMapping(value={"/applyAuditFail2"}, method={RequestMethod.POST})
    @ResponseBody
    public R applyAuditFail1(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map p = CTLUtil.init((HttpServletRequest)request, params);
        return this.preseverApplyService.statusUpd(p, request);
    }

    @RequestMapping(value={"/updataReviseStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public R updataReviseStatus(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map p = CTLUtil.init((HttpServletRequest)request, params);
        return this.preseverApplyService.updataReviseStatus(p, request);
    }

    @RequestMapping(value={"/updataCAReviseStatus"})
    @ResponseBody
    public String updataReviseStatus(HttpServletRequest request) {
        JSONObject json;
        String token = request.getParameter("token");
        try {
            json = JwtUtil.getJsonByParseJWT((String)token, (String)"18disdkfd83DPQ012I8VcnSkq");
            if (json == null) {
                return JSON.toJSONString((Object)Result.fail((String)"\u672a\u643a\u5e26\u6709\u6548\u4fe1\u606f\uff01"));
            }
        }
        catch (ExpiredJwtException e1) {
            return JSON.toJSONString((Object)Result.fail((String)"token\u5df2\u7ecf\u8fc7\u671f\uff01"));
        }
        catch (Exception e) {
            return JSON.toJSONString((Object)Result.fail((String)"token\u89e3\u6790\u51fa\u9519\uff01"));
        }
        return JSON.toJSONString((Object)this.preseverApplyService.updataCAReviseStatus(json.getString("recordId"), json.getString("recordStatus"), json.getString("remark"), json.getString("reviseSerialNumIns"), json.getString("revisePath"), request));
    }

    @RequestMapping(value={"/saveResultSet/{id}/{revise_type}"})
    @ResponseBody
    public R saveResultSet(@PathVariable Long id, @PathVariable String revise_type) {
        return this.preseverApplyService.pushResultSetByRecord(id, revise_type);
    }

    @RequestMapping(value={"/uploadFile/{upload_id}/{upload_Type}"})
    @ResponseBody
    public R uploadFilePay(MultipartHttpServletRequest request, @PathVariable String upload_id, @PathVariable String upload_Type) throws Exception {
        MultipartFile pay_file = request.getFile("upload_file");
        String path = OSSFileUtil.huaweiOBSFileUpload((MultipartFile)pay_file, (String)"/record/");
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return this.preseverApplyService.doUploadFile(path, upload_id, upload_Type);
        }
        return new R(Boolean.valueOf(false), "\u8bf7\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u6587\u4ef6");
    }

    @RequestMapping(value={"/setPdNo"}, method={RequestMethod.POST})
    @ResponseBody
    public R setPdNo(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map p = CTLUtil.init((HttpServletRequest)request, params);
        return this.preseverApplyService.setPdNo(p, request);
    }

    @RequestMapping(value={"/perserverDetailChangeByID/{id}/{sup_id}"})
    public String perserverDetailChangeByID(ModelMap model, @PathVariable Long id, @PathVariable String sup_id) {
        InsPreservationRecordVo preservationRecordVo = this.preseverApplyService.accordingToApplyIDToGetpreservationRecordVo(id);
        model.addAttribute("logList", (Object)this.logService.findSysLogByOrderID(String.valueOf(id)));
        model.addAttribute("preservationRecordVo", (Object)preservationRecordVo);
        model.addAttribute("sup_id", (Object)sup_id);
        OrderFormVo order = this.insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(preservationRecordVo.getIns_insurance_slip_id()));
        model.addAttribute("apprSign", (Object)(StringUtils.isEmpty((CharSequence)order.getProduct_code()) ? 0 : (order.getProduct_code().contains("GZZRX-CA") ? 1 : 0)));
        return PRESERVER_DETAIL_MODIFY;
    }

    @RequestMapping(value={"/perserverOldPerson/{id}/{status}"})
    @ResponseBody
    public Object queryOldPerson(@RequestParam Map<Object, Object> params, @PathVariable String id, @PathVariable String status, HttpServletRequest req, HttpServletResponse resp) {
        CTLUtil.init((HttpServletRequest)req, params);
        params.put("id", id);
        params.put("status", status);
        CTLUtil.out((Object)this.preseverApplyService.queryOldPerson(params), (HttpServletResponse)resp);
        this.logger.info(JSON.toJSONString((Object)this.preseverApplyService.queryOldPerson(params)));
        return null;
    }

    @RequestMapping(value={"/findPayList/{sup_id}"})
    public String findPayList(ModelMap model, @PathVariable String sup_id) throws Exception {
        if (!"sup_admin".equals(sup_id)) {
            throw new Exception("403-\u65e0\u8bbf\u95ee\u6743\u9650\uff01");
        }
        model.addAttribute("sup_id", (Object)sup_id);
        return PRESERVER_PAY_LIST;
    }

    @RequestMapping(value={"/applyPayList_table/{sup_id}"})
    @ResponseBody
    public Object queryPay(@RequestParam Map<Object, Object> params, @PathVariable String sup_id, HttpServletRequest req, HttpServletResponse resp, ModelMap model) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        if ("sup_admin".equals(sup_id)) {
            sup_id = "";
        }
        model.addAttribute("sup_id", (Object)sup_id);
        params.put("sup_id", sup_id);
        CTLUtil.out((Object)this.preseverApplyService.queryBillPay(params), (HttpServletResponse)resp);
        return null;
    }

    @RequestMapping(value={"/childBillList/{parentPayId}/{isPart}"})
    public String childBillList(ModelMap model, @PathVariable Long parentPayId, @PathVariable String isPart) {
        this.logger.info(JSON.toJSONString((Object)parentPayId));
        InsPreservationPayVo insPreservationPayVo = this.preseverApplyService.accordingToPayIDToGetpreservationPayVo(parentPayId);
        this.logger.info(JSON.toJSONString((Object)insPreservationPayVo));
        model.addAttribute("insPreservationPayVo", (Object)insPreservationPayVo);
        model.addAttribute("parentPayId", (Object)(parentPayId + ""));
        model.addAttribute("isPart", (Object)isPart);
        return PRESERVER_CHILD_BILL_PAY;
    }

    @RequestMapping(value={"/getBillListForPage"})
    @ResponseBody
    public Object getBillListForPage(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        CTLUtil.init((HttpServletRequest)req, params);
        CTLUtil.out((Object)this.preseverApplyService.queryChildBillPay(params), (HttpServletResponse)resp);
        return null;
    }

    @RequestMapping(value={"/findSettlementPayList/{sup_id}"})
    public String findSettlementList(ModelMap model, @PathVariable String sup_id) throws Exception {
        if (!"sup_admin".equals(sup_id)) {
            throw new Exception("403-\u65e0\u8bbf\u95ee\u6743\u9650\uff01");
        }
        model.addAttribute("sup_id", (Object)sup_id);
        return PRESERVER_SETTLEMENT_PAY_LIST;
    }

    @RequestMapping(value={"/applySettlementPayList_table/{sup_id}"})
    @ResponseBody
    public Object querySettlementPay(@RequestParam Map<Object, Object> params, @PathVariable String sup_id, HttpServletRequest req, HttpServletResponse resp, ModelMap model) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        if ("sup_admin".equals(sup_id)) {
            sup_id = "";
        }
        model.addAttribute("sup_id", (Object)sup_id);
        params.put("sup_id", sup_id);
        CTLUtil.out((Object)this.preseverApplyService.querySettlementPay(params), (HttpServletResponse)resp);
        return null;
    }

    @RequestMapping(value={"/childSettlementList/{parentPayId}"})
    public String childSettlementList(ModelMap model, @PathVariable Long parentPayId) {
        this.logger.info(JSON.toJSONString((Object)parentPayId));
        InsPreservationPayVo insPreservationPayVo = this.preseverApplyService.accordingToPayIDToGetpreservationPayVo(parentPayId);
        this.logger.info(JSON.toJSONString((Object)insPreservationPayVo));
        model.addAttribute("insPreservationPayVo", (Object)insPreservationPayVo);
        model.addAttribute("parentPayId", (Object)(parentPayId + ""));
        return PRESERVER_CHILD_SETTLEMENT_PAY;
    }

    @RequestMapping(value={"/getChildSettlementListForPage"})
    @ResponseBody
    public Object getChildSettlementListForPage(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        CTLUtil.init((HttpServletRequest)req, params);
        CTLUtil.out((Object)this.preseverApplyService.queryChildSettlementPay(params), (HttpServletResponse)resp);
        return null;
    }

    @RequestMapping(value={"createPartBill"})
    @ResponseBody
    public String createPartBill(String isSummaryBill, String payIds) {
        JSONObject json = this.preseverApplyService.createPartBill(isSummaryBill, payIds.split(","));
        return json.toJSONString();
    }

    @RequestMapping(value={"createPartBillByNo"})
    @ResponseBody
    public String createPartBillByNo(String isSummaryBill, String payNos) {
        JSONObject json = this.preseverApplyService.createPartBillByNo(isSummaryBill, payNos.split(","));
        return json.toJSONString();
    }

    @RequestMapping(value={"/downBillPay"})
    public void downBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String pay_status = req.getParameter("pay_status");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.preseverApplyService.downBillPay(pay_status, start_time, et, keyword, resp);
    }

    @RequestMapping(value={"/downChildBillPay"})
    public void downChildBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String pay_status = req.getParameter("pay_status");
        String parentPayId = req.getParameter("parentPayId");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.preseverApplyService.downChildBillPay(Long.parseLong(parentPayId), pay_status, start_time, et, keyword, resp);
    }

    @RequestMapping(value={"/downChildSettlementBillPay"})
    public void downChildSettlementBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String parentPayId = req.getParameter("parentPayId");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        this.preseverApplyService.downChildSettlementBillPay(Long.parseLong(parentPayId), start_time, et, keyword, resp);
    }

    @RequestMapping(value={"/payDetailByID/{id}"})
    public String payDetailAddByID(ModelMap model, @PathVariable Long id) {
        this.logger.info(JSON.toJSONString((Object)id));
        InsPreservationPayVo insPreservationPayVo = this.preseverApplyService.accordingToPayIDToGetpreservationPayVo(id);
        this.logger.info(JSON.toJSONString((Object)insPreservationPayVo));
        model.addAttribute("insPreservationPayVo", (Object)insPreservationPayVo);
        return PRESERVER_DETAIL_PAY;
    }

    @RequestMapping(value={"/perserverPayDetail/{id}"})
    @ResponseBody
    public Object queryPayDetail(@RequestParam Map<Object, Object> params, @PathVariable String id, HttpServletRequest req, HttpServletResponse resp) {
        CTLUtil.init((HttpServletRequest)req, params);
        params.put("id", id);
        CTLUtil.out((Object)this.preseverApplyService.queryPayDetail(params), (HttpServletResponse)resp);
        return null;
    }

    @RequestMapping(value={"/updataPayStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public R updataPayStatus(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map p = CTLUtil.init((HttpServletRequest)request, params);
        return this.preseverApplyService.updataPayStatus(p);
    }

    @RequestMapping(value={"/overPay"}, method={RequestMethod.POST})
    @ResponseBody
    public R overPay(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map p = CTLUtil.init((HttpServletRequest)request, params);
        return this.preseverApplyService.overPay(p);
    }

    @RequestMapping(value={"/applyRepair/{sup_id}"})
    public String applyRepair(ModelMap model, @PathVariable String sup_id) throws Exception {
        if (!"sup_admin".equals(sup_id)) {
            throw new Exception("403-\u65e0\u8bbf\u95ee\u6743\u9650\uff01");
        }
        model.addAttribute("sup_id", (Object)sup_id);
        return APPLY_REPAIR;
    }
}

