/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.apply.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.core.service.impl.MySysClientUserServiceImpl;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.policy_core.InsPreservationDetail;
import com.bcxin.ins.entity.policy_core.InsPreservationPay;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.models.apply.dao.PreseverApplyDao;
import com.bcxin.ins.models.apply.dao.PreseverApplyDetailDao;
import com.bcxin.ins.models.apply.service.ComTaskResidualService;
import com.bcxin.ins.models.apply.service.InsPreservationPayService;
import com.bcxin.ins.models.apply.service.InsPreservationResultSetService;
import com.bcxin.ins.models.apply.service.PreseverApplyService;
import com.bcxin.ins.models.order.policy.service.InsPreservationDetailService;
import com.bcxin.ins.models.order.policy.service.InsRoleInpolicyService;
import com.bcxin.ins.models.order.policy.service.InsuranceOperationService;
import com.bcxin.ins.models.pub.service.ADModelSendService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MD5Util;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.RestUtil;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.EmailMsgRecordType;
import com.bcxin.ins.util.email.EmailMsgType;
import com.bcxin.ins.util.email.MessageModel;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.excel.ExcelUtil;
import com.bcxin.ins.util.http.HuaWeiSmsContent;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationPayVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.SurrenderVo;
import com.bcxin.ins.vo.excel.InsPreservationPayChildExcelVo;
import com.bcxin.ins.vo.excel.InsPreservationPayExcelVo;
import com.bcxin.ins.vo.excel.RecordDetailExcelVo;
import com.bcxin.ins.vo.excel.RecordExcelVo;
import com.bcxin.ins.vo.excel.RecordSuccessExcelVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class PresverApplyServiceImpl
extends ServiceImpl<PreseverApplyDao, InsPreservationRecord>
implements PreseverApplyService {
    private static Logger log = LoggerFactory.getLogger(MySysClientUserServiceImpl.class);
    @Autowired
    private PreseverApplyDao dao;
    @Autowired
    private PreseverApplyDetailDao dao2;
    @Autowired
    private InsRoleInpolicyService insRoleInpolicyService;
    @Autowired
    private InsuranceOperationService insuranceOperationService;
    @Autowired
    private InsPreservationResultSetService insPreservationResultSetService;
    @Autowired
    private InsPreservationPayService insPreservationPayService;
    @Autowired
    private InsPreservationDetailService insPreservationDetailService;
    @Autowired
    private ComDeployConfigService comDeployConfigService;
    @Autowired
    private ComTaskResidualService comTaskResidualService;
    @Autowired
    private ADModelSendService mss;

    @Override
    public String uploadFile(MultipartFile roleFile, String savePath) {
        String result = "";
        if (!roleFile.isEmpty()) {
            try {
                String fileName = roleFile.getOriginalFilename();
                String materialFileType = fileName.split("\\.")[1];
                String files = DateUtil.generatorRadomNumber() + "." + materialFileType;
                result = savePath + files;
                String path = GlobalResources.COM_IMG_RE + savePath;
                File fileP = new File(path);
                if (!fileP.exists()) {
                    fileP.mkdirs();
                }
                File file = new File(path + files);
                roleFile.transferTo(file);
                result = "/getResource?path=" + result;
            }
            catch (IOException e) {
                e.printStackTrace();
                result = "";
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        return result;
    }

    @Override
    public boolean savePath(Long oid, String path, String upload_Type) {
        boolean flag = true;
        try {
            if ("1".equals(upload_Type)) {
                this.dao.updateDetailResivePathByID(oid, path);
            } else if ("2".equals(upload_Type)) {
                this.dao.updatePayPathResivePathByID(oid, path);
            } else if ("3".equals(upload_Type)) {
                InsPreservationPay pay = (InsPreservationPay)this.insPreservationPayService.selectById(oid);
                if (StringUtils.isNotEmpty((CharSequence)pay.getPay_order_path())) {
                    path = pay.getPay_order_path() + "||" + path;
                }
                pay.setPay_order_path(path);
                pay.setPay_status("2");
                this.insPreservationPayService.updateById(pay);
            } else if ("4".equals(upload_Type)) {
                InsPreservationPay pay = (InsPreservationPay)this.insPreservationPayService.selectById(oid);
                pay.setFp_url(path);
                this.insPreservationPayService.updateById(pay);
            }
        }
        catch (Exception e) {
            flag = false;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public R doUploadFile(String path, String upload_id, String upload_Type) {
        if (StringUtils.isEmpty((CharSequence)upload_id)) {
            return new R(Boolean.valueOf(false), "\u4e0a\u4f20\u6570\u636e\u4e22\u5931!");
        }
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            if (this.savePath(Long.parseLong(upload_id), path, upload_Type)) {
                return new R(Boolean.valueOf(true), path);
            }
            return new R(Boolean.valueOf(false), "\u4e0a\u4f20\u66f4\u65b0\u5931\u8d25");
        }
        return new R(Boolean.valueOf(false), "\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25!");
    }

    @Override
    public PageResult query(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.queryCnt(p)), this.dao.query(p));
    }

    @Override
    public PageResult queryDetail(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao2.queryDetailCnt(p)), this.dao2.queryDetail(p));
    }

    @Override
    public PageResult queryOldPerson(Map<Object, Object> p) {
        List<Map<Object, Object>> resultSetList = this.dao2.queryOldPersonFromResultSet(p);
        Iterator<Map<Object, Object>> iterator = resultSetList.iterator();
        if (iterator.hasNext()) {
            Map<Object, Object> map = iterator.next();
            String name = String.valueOf(map.get("name_cn"));
            if (!"null".equals(String.valueOf(map.get("name_cn")))) {
                return new PageResult(Integer.valueOf(this.dao2.queryOldPersonFromResultSetCnt(p)), this.dao2.queryOldPersonFromResultSet(p));
            }
            return new PageResult(Integer.valueOf(this.dao2.queryOldPersonCnt(p)), this.dao2.queryOldPerson(p));
        }
        return null;
    }

    @Override
    public PageResult queryPay(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.queryPayCnt(p)), this.dao.queryPay(p));
    }

    @Override
    public PageResult queryBillPay(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.queryBillPayCnt(p)), this.dao.queryBillPay(p));
    }

    @Override
    public PageResult queryChildBillPay(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.queryChildBillPayCnt(p)), this.dao.queryChildBillPay(p));
    }

    @Override
    public PageResult querySettlementPay(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.querySettlementPayCnt(p)), this.dao.querySettlementPay(p));
    }

    @Override
    public PageResult queryChildSettlementPay(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.queryChildSettlementPayCnt(p)), this.dao.queryChildSettlementPay(p));
    }

    @Override
    public void downBillPay(String pay_status, String start_time, String end_time, String keyword, HttpServletResponse response) {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("pay_status", pay_status);
        p.put("start_time", start_time);
        p.put("end_time", end_time);
        p.put("keyword", keyword);
        p.put("offset", 0);
        p.put("limit", 10000);
        List<Map<Object, Object>> maps = this.dao.queryBillPay(p);
        ExcelUtil util = new ExcelUtil(InsPreservationPayExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword + "\u6c47\u603b\u8d26\u5355\u6e05\u5355.xls").getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            ArrayList addMap = Lists.newArrayList();
            for (Map<Object, Object> map : maps) {
                addMap.add(new InsPreservationPayExcelVo(map.get("external_reference") != null ? map.get("external_reference").toString() : "", map.get("company_name") != null ? map.get("company_name").toString() : "", map.get("app_role_name") != null ? map.get("app_role_name").toString() : "", map.get("record_count") != null ? map.get("record_count").toString() : "", map.get("predict_total_amount") != null ? map.get("predict_total_amount").toString() : "", map.get("star_pay_time") != null ? map.get("star_pay_time").toString() : "", map.get("end_pay_time") != null ? map.get("end_pay_time").toString() : "", map.get("build_data") != null ? map.get("build_data").toString() : "", SysDictUtils.getDictLabel((String)(map.get("pay_status") != null ? map.get("pay_status").toString() : ""), (String)"billPayStatus", (String)""), map.get("is_part") != null && Integer.parseInt(map.get("is_part").toString()) == 1 ? "\u90e8\u5206\u8d26\u5355" : "\u6c47\u603b\u8d26\u5355", map.get("is_fp") != null && Integer.parseInt(map.get("is_fp").toString()) == 1 ? "\u662f" : "\u5426"));
            }
            util.exportExcel((List)addMap, keyword + "\u6c47\u603b\u8d26\u5355\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void downChildBillPay(Long parentPayId, String pay_status, String start_time, String end_time, String keyword, HttpServletResponse response) {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("pay_status", pay_status);
        p.put("start_time", start_time);
        p.put("end_time", end_time);
        p.put("keyword", keyword);
        p.put("parentPayId", parentPayId);
        p.put("offset", 0);
        p.put("limit", 10000);
        List<Map<Object, Object>> maps = this.dao.queryChildBillPay(p);
        ExcelUtil util = new ExcelUtil(InsPreservationPayChildExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword + "\u5b50\u8d26\u5355\u6e05\u5355.xls").getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            ArrayList addMap = Lists.newArrayList();
            for (Map<Object, Object> map : maps) {
                addMap.add(new InsPreservationPayChildExcelVo(map.get("external_reference") != null ? map.get("external_reference").toString() : "", map.get("company_name") != null ? map.get("company_name").toString() : "", map.get("insurance_name") != null ? map.get("insurance_name").toString() : "", map.get("app_role_name") != null ? map.get("app_role_name").toString() : "", SysDictUtils.getDictLabel((String)(map.get("pay_status") != null ? map.get("pay_status").toString() : ""), (String)"payStatus", (String)""), map.get("record_count") != null ? map.get("record_count").toString() : "", map.get("add_count") != null ? map.get("add_count").toString() : "", map.get("minus_count") != null ? map.get("minus_count").toString() : "", map.get("replace_count") != null ? map.get("replace_count").toString() : "", map.get("predict_total_amount") != null ? map.get("predict_total_amount").toString() : "", map.get("fact_total_amount") != null ? map.get("fact_total_amount").toString() : "", map.get("star_pay_time") != null ? map.get("star_pay_time").toString() : "", map.get("end_pay_time") != null ? map.get("end_pay_time").toString() : ""));
            }
            util.exportExcel((List)addMap, keyword + "\u5b50\u8d26\u5355\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void downChildSettlementBillPay(Long parentPayId, String start_time, String end_time, String keyword, HttpServletResponse response) {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("start_time", start_time);
        p.put("end_time", end_time);
        p.put("keyword", keyword);
        p.put("parentPayId", parentPayId);
        p.put("offset", 0);
        p.put("limit", 10000);
        List<Map<Object, Object>> maps = this.dao.queryChildSettlementPay(p);
        ExcelUtil util = new ExcelUtil(InsPreservationPayChildExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword + "\u5b50\u8d26\u5355\u6e05\u5355.xls").getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            ArrayList addMap = Lists.newArrayList();
            for (Map<Object, Object> map : maps) {
                addMap.add(new InsPreservationPayChildExcelVo(map.get("external_reference") != null ? map.get("external_reference").toString() : "", map.get("company_name") != null ? map.get("company_name").toString() : "", map.get("insurance_name") != null ? map.get("insurance_name").toString() : "", map.get("app_role_name") != null ? map.get("app_role_name").toString() : "", SysDictUtils.getDictLabel((String)(map.get("pay_status") != null ? map.get("pay_status").toString() : ""), (String)"payStatus", (String)""), map.get("record_count") != null ? map.get("record_count").toString() : "", map.get("add_count") != null ? map.get("add_count").toString() : "", map.get("minus_count") != null ? map.get("minus_count").toString() : "", map.get("replace_count") != null ? map.get("replace_count").toString() : "", map.get("predict_total_amount") != null ? map.get("predict_total_amount").toString() : "", map.get("fact_total_amount") != null ? map.get("fact_total_amount").toString() : "", map.get("star_pay_time") != null ? map.get("star_pay_time").toString() : "", map.get("end_pay_time") != null ? map.get("end_pay_time").toString() : ""));
            }
            util.exportExcel((List)addMap, keyword + "\u5b50\u8d26\u5355\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject createPartBill(String isSummaryBill, String[] payIds) {
        int isConsistent;
        JSONObject json = new JSONObject();
        if (payIds == null || payIds.length < 1) {
            json.put("status", (Object)"300");
            json.put("msg", (Object)"\u65e0\u6709\u6548\u8d26\u5355");
            return json;
        }
        if ("1".equals(isSummaryBill)) {
            if (payIds.length < 2) {
                json.put("status", (Object)"300");
                json.put("msg", (Object)"\u5355\u6761\u6c47\u603b\u8d26\u5355\u53ef\u76f4\u63a5\u5b8c\u6210\u7f34\u8d39\u4e1a\u52a1");
                return json;
            }
        } else {
            Map<String, String> map;
            isConsistent = this.dao.isConsistentAccount(isSummaryBill, payIds);
            if (isConsistent > 1) {
                json.put("status", (Object)"300");
                json.put("msg", (Object)"\u4e0d\u662f\u540c\u8d26\u53f7\u4e0b\u7684\u8d26\u5355\uff0c\u65e0\u6cd5\u5408\u5e76");
                return json;
            }
            String partBillSign = this.dao.isPartBillSign(payIds);
            if (StringUtils.isNotEmpty((CharSequence)partBillSign)) {
                json.put("status", (Object)"300");
                json.put("msg", (Object)("\u8fd9\u4e9b\u8d26\u5355\u7f16\u7801\u5df2\u751f\u6210\u90e8\u5206\u8d26\u5355\uff0c\u65e0\u6cd5\u91cd\u590d\u751f\u6210\uff1a" + partBillSign));
                return json;
            }
            List<Map<String, String>> isConsistentSummaryBill = this.dao.isConsistentSummaryBill(payIds);
            if (isConsistentSummaryBill.size() == 1 && "1".equals((map = isConsistentSummaryBill.get(0)).get("isAll"))) {
                json.put("status", (Object)"300");
                json.put("msg", (Object)("\u64cd\u4f5c\u5bf9\u8c61\u5f52\u5c5e\u540c\u4e00\u8d26\u5355\uff0c\u65e0\u6cd5\u91cd\u590d\u751f\u6210\uff1a" + map.get("external_reference")));
                return json;
            }
        }
        if ((isConsistent = this.dao.isConsistentInsurancePlan(isSummaryBill, payIds)) > 1) {
            json.put("status", (Object)"300");
            json.put("msg", (Object)"\u8d26\u5355\u9669\u79cd\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5408\u5e76");
            return json;
        }
        List<InsPreservationPay> billMergeList = this.dao.consistentBillMerge(isSummaryBill, payIds);
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        for (InsPreservationPay ipPay : billMergeList) {
            Long ins_preservation_pay_id = idWorker.nextId();
            ipPay.setExternal_reference("BFZD" + ins_preservation_pay_id);
            ipPay.setIns_preservation_pay_id(ins_preservation_pay_id);
            ipPay.setParent_part_bill_id(ins_preservation_pay_id);
            String[] pays = ipPay.getPay_list().split(",");
            this.insPreservationPayService.insert(ipPay);
            this.dao.updateParentPartBillId(ins_preservation_pay_id, "5", pays);
        }
        json.put("status", (Object)"200");
        json.put("msg", (Object)"\u90e8\u5206\u8d26\u5355\u5b8c\u6210\u5408\u5e76");
        return json;
    }

    @Override
    public JSONObject createPartBillByNo(String isSummaryBill, String[] payNos) {
        String payIds = this.dao.findPayIdsByPayNos(payNos);
        return this.createPartBill(isSummaryBill, payIds.split(","));
    }

    @Override
    public InsPreservationRecordVo accordingToApplyIDToGetpreservationRecordVo(Long record_id) {
        List<InsPreservationRecordVo> listVo = this.dao.findRecordFormVoByID(record_id);
        if (listVo != null) {
            InsPreservationRecordVo vo = listVo.get(0);
            return vo;
        }
        return null;
    }

    @Override
    public PageResult queryPayDetail(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.queryPayDetailCnt(p)), this.dao.queryPayDetail(p));
    }

    @Override
    public int updatedetailFormStatus(InsPreservationDetailVo vo) {
        int result = this.dao2.updataDetailFormByKeyword(vo.getOid(), vo.getStatus(), vo.getRemark());
        return result;
    }

    @Override
    public void downRecordResultSet(String keyword, String name, String start_time, String end_time, HttpServletResponse response) {
        ExcelUtil util = new ExcelUtil(RecordExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u5ba1\u6838\u4fdd\u5168\u4eba\u5458.xls".getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            List<RecordExcelVo> listMap = this.dao2.downRecordResultSet(keyword, name, start_time, end_time, "GZZRX-ZH");
            ArrayList addMap = Lists.newArrayList();
            for (RecordExcelVo vo : listMap) {
                if (!StringUtils.isNotEmpty((CharSequence)vo.getTjData())) continue;
                RecordExcelVo addVo = (RecordExcelVo)MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)new RecordExcelVo());
                String[] arr = vo.getTjData().split("#");
                addVo.setName(arr[0]);
                addVo.setId_card(arr[1]);
                addVo.setTel(arr[2]);
                addVo.setRevise_type("\u51cf\u5458");
                addMap.add(addVo);
            }
            if (addMap.size() > 0) {
                listMap.addAll(addMap);
            }
            util.exportExcel(listMap, "\u5ba1\u6838\u4fdd\u5168\u4eba\u5458", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void downRecordDetail(String keyword, String name, String start_time, String end_time, HttpServletResponse response) {
        ExcelUtil util = new ExcelUtil(RecordDetailExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword + "\u4fdd\u5168\u5355\u660e\u7ec6.xls").getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            List<RecordDetailExcelVo> listMap = this.dao2.downRecordDetail(keyword, name, start_time, end_time);
            ArrayList addMap = Lists.newArrayList();
            for (RecordDetailExcelVo vo : listMap) {
                if (!StringUtils.isNotEmpty((CharSequence)vo.getTjData())) continue;
                RecordDetailExcelVo addVo = (RecordDetailExcelVo)MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)new RecordDetailExcelVo());
                String[] arr = vo.getTjData().split("#");
                addVo.setName(arr[0]);
                addVo.setId_card(arr[1]);
                addVo.setTel(arr[2]);
                addVo.setRevise_type("\u51cf\u5458");
                addMap.add(addVo);
            }
            if (addMap.size() > 0) {
                listMap.addAll(addMap);
            }
            util.exportExcel(listMap, keyword + "\u4fdd\u5168\u5355\u660e\u7ec6", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void downSuccessResultSet(String keyword, String name, String start_time, String end_time, String type, String isGQ, HttpServletResponse response) {
        ExcelUtil util = new ExcelUtil(RecordSuccessExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword + "\u6279\u5355\u901a\u8fc7\u4eba\u5458\u6e05\u5355.xls").getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            List<RecordSuccessExcelVo> listMap = "0".equals(isGQ) ? this.dao2.downSuccessResultSet(keyword, name, start_time, end_time, type) : this.dao2.downSuccessResultSetGQ(keyword, start_time, end_time, type);
            ArrayList addMap = Lists.newArrayList();
            for (RecordSuccessExcelVo vo : listMap) {
                if (!StringUtils.isNotEmpty((CharSequence)vo.getTjData())) continue;
                RecordSuccessExcelVo addVo = (RecordSuccessExcelVo)MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)new RecordSuccessExcelVo());
                String[] arr = vo.getTjData().split("#");
                addVo.setName(arr[0]);
                addVo.setId_card(arr[1]);
                addVo.setRevise_type("\u51cf\u5458");
                addMap.add(addVo);
            }
            if (addMap.size() > 0) {
                listMap.addAll(addMap);
            }
            util.exportExcel(listMap, keyword + "\u6279\u5355\u901a\u8fc7\u4eba\u5458\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int updateRecordStatus(InsPreservationRecordVo vo) {
        int result = this.dao.updateRecordStatus(vo);
        log.info(vo.getRevise_path());
        return result;
    }

    @Override
    public int updateReleaseTime(InsPreservationRecordVo vo) {
        int result = this.dao.updateRelease_time(vo.getOid(), vo.getRevise_status());
        return result;
    }

    public int saveResultSet(InsPreservationRecordVo vo) {
        ArrayList l = Lists.newArrayList();
        for (Map m : l) {
            InsPreservationResultSet is = (InsPreservationResultSet)DOM.mtd((Map)m, (Object)new InsPreservationResultSet());
            this.insPreservationResultSetService.insertOrUpdate(is);
        }
        int result = 1;
        return result;
    }

    @Override
    public R saveSurrenderRecord(SurrenderVo surrenderVo, OrderFormVo vo, HttpServletRequest request) {
        List<InsPreservationDetail> details = this.dao2.findZBPer(vo.getOid());
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        Date t = new Date();
        InsPreservationRecord ipr = new InsPreservationRecord();
        ipr.setInception_date(DateUtil.parseDate((String)surrenderVo.getInception_date()));
        ipr.setStart_time(t);
        ipr.setIns_insurance_slip_id(Long.valueOf(Long.parseLong(vo.getOid())));
        ipr.setRevise_serial_number(String.valueOf(idWorker.nextId()));
        ipr.setRevise_status("2");
        ipr.setRevise_type("2");
        ipr.setAdd_count(0);
        ipr.setMinus_count(details.size());
        ipr.setReplace_count(0);
        ipr.setApp_role_name(vo.getApplicant_name());
        ipr.setPlanned_end_date(DateUtil.convertStringToDate((String)vo.getPlanned_end_date()));
        ipr.setExternal_reference(vo.getExternal_reference());
        ipr.setSys_client_user_id(Long.valueOf(Long.parseLong(vo.getUser_oid())));
        ipr.setSys_ins_company_id(Long.valueOf(Long.parseLong(vo.getInsurance_oid())));
        ipr.setTotal_premium(new BigDecimal(surrenderVo.getPremium()));
        ipr.setRemark("\u9000\u4fdd\u6279\u51cf\u64cd\u4f5c");
        this.dao.insert(ipr);
        for (InsPreservationDetail detail : details) {
            detail.setIns_preservation_record_id(ipr.getIns_preservation_record_id());
            detail.setRevise_time(t);
            detail.setRevise_type("2");
            detail.setBusiness_type("PRESERVE");
            detail.setStatus(0);
            this.dao2.insert(detail);
        }
        HashMap p = Maps.newHashMap();
        p.put("record_id", ipr.getIns_preservation_record_id());
        p.put("inception_date", ipr.getInception_date());
        p.put("total_premium", ipr.getTotal_premium());
        p.put("revise_status", "4");
        p.put("revise_serial_num_ins", ipr.getExternal_reference() + "TB");
        p.put("sup_id", "sup_admin");
        return this.updataReviseStatus(p, request);
    }

    @Override
    public R pushResultSetByRecord(Long record_id, String revise_type) {
        try {
            Long[] longs;
            Long[] _l;
            int count;
            InsPreservationResultSet iprs;
            int status = 0;
            Date date = new Date();
            HashMap params = Maps.newHashMap();
            params.put("id", record_id);
            params.put("exclude", "2");
            List<Map<Object, Object>> l = this.dao2.queryDetail(params);
            InsPreservationRecordVo recordVo = this.dao.findInsPreservationRecordVoById(record_id);
            ArrayList l2 = Lists.newArrayList();
            ArrayList b1 = Lists.newArrayList();
            if ("1".equals(revise_type)) {
                for (Map<Object, Object> m : l) {
                    iprs = (InsPreservationResultSet)DOM.mtd(m, (Object)new InsPreservationResultSet());
                    iprs.setIns_preservation_result_set_id(Long.valueOf(com.bcxin.mybatisplus.toolkit.IdWorker.getId()));
                    iprs.setRevise_time(date);
                    iprs.setStatus(status);
                    iprs.setIns_insurance_slip_id(Long.valueOf(Long.parseLong(recordVo.getIns_insurance_slip_id())));
                    iprs.setBelong_to_type("PRESERVE");
                    l2.add(iprs);
                }
            } else if ("2".equals(revise_type)) {
                for (Map<Object, Object> m : l) {
                    b1.add((Long)m.get("belong_to_id"));
                }
            } else if ("3".equals(revise_type)) {
                for (Map<Object, Object> m : l) {
                    iprs = (InsPreservationResultSet)DOM.mtd(m, (Object)new InsPreservationResultSet());
                    iprs.setIns_preservation_result_set_id(Long.valueOf(com.bcxin.mybatisplus.toolkit.IdWorker.getId()));
                    iprs.setRevise_time(date);
                    iprs.setStatus(status);
                    iprs.setIns_insurance_slip_id(Long.valueOf(Long.parseLong(recordVo.getIns_insurance_slip_id())));
                    iprs.setBelong_to_type("PRESERVE");
                    iprs.setBelong_to_id(null);
                    l2.add(iprs);
                    b1.add((Long)m.get("belong_to_id"));
                }
            }
            if (l2.size() > 0) {
                this.dao.batchInsert(l2);
            }
            if (b1.size() > 0 && (count = this.dao.batchUpdateStatus(_l = b1.toArray(longs = new Long[b1.size()]), 1, revise_type, DateUtil.getCurrentDate_1())) == 0) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return new R(Boolean.valueOf(false), "\u4e0d\u5b8c\u5168\u4fdd\u5b58\uff0c\u8bf7\u6c42\u5931\u8d25");
            }
            return this.saveTime(record_id);
        }
        catch (NullPointerException nup) {
            log.error("\u4fdd\u5168\u7ed3\u679c\u96c6\u5904\u7406\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)nup);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u751f\u6210\u7ed3\u679c\u96c6\u5931\u8d25,\u7a7a\u5b57\u7b26");
        }
        catch (Exception e) {
            log.error("\u4fdd\u5168\u7ed3\u679c\u96c6\u5904\u7406\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u751f\u6210\u7ed3\u679c\u96c6\u5931\u8d25");
        }
    }

    @Override
    public R saveTime(Long record_id) {
        Date date = new Date();
        InsPreservationRecordVo recordVo = this.accordingToApplyIDToGetpreservationRecordVo(record_id);
        SimpleDateFormat sdf = new SimpleDateFormat();
        String strDate = sdf.format(date);
        recordVo.setRelease_time(strDate);
        if (this.updateReleaseTime(recordVo) <= 0) {
            return new R(Boolean.valueOf(false), "\u66f4\u65b0\u65f6\u95f4\u5931\u8d25");
        }
        return new R(Boolean.valueOf(true), "\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public R getDZPD(Long record_id) {
        HashMap m1 = Maps.newHashMap();
        m1.put("method_name", "getDZPD");
        m1.put("param_value_arr", String.valueOf(record_id));
        m1.put("class_name", "com.bcxin.ins.service.preservation.InsPreservationRecordAPIService");
        List list = this.comTaskResidualService.selectByMap(m1);
        if (list.size() > 0) {
            return new R(Boolean.valueOf(false), "\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u7533\u8bf7");
        }
        this.comTaskResidualService.saveComTaskResidual("getDZPD", "\u91cd\u65b0\u8bbf\u95ee\u5e73\u5b89\u63a5\u53e3\u83b7\u53d6\u7535\u5b50\u6279\u5355", "com.bcxin.ins.service.preservation.InsPreservationRecordAPIService", 1, "Long", String.valueOf(record_id));
        return new R(Boolean.valueOf(true), "\u5df2\u63d0\u4ea4\u7535\u5b50\u6279\u5355\u7533\u8bf7\uff0c\u4e00\u5c0f\u65f6\u540e\u5b8c\u6210\u6279\u5355\u8865\u5f55");
    }

    @Override
    public List<InsPreservationResultSet> findResultSetVoByRecordID(Long record_id) {
        return this.dao.findResultSetVoByRecordID(record_id);
    }

    @Override
    public InsPreservationDetailVo accordingToDetailIDToGetpreservationDetailVo(Long detail_id) {
        List<InsPreservationDetailVo> listVo = this.dao2.findDetailFormVoByID(detail_id);
        if (listVo != null) {
            InsPreservationDetailVo vo = listVo.get(0);
            return vo;
        }
        return null;
    }

    @Override
    public R updataReviseStatus(Map<Object, Object> p, HttpServletRequest request) {
        try {
            Long record_id = Long.valueOf(String.valueOf(p.get("record_id")));
            String inception_date = String.valueOf(p.get("inception_date"));
            String total_premium = String.valueOf(p.get("total_premium"));
            String revise_status = String.valueOf(p.get("revise_status"));
            String revise_serial_num_ins = p.get("revise_serial_num_ins") != null ? String.valueOf(p.get("revise_serial_num_ins")) : "";
            String sup_id = String.valueOf(p.get("sup_id"));
            InsPreservationRecordVo recordVo = this.accordingToApplyIDToGetpreservationRecordVo(record_id);
            if ("3".equals(revise_status)) {
                this.reviseStatus3Set(request, revise_status, sup_id, recordVo);
            } else if ("4".equals(revise_status) && StringUtils.isNotEmpty((CharSequence)total_premium)) {
                if (StringUtils.isEmpty((CharSequence)recordVo.getRevise_serial_num_ins()) && StringUtils.isNotEmpty((CharSequence)revise_serial_num_ins)) {
                    recordVo.setRevise_serial_num_ins(revise_serial_num_ins);
                }
                this.reviseStatus4Set(request, inception_date, total_premium, revise_status, sup_id, recordVo);
            } else {
                return this.reviseStatusOtherReturn(total_premium);
            }
            if (this.updateRecordStatus(recordVo) <= 0) {
                return new R(Boolean.valueOf(false), "\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            if ("3".equals(recordVo.getRevise_status())) {
                this.sendEmailAndTelByRecord(record_id, recordVo.getRevise_status());
            }
            if ("4".equals(revise_status)) {
                this.reviseStatus3Update(record_id, revise_status);
            }
            return new R(Boolean.valueOf(true), "\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7528\u6237\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public Result updataCAReviseStatus(String recordId, String reviseStatus, String remark, String reviseSerialNumIns, String revisePath, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)recordId) || StringUtils.isEmpty((CharSequence)reviseStatus)) {
                return Result.fail((String)"\u6279\u5355\u4fe1\u606f\u4e22\u5931");
            }
            if (!"3".equals(reviseStatus) && !"4".equals(reviseStatus)) {
                return Result.fail((String)"\u6279\u5355\u72b6\u6001\u65e0\u6548");
            }
            InsPreservationRecordVo recordVo = this.accordingToApplyIDToGetpreservationRecordVo(Long.parseLong(recordId));
            if (recordVo == null) {
                return Result.fail((String)"\u672a\u5339\u914d\u5230\u6709\u6548\u6279\u5355");
            }
            String sup_id = "CA-Endorsement-Opinion";
            String inception_date = recordVo.getInception_date();
            String total_premium = recordVo.getTotal_premium();
            if ("3".equals(reviseStatus)) {
                this.reviseStatus3Set(request, reviseStatus, sup_id, recordVo);
            } else {
                this.reviseStatus4Set(request, inception_date, total_premium, reviseStatus, sup_id, recordVo);
            }
            if (StringUtils.isNotEmpty((CharSequence)remark)) {
                recordVo.setRemark(remark);
            }
            if (StringUtils.isNotEmpty((CharSequence)reviseSerialNumIns)) {
                recordVo.setRevise_serial_num_ins(reviseSerialNumIns);
            }
            if (StringUtils.isNotEmpty((CharSequence)revisePath)) {
                recordVo.setRevise_path(revisePath);
            }
            if (this.updateRecordStatus(recordVo) <= 0) {
                return Result.fail((String)"\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            if ("3".equals(reviseStatus)) {
                this.sendEmailAndTelByRecord(Long.parseLong(recordId), reviseStatus);
            }
            if ("4".equals(reviseStatus)) {
                this.reviseStatus4UpdateCA(Long.parseLong(recordId), reviseStatus);
            }
            return Result.success((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u957f\u5b89\u6279\u5355\u901a\u8fc7\u4fee\u6539\u6279\u5355\u72b6\u6001\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return Result.fail((String)"\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25");
        }
    }

    private void reviseStatus4UpdateCA(Long record_id, String revise_status) {
        int paymentPeriod = this.dao.findPaymentPeriod(record_id);
        InsPreservationRecord record = (InsPreservationRecord)this.selectById(record_id);
        Long pay_id = this.dao.selectHavePayID(record_id);
        if (paymentPeriod != 1 && pay_id != null) {
            record.setIns_preservation_pay_id(pay_id);
            this.setResult(record, paymentPeriod, false);
            this.updateById(record);
        } else {
            this.setResult(record, paymentPeriod, true);
        }
        OrderFormVo order = this.insuranceOperationService.accordingToOrderIDToGetOrderFormVo(record.getIns_insurance_slip_id());
        if (order != null && order.getProduct_code().contains("GZZRX-CA")) {
            this.pushResultSetByRecord(record.getIns_preservation_record_id(), record.getRevise_type());
        }
        if (order != null && !order.getWeb_type().contains("BLB")) {
            this.comTaskResidualService.saveComTaskResidual("pushRecordInfo", "\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9", "com.bcxin.ins.service.order.PolicyService", 1, "String", String.valueOf(record_id));
        }
        if (!"1".equals(GlobalResources.IS_CLOSE_RECORD_SYNC)) {
            this.comTaskResidualService.saveComTaskResidual("recordSyncZC", "\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u4e1a\u52a1\u652f\u6491", "com.bcxin.ins.service.order.PolicyService", 1, "String", String.valueOf(record_id));
        }
        this.sendEmailAndTelByRecord(record_id, revise_status);
    }

    private void reviseStatus3Update(Long record_id, String revise_status) {
        int paymentPeriod = this.dao.findPaymentPeriod(record_id);
        InsPreservationRecord record = (InsPreservationRecord)this.selectById(record_id);
        Long pay_id = this.dao.selectHavePayID(record_id);
        if (paymentPeriod != 1 && pay_id != null) {
            record.setIns_preservation_pay_id(pay_id);
            this.setResult(record, paymentPeriod, false);
            this.updateById(record);
        } else {
            this.setResult(record, paymentPeriod, true);
        }
        OrderFormVo order = this.insuranceOperationService.accordingToOrderIDToGetOrderFormVo(record.getIns_insurance_slip_id());
        if (order != null && !order.getWeb_type().contains("BLB")) {
            this.comTaskResidualService.saveComTaskResidual("pushRecordInfo", "\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9", "com.bcxin.ins.service.order.PolicyService", 1, "String", String.valueOf(record_id));
        }
        if (!"1".equals(GlobalResources.IS_CLOSE_RECORD_SYNC)) {
            this.comTaskResidualService.saveComTaskResidual("recordSyncZC", "\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u4e1a\u52a1\u652f\u6491", "com.bcxin.ins.service.order.PolicyService", 1, "String", String.valueOf(record_id));
        }
        this.sendEmailAndTelByRecord(record_id, revise_status);
    }

    private R reviseStatusOtherReturn(String total_premium) {
        if (StringUtils.isEmpty((CharSequence)total_premium)) {
            return new R(Boolean.valueOf(false), "\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25,\u8bf7\u6838\u5bf9\u662f\u5426\u586b\u5165\u4fdd\u5168\u8d39\u7528");
        }
        return new R(Boolean.valueOf(false), "\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25,\u8bf7\u6838\u5bf9\u662f\u5426\u4e0a\u4f20\u5904\u7406\u5355");
    }

    private void reviseStatus4Set(HttpServletRequest request, String inception_date, String total_premium, String revise_status, String sup_id, InsPreservationRecordVo recordVo) {
        this.insuranceOperationService.creatLog(request, "\u4fdd\u5168\u8be6\u60c5-> \u5ba1\u6838\u6210\u529f", null, sup_id);
        recordVo.setRevise_status(revise_status);
        recordVo.setInception_date(inception_date);
        recordVo.setTotal_premium(total_premium);
        recordVo.setUpdate_time(DateUtil.getCurrentDateTime());
    }

    private void reviseStatus3Set(HttpServletRequest request, String revise_status, String sup_id, InsPreservationRecordVo recordVo) {
        this.insuranceOperationService.creatLog(request, "\u4fdd\u5168\u8be6\u60c5-> \u5ba1\u6838\u9000\u56de", null, sup_id);
        recordVo.setRevise_status(revise_status);
    }

    @Override
    public List<InsPreservationRecordVo> listInsPreservationRecordVoByTranNo(String tran_no) {
        return this.dao.listInsPreservationRecordVoByTranNo(tran_no);
    }

    private void sendEmailAndTelByRecord(Long recordId, String status) {
        String personNum;
        String reviseType;
        InsPreservationRecordVo recordVo = this.dao.findInsPreservationRecordVoById(recordId);
        OrderFormVo orderVo = this.insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(recordVo.getIns_insurance_slip_id()));
        List<InsRoleInpolicy> iriList = this.insRoleInpolicyService.getInsRoleInpolicyListByIDAndKind(Long.parseLong(recordVo.getIns_insurance_slip_id()), "1");
        String email = "";
        String tel = "";
        if (iriList.size() > 0) {
            email = iriList.get(0).getLink_email();
            tel = iriList.get(0).getLink_tel();
        }
        String string = "1".equals(recordVo.getRevise_type()) ? "\u589e\u5458" : ("2".equals(recordVo.getRevise_type()) ? "\u51cf\u5458" : (reviseType = "3".equals(recordVo.getRevise_type()) ? "\u66ff\u6362" : ""));
        String string2 = "1".equals(recordVo.getRevise_type()) ? recordVo.getAdd_count() : ("2".equals(recordVo.getRevise_type()) ? recordVo.getMinus_count() : (personNum = "3".equals(recordVo.getRevise_type()) ? recordVo.getReplace_count() : ""));
        if (StringUtils.isNotBlank((CharSequence)email)) {
            this.recordSendEmail(status, recordVo, orderVo, email, reviseType, personNum);
        }
        if (StringUtils.isNotBlank((CharSequence)tel)) {
            this.recordSendSMS(status, recordVo, tel, reviseType, personNum);
        }
    }

    private void recordSendSMS(String status, InsPreservationRecordVo recordVo, String tel, String reviseType, String personNum) {
        String content = "";
        if ("3".equals(status)) {
            content = new MessageModel(recordVo.getStart_time(), reviseType, personNum, recordVo.getRevise_serial_number(), "", EmailMsgType.BQTH).getContent();
            log.info("\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u9000\u56de\u77ed\u4fe1\u53d1\u9001\uff08\u5185\u5bb9htmlContent\uff09:" + content);
            this.mss.sendHuaWeiSMS(new HuaWeiSmsContent("BLB", "B7", tel, JSON.toJSONString((Object)new String[]{recordVo.getStart_time(), reviseType, personNum, recordVo.getRevise_serial_number()})));
        } else if ("4".equals(status)) {
            // empty if block
        }
        log.info("\u4fdd\u5168\u7533\u8bf7\u77ed\u4fe1\u53d1\u9001\uff08\u6536\u4ef6\u4ebaModle-1\uff09:" + tel);
    }

    private void recordSendEmail(String status, InsPreservationRecordVo recordVo, OrderFormVo orderVo, String email, String reviseType, String personNum) {
        EmailMsgRecordType emr = null;
        if ("3".equals(status)) {
            emr = EmailMsgRecordType.RECORD_SEND_BACK;
        } else if ("4".equals(status)) {
            emr = EmailMsgRecordType.RECORD_CHECKED;
        }
        EmailModel emailModel = new EmailModel(emr, recordVo.getStart_time(), reviseType, personNum, orderVo.getTrade_serial_number(), orderVo.getExternal_reference(), recordVo.getRevise_serial_number());
        log.info(emr.getName() + "\u90ae\u4ef6\u53d1\u9001\uff08\u5185\u5bb9htmlContent\uff09:" + emailModel.getContent());
        ArrayList<String> emailList = new ArrayList<String>();
        emailList.add(email.trim());
        log.info(emr.getName() + "\u90ae\u4ef6\u53d1\u9001\uff08\u6536\u4ef6\u4ebaEmail-1\uff09:" + email);
        emailModel.setTo(emailList);
        SendEmailAndMsgUtil.sendEmail((EmailModel)emailModel);
    }

    private void sendEmailAndTelByPay(Long payId) {
        InsPreservationPay ipPay = (InsPreservationPay)this.insPreservationPayService.selectById(payId);
        if (ipPay.getIns_insurance_slip_id() != null) {
            OrderFormVo orderVo = this.insuranceOperationService.accordingToOrderIDToGetOrderFormVo(ipPay.getIns_insurance_slip_id());
            String status = ipPay.getPay_status();
            if ("0".equals(status)) {
                this.status0Email(ipPay, orderVo);
            } else if ("1".equals(status)) {
                this.status1SMS(ipPay, orderVo);
            }
        }
    }

    private void status1SMS(InsPreservationPay ipPay, OrderFormVo orderVo) {
        String tel;
        List<InsRoleInpolicy> iriList = this.insRoleInpolicyService.getInsRoleInpolicyListByIDAndKind(ipPay.getIns_insurance_slip_id(), "1");
        String string = tel = iriList.size() > 0 ? iriList.get(0).getLink_tel() : "";
        if (StringUtils.isNotBlank((CharSequence)tel)) {
            String content = "\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u4e8e[" + DateUtil.convertDateToString((Date)ipPay.getStar_pay_time(), (String)"yyyy-MM-dd") + "]\u81f3[" + DateUtil.convertDateToString((Date)ipPay.getEnd_pay_time(), (String)"yyyy-MM-dd") + "]\u5728\u4fdd\u9669\u5e73\u53f0\u7684\u4fdd\u5168\u7f34\u8d39\u5355\u5df2\u751f\u6210\u3002\u4fdd\u5168\u8d39\u7528\u5171\uff1a[" + ipPay.getFact_total_amount() + "]\u5143\u3002\u8bf7\u53ca\u65f6\u5904\u7406\uff0c\u4ee5\u514d\u5f71\u54cd\u60a8\u7684\u540e\u7eed\u4fdd\u969c\u3002\u3010\u767e\u8054\u4fdd\u3011";
            log.info("\u4fdd\u5168\u7f34\u8d39\u5f85\u652f\u4ed8\u77ed\u4fe1\u53d1\u9001\uff08\u5185\u5bb9htmlContent\uff09:" + content);
            log.info("\u4fdd\u5168\u7f34\u8d39\u5f85\u652f\u4ed8\u77ed\u4fe1\u53d1\u9001\uff08\u6536\u4ef6\u4ebaModle-1\uff09:" + tel);
            this.mss.sendHuaWeiSMS(new HuaWeiSmsContent("BLB", "B9", tel, JSON.toJSONString((Object)new String[]{DateUtil.convertDateToString((Date)ipPay.getStar_pay_time(), (String)"yyyy-MM-dd"), DateUtil.convertDateToString((Date)ipPay.getEnd_pay_time(), (String)"yyyy-MM-dd"), String.valueOf(ipPay.getFact_total_amount())})));
        }
        if (StringUtils.isNotEmpty((CharSequence)orderVo.getWeb_id()) && StringUtils.isNotEmpty((CharSequence)orderVo.getWeb_type()) && orderVo.getWeb_type().contains("SAAS")) {
            this.sendPayMessageBySAAS(orderVo.getWeb_type(), orderVo.getWeb_id());
        }
    }

    private void status0Email(InsPreservationPay ipPay, OrderFormVo orderVo) {
        String[] arrs = this.comDeployConfigService.getValueByKey("exmail").split(";");
        EmailModel emailModel = new EmailModel(EmailMsgRecordType.PAY_PENDING, ipPay.getExternal_reference(), DateUtil.convertDateToString((Date)ipPay.getStar_pay_time(), (String)"yyyy-MM-dd"), DateUtil.convertDateToString((Date)ipPay.getEnd_pay_time(), (String)"yyyy-MM-dd"), orderVo.getInsurance_name());
        log.info("\u4fdd\u5168\u7f34\u8d39\u5f85\u5904\u7406\u90ae\u4ef6\u53d1\u9001\uff08\u5185\u5bb9htmlContent\uff09:" + emailModel.getContent());
        ArrayList<String> emailList = new ArrayList<String>();
        for (int i = 0; i < arrs.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)arrs[i]) || arrs[i].contains(":")) continue;
            emailList.add(arrs[i].trim());
            log.info("\u4fdd\u5168\u7f34\u8d39\u5f85\u5904\u7406\u90ae\u4ef6\u53d1\u9001\uff08\u6536\u4ef6\u4ebaEmail-" + (i + 1) + "\uff09:" + arrs[i]);
        }
        if (emailList.size() > 0) {
            emailModel.setTo(emailList);
            SendEmailAndMsgUtil.sendEmail((EmailModel)emailModel);
        }
    }

    private void sendPayMessageBySAAS(String type, String comId) {
        String url = this.comDeployConfigService.getValueByKey("PATH-" + type) + "/enterprise/blb-api-controller/send-ins-unpaid-msg";
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("comId", comId);
        new Thread(() -> {
            try {
                RestUtil.restful((String)url, (Map)data);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    private boolean sendModleMessage(String type, String content, String mobile) {
        String url = "http://msg.bcxin.com.cn:9165/sms/sendMessage";
        String key = "bcxinABCXIN$1012 ";
        String requestId = System.currentTimeMillis() + "";
        JSONObject json = new JSONObject();
        json.put("type", (Object)type);
        json.put("content", (Object)content);
        json.put("mobile", (Object)mobile);
        json.put("requestId", (Object)requestId);
        json.put("token", (Object)MD5Util.string2MD5((String)(requestId + type + key)));
        try {
            String ret = RequestUtil.initHttp().doPost(url, json.toString(), "application/json", "UTF-8");
            JSONObject retJson = JSONObject.parseObject((String)ret);
            if (retJson.get((Object)"status").equals("200")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private R setResult(InsPreservationRecord record, int paymentPeriod, boolean isFrist) {
        try {
            Date star = DateUtil.convertString2Date((String)(DateUtil.convertDateToString((Date)DateUtil.getFirstDayOfThisMonth(), (String)"yyyy-MM-dd") + " 00:00:00"));
            Date end = DateUtil.convertString2Date((String)(DateUtil.convertDateToString((Date)DateUtil.getLastDayOfThisMonth(), (String)"yyyy-MM-dd") + " 23:59:59"));
            InsPreservationPay ipPay = this.insPreservationPayService.getPayExAndMonth(record.getExternal_reference(), star, end);
            int recordCount = 0;
            int addCount = 0;
            int minusCount = 0;
            int replaceCount = 0;
            String payStatus = "4";
            BigDecimal predictTotal = BigDecimal.ZERO;
            BigDecimal premium = record.getTotal_premium();
            if (ipPay == null) {
                ipPay = new InsPreservationPay();
                ipPay.setIns_preservation_pay_id(Long.valueOf(com.bcxin.mybatisplus.toolkit.IdWorker.getId()));
                record.setIns_preservation_pay_id(ipPay.getIns_preservation_pay_id());
                this.updateById(record);
                ipPay.setSys_client_user_id(record.getSys_client_user_id());
                ipPay.setSys_ins_company_id(record.getSys_ins_company_id());
                ipPay.setIns_insurance_slip_id(record.getIns_insurance_slip_id());
                ipPay.setExternal_reference(record.getExternal_reference());
                ipPay.setApp_role_name(record.getApp_role_name());
                Date date = new Date();
                Date starPayTime = null;
                Date endPayTime = null;
                if (paymentPeriod == 1) {
                    payStatus = "0";
                    starPayTime = date;
                    endPayTime = DateUtil.getDayEnd((Date)date);
                } else if (paymentPeriod == 2) {
                    starPayTime = DateUtil.convertString2Date((String)(DateUtil.convertDateToString((Date)DateUtil.getFirstDayOfThisMonth(), (String)"yyyy-MM-dd") + " 00:00:00"));
                    endPayTime = DateUtil.convertString2Date((String)(DateUtil.convertDateToString((Date)DateUtil.getLastDayOfThisMonth(), (String)"yyyy-MM-dd") + " 23:59:59"));
                } else if (paymentPeriod == 3) {
                    starPayTime = DateUtil.getFirstDayOfThisQuarter();
                    endPayTime = DateUtil.getLastDayOfThisQuarter();
                } else {
                    starPayTime = DateUtil.convertString2Date((String)(DateUtil.getThisYearThisDay() + " 00:00:00"));
                    endPayTime = DateUtil.convertString2Date((String)(DateUtil.getThisYearLastDay() + " 23:59:59"));
                }
                ipPay.setStar_pay_time(starPayTime);
                ipPay.setEnd_pay_time(endPayTime);
            } else {
                recordCount = ipPay.getRecord_count();
                addCount = ipPay.getAdd_count();
                minusCount = ipPay.getMinus_count();
                replaceCount += ipPay.getReplace_count();
                predictTotal = ipPay.getPredict_total_amount();
            }
            predictTotal = predictTotal.add(premium);
            ipPay.setPay_status(payStatus);
            ipPay.setRecord_count(++recordCount);
            ipPay.setAdd_count(addCount += record.getAdd_count());
            ipPay.setReplace_count(replaceCount += record.getReplace_count());
            ipPay.setMinus_count(minusCount += record.getMinus_count());
            ipPay.setPredict_total_amount(predictTotal);
            if (!this.insPreservationPayService.insertOrUpdate(ipPay)) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return new R(Boolean.valueOf(false), "\u7f34\u8d39\u8ba2\u5355\u64cd\u4f5c\u5931\u8d25");
            }
            if ("0".equals(ipPay.getPay_status())) {
                this.sendEmailAndTelByPay(ipPay.getIns_preservation_pay_id());
            }
            return new R(Boolean.valueOf(true), "\u7f34\u8d39\u8ba2\u5355\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7528\u6237\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u7f34\u8d39\u8ba2\u5355\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public R statusUpd(Map<Object, Object> p, HttpServletRequest request) {
        try {
            Long detail_id = Long.valueOf(String.valueOf(p.get("detail_id")));
            String remark = String.valueOf(p.get("remark"));
            InsPreservationDetailVo detailVo = this.accordingToDetailIDToGetpreservationDetailVo(detail_id);
            detailVo.setRemark(remark);
            detailVo.setStatus(String.valueOf(p.get("status")));
            if (this.updatedetailFormStatus(detailVo) <= 0) {
                return new R(Boolean.valueOf(false), "\u7406\u7531\u6dfb\u52a0\u5931\u8d25");
            }
            this.insuranceOperationService.creatLog(request, "\u4fdd\u5168\u8be6\u60c5->\u589e\u51cf\u5ba1\u6838\u672a\u901a\u8fc7" + detailVo.getName(), null, remark);
            return new R(Boolean.valueOf(true), "\u7406\u7531\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7528\u6237\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u7406\u7531\u6dfb\u52a0\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public InsPreservationPayVo accordingToPayIDToGetpreservationPayVo(Long pay_id) {
        List<InsPreservationPayVo> listVo = this.dao.findPayFormVoByID(pay_id);
        if (listVo != null) {
            InsPreservationPayVo vo = listVo.get(0);
            return vo;
        }
        return null;
    }

    @Override
    public boolean accordingToApplyIDToGetStatus(Long detail_id) {
        int result = 0;
        result = this.dao2.queryStatus(detail_id);
        return result != 0;
    }

    @Override
    public R updataPayStatus(Map<Object, Object> p) {
        try {
            String isSummaryBill;
            Long pay_id = Long.valueOf(String.valueOf(p.get("pay_id")));
            InsPreservationPayVo payVo = this.accordingToPayIDToGetpreservationPayVo(pay_id);
            String pay_status = String.valueOf(p.get("pay_status"));
            String pay_order_path = String.valueOf(p.get("pay_order_path"));
            if ("1".equals(pay_status)) {
                String pay_inform_path = String.valueOf(p.get("pay_inform_path"));
                if (StringUtils.isEmpty((CharSequence)pay_inform_path)) {
                    return new R(Boolean.valueOf(false), "\u7f34\u8d39\u901a\u77e5\u5355\u5fc5\u987b\u4e0a\u4f20");
                }
                if (StringUtils.isNotEmpty((CharSequence)pay_order_path)) {
                    pay_status = "2";
                }
            }
            String string = isSummaryBill = payVo.getIs_part() == 1 ? "0" : "1";
            if ("3".equals(pay_status)) {
                int count;
                if (StringUtils.isEmpty((CharSequence)pay_order_path)) {
                    return new R(Boolean.valueOf(false), "\u7f34\u8d39\u51ed\u8bc1\u5fc5\u987b\u4e0a\u4f20");
                }
                String fact_total_amount = String.valueOf(p.get("fact_total_amount"));
                if (StringUtils.isNotEmpty((CharSequence)fact_total_amount)) {
                    payVo.setFact_total_amount(fact_total_amount);
                }
                if (!payVo.getPredict_total_amount().equals(payVo.getFact_total_amount())) {
                    pay_status = "2";
                }
                if ((count = this.dao.isOtherChildBill(isSummaryBill, Long.parseLong(payVo.getOid()))) > 0) {
                    return new R(Boolean.valueOf(false), "\u5b58\u5728\u672a\u5b8c\u6210\u7684\u90e8\u5206\u8d26\u5355\u8bf7\u5148\u5b8c\u6210\u7ed3\u7b97");
                }
            }
            payVo.setPay_status(pay_status);
            if (this.updatePayStatus(payVo) <= 0) {
                return new R(Boolean.valueOf(false), "\u63d0\u4ea4\u5931\u8d25");
            }
            if ("3".equals(payVo.getPay_status())) {
                InsPreservationPay footPay = this.dao.getFootPayByParentId(isSummaryBill, Long.parseLong(payVo.getOid()));
                IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
                footPay.setIns_preservation_pay_id(Long.valueOf(idWorker.nextId()));
                footPay.setFact_total_amount(new BigDecimal(payVo.getFact_total_amount()));
                footPay.setPay_order_path(payVo.getPay_order_path());
                footPay.setPay_inform_path(payVo.getPay_inform_path());
                footPay.setExternal_reference("JSD" + idWorker.nextId());
                this.insPreservationPayService.insertOrUpdate(footPay);
                this.dao.updateParentFootId(footPay.getIns_preservation_pay_id(), payVo.getPay_status(), footPay.getPay_list().split(","));
                this.dao.setRecordPayStatusByPayId(footPay.getPay_list().split(","));
                if (payVo.getIs_part() == 1) {
                    this.dao.updateOverParentPay(footPay.getPay_list().split(","));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)payVo.getIns_insurance_slip_id())) {
                OrderFormVo order = this.insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(payVo.getIns_insurance_slip_id()));
                if (order != null && order.getProduct_code().contains("GZZRX-CA") && "3".equals(payVo.getPay_status())) {
                    this.comTaskResidualService.saveComTaskResidual("getFPTask", "\u957f\u5b89\u96c7\u4e3b\u9669\u6279\u5355\u6708\u7ed3\u540e\u67e5\u8be2\u7535\u5b50\u53d1\u7968", "com.bcxin.ins.service.preservation.InsPreservationPayAPIService", 1, "Long", String.valueOf(pay_id));
                }
                if (order != null && order.getProduct_code().contains("TYX-CA") && "3".equals(payVo.getPay_status())) {
                    this.comTaskResidualService.saveComTaskResidual("getFPTask", "\u957f\u5b89\u56e2\u610f\u9669\u6279\u5355\u6708\u7ed3\u540e\u67e5\u8be2\u7535\u5b50\u53d1\u7968", "com.bcxin.ins.service.preservation.InsPreservationPayAPIService", 1, "Long", String.valueOf(pay_id));
                }
            }
            if ("1".equals(payVo.getPay_status())) {
                this.sendEmailAndTelByPay(Long.parseLong(payVo.getOid()));
            }
            return new R(Boolean.valueOf(true), "\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u7f34\u8d39\u72b6\u6001\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u63d0\u4ea4\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public R overPay(Map<Object, Object> p) {
        try {
            Long pay_id = Long.valueOf(String.valueOf(p.get("pay_id")));
            InsPreservationPayVo payVo = this.accordingToPayIDToGetpreservationPayVo(pay_id);
            payVo.setFact_total_amount(payVo.getPredict_total_amount());
            payVo.setPay_status("3");
            if (this.updatePayStatus(payVo) <= 0) {
                return new R(Boolean.valueOf(false), "\u63d0\u4ea4\u5931\u8d25");
            }
            OrderFormVo order = this.insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(payVo.getIns_insurance_slip_id()));
            if (order != null && order.getProduct_code().contains("GZZRX-CA") && "3".equals(payVo.getPay_status())) {
                this.comTaskResidualService.saveComTaskResidual("getFPTask", "\u957f\u5b89\u96c7\u4e3b\u9669\u6279\u5355\u6708\u7ed3\u540e\u67e5\u8be2\u7535\u5b50\u53d1\u7968", "com.bcxin.ins.service.preservation.InsPreservationPayAPIService", 1, "Long", String.valueOf(pay_id));
            }
            if (order != null && order.getProduct_code().contains("TYX-CA") && "3".equals(payVo.getPay_status())) {
                this.comTaskResidualService.saveComTaskResidual("getFPTask", "\u957f\u5b89\u56e2\u610f\u9669\u6279\u5355\u6708\u7ed3\u540e\u67e5\u8be2\u7535\u5b50\u53d1\u7968", "com.bcxin.ins.service.preservation.InsPreservationPayAPIService", 1, "Long", String.valueOf(pay_id));
            }
            if ("1".equals(payVo.getPay_status())) {
                this.sendEmailAndTelByPay(Long.parseLong(payVo.getOid()));
            }
            return new R(Boolean.valueOf(true), "\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7528\u6237\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u63d0\u4ea4\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public int updatePayStatus(InsPreservationPayVo vo) {
        int result = this.dao.updatePayStatus(vo.getOid(), vo.getFact_total_amount(), vo.getPay_status());
        return result;
    }

    @Override
    public R findCheckPendingPreservationRecord() {
        try {
            String date = DateUtil.dateAdd((int)3, (String)DateUtil.getCurrentDate(), (int)-2);
            List<Map> list = this.dao.findCheckPendingPreservationRecord(date + " 00:00:00");
            if (list.size() == 0) {
                return new R(Boolean.valueOf(false), "\u6682\u65e0\u5f85\u529e\u4e8b\u9879");
            }
            return new R(Boolean.valueOf(true), list);
        }
        catch (Exception e) {
            return new R(Boolean.valueOf(false), "\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
    }

    @Override
    public PageResult queryResultSet(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.queryResultSetCnt(p)), this.dao.queryResultSet(p));
    }

    @Override
    public void downResultSet(Map<Object, Object> p, HttpServletResponse response) {
        String fileName = p.get("external_reference") + "-\u5728\u4fdd\u4eba\u5458.xls";
        try {
            fileName = new String(fileName.getBytes("gb2312"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ExcelUtil util = new ExcelUtil(ResultSetExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        try (ServletOutputStream os = response.getOutputStream();){
            List<ResultSetExcelVo> voList = this.dao.queryResultSetVo(p);
            util.exportExcel(voList, p.get("external_reference") + "\u5728\u4fdd\u4eba\u5458", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deletePresever(Long orderID) {
        this.dao.updateResultSetStatus(orderID);
        if (this.dao.recordCount(orderID) > 0) {
            this.dao.deleteRecord(orderID);
            this.dao.deletePay(orderID);
        }
    }

    @Override
    public R setPdNo(Map<Object, Object> p, HttpServletRequest request) {
        try {
            String pdNo = String.valueOf(p.get("pdNo"));
            if (StringUtils.isEmpty((CharSequence)pdNo)) {
                return new R(Boolean.valueOf(false), "\u6279\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String[] arr = pdNo.split(",");
            if (this.dao.setPdNo(arr) == 0) {
                return new R(Boolean.valueOf(false), "\u672a\u5339\u914d\u5230\u6709\u6548\u8bb0\u5f55");
            }
            return new R(Boolean.valueOf(true), "\u7ed3\u7b97\u72b6\u6001\u8bbe\u7f6e\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u6279\u5355\u7ed3\u7b97\u72b6\u6001\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u8bbe\u7f6e\u6279\u5355\u7ed3\u7b97\u72b6\u6001\u64cd\u4f5c\u5931\u8d25");
        }
    }
}

