/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.filter;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.dto.oauth.AccessToken;
import com.bcxin.ins.service.oauth.OAuthService;
import com.bcxin.ins.spring.util.SpringContextHolder;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.ParameterRequestWrapper;
import com.bcxin.ins.util.toolbox.StrUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlFilter
implements Filter {
    protected final Logger logger = LoggerFactory.getLogger(AccessControlFilter.class);

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        OAuthService oAuthService;
        String referer_url;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String spath = request.getServletPath();
        String path = request.getRequestURL().toString().split("\\?")[0];
        if (spath.startsWith("/static") || spath.startsWith("/user/login") || spath.startsWith("/servlet/validateCodeServlet") || spath.startsWith("/admin") || spath.startsWith("/resources") || spath.startsWith("/weixin") || path.endsWith(".css") || path.endsWith(".js") || path.endsWith(".png") || path.endsWith(".jpg") || path.endsWith(".pdf") || path.endsWith(".gif") || path.endsWith(".woff2") || path.endsWith(".ico")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.logger.error("request url:" + request.getRequestURL().toString());
        this.logger.error("request Params:" + JSONObject.toJSONString((Object)request.getParameterMap()));
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Headers", "x-requested-with,content-type,Content-type,authorization,x-csrf-token,access_token");
        response.setHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        String access_token = request.getParameter("ACCESS_TOKEN");
        if (StringUtils.isEmpty((CharSequence)access_token) && StringUtils.isNotEmpty((CharSequence)(referer_url = request.getHeader("Referer"))) && referer_url.contains("ACCESS_TOKEN=") && !referer_url.endsWith("ACCESS_TOKEN=")) {
            String x_at = referer_url.split("ACCESS_TOKEN=")[1];
            if (x_at.length() == 32) {
                access_token = x_at;
            } else if (x_at.length() > 32) {
                if (x_at.contains("&")) {
                    x_at = x_at.split("&")[0];
                }
                if (x_at.length() > 0) {
                    access_token = x_at;
                }
            }
        }
        this.logger.error("request access_token:" + access_token);
        AccessToken accessToken = null;
        if (StringUtils.isNotEmpty((CharSequence)access_token) && (oAuthService = (OAuthService)SpringContextHolder.getBean(OAuthService.class)) != null) {
            accessToken = oAuthService.getAccessToken(access_token);
            if (accessToken != null) {
                request.setAttribute("create_by", (Object)accessToken.getUserId());
                request.setAttribute("update_by", (Object)accessToken.getUserId());
                request.setAttribute("webId", (Object)accessToken.getWebId());
                HashMap<String, String> paramter = new HashMap<String, String>();
                if (StrUtil.isEmpty((String)request.getParameter("webId"))) {
                    paramter.put("webId", accessToken.getWebId());
                }
                paramter.put("create_by", accessToken.getUserId());
                paramter.put("update_by", accessToken.getUserId());
                paramter.put("ACCESS_TOKEN", access_token);
                ParameterRequestWrapper wrapper = new ParameterRequestWrapper(request, paramter);
                filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
                return;
            }
            if (!(request.getServletPath().startsWith("/api/thr") || request.getServletPath().startsWith("/api/preservation") || request.getServletPath().startsWith("/app/report"))) {
                response.sendRedirect(GlobalResources.BASE_URL + "/user/login");
                return;
            }
        }
        if (!this.decide(request.getServletPath())) {
            response.sendRedirect(GlobalResources.BASE_URL + "/user/login");
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean decide(String path) {
        String[] ignorePath = new String[]{"/test", "/synopsis", "/admin", "/api", "/base64", "/dwz", "/file", "/getResource", "/static", "/inform", "/infoNews", "/news", "/CA-API", "/QH-API", "/TB-API", "/user/login", "/PAC-API", "/RB-API", "/ZH-API", "/HT-API", "/TBAPI/GYX/syntony-service", "/insurance/gzzrx/transaction/syntony-service", "/insurance/gzzrx/transaction/syntony-service-record", "/insurance/gyx/transaction/syntony-service", "/insurance/gzx/transaction/syntony-service", "/transaction", "/insurance/tyx/transaction/syntony-service", "/insurance/zzx/transaction/syntony-service", "/insurance/build/product", "/insurance/gyx/product", "/insurance/gzx/product", "/insurance/gzzrx/product", "/insurance/lawsuit/product", "/insurance/gmr/product", "/insurance/customs/product", "/insurance/lote/product", "/insurance/gzzrx/policy/natureChange", "/weixin", "/insuranceService", "/policies_1", "/policies_2", "/policies_3", "/policies_4", "/footer_partners", "/footer_blogroll", "/config", "/getIframeUrl", "/user", "/app", "/resources", "/favicon.ico", "/pc/order/exportDetailByOrderID", "/insurance/product"};
        if (path.equals("/")) {
            return true;
        }
        for (String str : ignorePath) {
            if (!path.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

