/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.preservation.controller;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationDetailAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/pc/preservation/resultSet"})
public class InsPreservationResultSetController
extends BaseController {
    @Autowired
    private InsPreservationResultSetAPIService insPreservationResultSetAPIService;
    @Autowired
    private InsPreservationDetailAPIService insPreservationDetailAPIService;
    @Autowired
    private InsPreservationRecordAPIService insPreservationRecordAPIService;
    @Autowired
    private PolicyService policyService;
    private static String RESULTSETLIST = "resultSetList";
    private static String STATUS = "status";
    private static String START_TIME = "start_time";
    private static String END_TIME = "end_time";
    private static String KEYWORD = "keyword";
    private static String PRESERVATIONID = "preservationId";
    private static String POLICYID = "policyId";
    private static String NOWDATE = "nowDate";
    private static String IPRSVOLIST = "iprsVoList";
    private static String ORDERVO = "orderVo";
    private static String MIN = "min";
    private static String MAX = "max";

    @LoginRequired(methodParamKey={"0#policyId"}, requestParamKey={"keyword"}, redirectUrl="pc/preservation/resultSet/resultSetList?policyId={policyId}&keyword={keyword}")
    @RequestMapping(value={"resultSetList"})
    public ModelAndView resultSetList(Long policyId, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/resultSetList");
        page.setNumPerPage(10);
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        if (userdetail.getOid().equals(orderVo.getUser_oid())) {
            view.addObject(RESULTSETLIST, (Object)this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page, policyId, keyword, "0", "", ""));
            view.addObject(ORDERVO, (Object)orderVo);
        }
        view.addObject(KEYWORD, (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"getResultSetListForPage"})
    public ModelAndView ListForPage(Long policyId, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/resultSetList_table");
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        if (userdetail.getOid().equals(orderVo.getUser_oid())) {
            view.addObject(RESULTSETLIST, (Object)this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page, policyId, keyword, "0", "", ""));
        }
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#policyId"}, requestParamKey={"keyword"}, redirectUrl="pc/preservation/resultSet/resultSetList?policyId={policyId}&keyword={keyword}")
    @RequestMapping(value={"noResultSetList"})
    public ModelAndView noResultSetList(Long policyId, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/noResultSetList");
        page.setNumPerPage(10);
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        if (userdetail.getOid().equals(orderVo.getUser_oid())) {
            view.addObject(RESULTSETLIST, (Object)this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page, policyId, keyword, "1", start_time, et));
            view.addObject(ORDERVO, (Object)orderVo);
        }
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"getNoResultSetListForPage"})
    public ModelAndView getNoResultSetListForPage(Long policyId, String start_time, String end_time, String keyword, DwzPage page) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/noResultSetList_table");
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        if (userdetail.getOid().equals(orderVo.getUser_oid())) {
            view.addObject(RESULTSETLIST, (Object)this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page, policyId, keyword, "1", start_time, et));
        }
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"schemeDetail"})
    public ModelAndView schemeDetail(Long policyId) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/scheme_detail");
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        view.addObject(ORDERVO, (Object)orderVo);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"add_preservation_view"})
    public ModelAndView add_preservation_view(Long policyId, Long preservationId) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/add_preservation_list");
        if (preservationId != null) {
            view.addObject(IPRSVOLIST, (Object)this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId));
        }
        String resultDate = this.insPreservationRecordAPIService.getEffectiveByPolicyId(policyId);
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        view.addObject(ORDERVO, (Object)orderVo);
        view.addObject(MIN, (Object)resultDate.split(",")[0]);
        view.addObject(MAX, (Object)resultDate.split(",")[1]);
        view.addObject(POLICYID, (Object)policyId);
        view.addObject(PRESERVATIONID, (Object)preservationId);
        view.addObject(NOWDATE, (Object)DateUtil.getCurrentDateTime());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"add_upload_view"})
    public ModelAndView add_upload_view(Long preservationId, HttpServletRequest request) {
        String product_code = request.getParameter("product_code");
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/add_upload_list");
        if (preservationId != null) {
            view.addObject(IPRSVOLIST, (Object)this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId));
        }
        view.addObject("product_code", (Object)product_code);
        view.addObject(IPRSVOLIST, this.getValueSession());
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_RECORD, title="\u3010\u8bf7\u6c42\u3011\u4e2a\u4eba\u4e2d\u5fc3-\u589e\u5458")
    @LoginRequired
    @RequestMapping(value={"add_preservation_service"})
    @ResponseBody
    public ResultDto add_preservation_service(InsPreservationRecordVo vo, String sign) {
        ArrayList<InsPreservationDetailVo> ipdVoSortList;
        this.stopSubmitAgain("PC_ADD_BQ:" + this.getToken(), 3);
        if (!this.stopSubmitAgain("PC_ADD_BQ:" + this.getToken(), 1)) {
            return new ResultDto("\u4e1a\u52a1\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01", "300", "", "", "");
        }
        if ("1".equals(sign)) {
            ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                if (StringUtils.isEmpty((CharSequence)ipdVo.getName()) && StringUtils.isEmpty((CharSequence)ipdVo.getBirthday()) && StringUtils.isEmpty((CharSequence)ipdVo.getCareer()) && StringUtils.isEmpty((CharSequence)ipdVo.getId_card()) && StringUtils.isEmpty((CharSequence)ipdVo.getId_type()) && StringUtils.isEmpty((CharSequence)ipdVo.getSex())) continue;
                ipdVoSortList.add(ipdVo);
            }
            vo.setInsPreservationDetailVoList(ipdVoSortList);
            vo.resetName();
            String result = this.insPreservationDetailAPIService.batchDetailSortAndValidator(vo);
            if ("300".equals(result.split("#")[0])) {
                this.stopSubmitAgain("PC_ADD_BQ:" + this.getToken(), 3);
                return new ResultDto(result.split("#")[1], "300", "", "", "");
            }
        } else {
            ipdVoSortList = new ArrayList();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                if (!StringUtils.isNotEmpty((CharSequence)ipdVo.getName()) && !StringUtils.isNotEmpty((CharSequence)ipdVo.getId_card()) && !StringUtils.isNotEmpty((CharSequence)ipdVo.getTel()) && !StringUtils.isNotEmpty((CharSequence)ipdVo.getBirthday())) continue;
                ipdVoSortList.add(ipdVo);
            }
            if (ipdVoSortList.size() == 0) {
                this.stopSubmitAgain("PC_ADD_BQ:" + this.getToken(), 3);
                return new ResultDto("\u6682\u5b58\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", "300", "", "", "");
            }
            vo.setInsPreservationDetailVoList(ipdVoSortList);
        }
        String str = this.insPreservationDetailAPIService.isDuplicateIdCardNoToPreservationDetail(vo.getIns_insurance_slip_id(), vo.getInsPreservationDetailVoList());
        if ("300".equals(str.split("#")[0])) {
            this.stopSubmitAgain("PC_ADD_BQ:" + this.getToken(), 3);
            return new ResultDto(str.split("#")[1], "300", "", "", "");
        }
        Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, sign);
        if (map != null) {
            if ("300".equals(map.get("ret"))) {
                this.stopSubmitAgain("PC_ADD_BQ:" + this.getToken(), 3);
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                    this.insPreservationRecordAPIService.recordRestPAC(vo);
                    new Thread(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid())).start();
                }
                return new ResultDto((String)map.get("msg"), "300", "", "", "");
            }
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get("batchApplyNumber")))) {
                vo.setRevise_serial_number((String)map.get("batchApplyNumber"));
            }
        }
        if (this.insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign), vo, vo.getInsPreservationDetailVoList())) {
            if (!"1".equals(sign)) {
                this.stopSubmitAgain("PC_ADD_BQ:" + this.getToken(), 2);
                return new ResultDto("\u4fdd\u5b58\u6210\u529f\uff0c\u8bf7\u8fdb\u5165\u201c\u6279\u6539\u7533\u8bf7\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u4fdd\u5b58\u7684\u6279\u6539\u7533\u8bf7\uff01", "200", "", "", "");
            }
            this.insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
            String m = "\u6279\u6539\u4fe1\u606f\u6210\u529f\u63d0\u4ea4\u5ba1\u6838\uff01";
            if (map != null && !map.containsKey("isPendingApproval")) {
                m = "\u6279\u6539\u4fe1\u606f\u5df2\u901a\u8fc7\u5ba1\u6838\uff01";
            }
            this.stopSubmitAgain("PC_ADD_BQ:" + this.getToken(), 2);
            String payurl = (String)map.get("payurl");
            return new ResultDto(m, "200", vo.getOid(), "", payurl);
        }
        this.stopSubmitAgain("PC_ADD_BQ:" + this.getToken(), 3);
        return new ResultDto("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/last3Record/{redId}/{reNo}"})
    public String last3Record(@PathVariable String redId, @PathVariable String reNo) {
        return this.insPreservationRecordAPIService.last3Record(redId, reNo);
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"minus_or_replace_view"})
    public ModelAndView minus_preservation_view(Long policyId, Long preservationId, String check_some, String operate) {
        ModelAndView view = new ModelAndView();
        if ("minus".equals(operate)) {
            view.setViewName("/coninsweb/personalCenter/preservation/resultSet/minus_preservation_list");
        } else if ("replace".equals(operate)) {
            view.setViewName("/coninsweb/personalCenter/preservation/resultSet/replace_preservation_list");
        }
        InsPreservationRecordVo iprVo = null;
        if (preservationId != null) {
            iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
        } else {
            String[] arr;
            iprVo = new InsPreservationRecordVo();
            iprVo.setIns_insurance_slip_id(String.valueOf(policyId));
            ArrayList<InsPreservationResultSetVo> iprsVoList = new ArrayList<InsPreservationResultSetVo>();
            InsPreservationResultSetVo iprsVo = null;
            for (String str : arr = check_some.split("#")) {
                if (!StringUtils.isNotEmpty((CharSequence)str)) continue;
                String oid = str.split(";")[0];
                String sign = str.split(";")[1];
                iprsVo = this.insPreservationResultSetAPIService.getInsPreservationResultSetVoByOidAndSign(oid, sign);
                iprsVoList.add(iprsVo);
                iprsVo = null;
            }
            iprVo.setInsPreservationResultSetVoList(iprsVoList);
        }
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(policyId);
        view.addObject(ORDERVO, (Object)orderVo);
        String resultDate = this.insPreservationRecordAPIService.getEffectiveByPolicyId(policyId);
        view.addObject(MIN, (Object)resultDate.split(",")[0]);
        view.addObject(MAX, (Object)resultDate.split(",")[1]);
        view.addObject(POLICYID, (Object)policyId);
        view.addObject("check_some", (Object)check_some);
        view.addObject("preservationVo", (Object)iprVo);
        view.addObject(NOWDATE, (Object)DateUtil.getCurrentDateTime());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"replace_upload_view"})
    public ModelAndView replace_upload_view(HttpServletRequest request) {
        String ins_insurance_slip_id = request.getParameter("ins_insurance_slip_id");
        String replace_check_some = request.getParameter("replace_check_some");
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/replace_upload_list");
        ArrayList<InsPreservationResultSetVo> iprsVoList = new ArrayList<InsPreservationResultSetVo>();
        String[] arr = replace_check_some.split("#");
        List<InsPreservationResultSetVo> setList = this.getValueSession();
        for (String str : arr) {
            if (!StringUtils.isNotEmpty((CharSequence)str)) continue;
            String oid = str.split(";")[0];
            String sign = str.split(";")[1];
            InsPreservationResultSetVo iprsVo = this.insPreservationResultSetAPIService.getInsPreservationResultSetVoByOidAndSign(oid, sign);
            for (InsPreservationResultSetVo v : setList) {
                if (!StringUtils.isNotEmpty((CharSequence)iprsVo.getCareer()) || !iprsVo.getCareer().equals(v.getCareer())) continue;
                iprsVo.setOpposeVo(v);
                setList.remove(v);
                break;
            }
            iprsVoList.add(iprsVo);
            iprsVo = null;
        }
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(ins_insurance_slip_id)));
        view.addObject(ORDERVO, (Object)orderVo);
        view.addObject(IPRSVOLIST, iprsVoList);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"minus_upload_view"})
    public ModelAndView minus_upload_view(HttpServletRequest request) {
        String ins_insurance_slip_id = request.getParameter("ins_insurance_slip_id");
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/minus_upload_list");
        List<InsPreservationResultSetVo> setList = this.getValueSession();
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(ins_insurance_slip_id)));
        view.addObject(ORDERVO, (Object)orderVo);
        view.addObject(IPRSVOLIST, setList);
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_RECORD, title="\u3010\u8bf7\u6c42\u3011\u4e2a\u4eba\u4e2d\u5fc3-\u6279\u91cf\u51cf\u5458")
    @LoginRequired
    @RequestMapping(value={"batch_minus_preservation_service"})
    @ResponseBody
    public ResultDto batch_minus_preservation_service(String orderId, String importBatchId) throws Exception {
        if (!this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 1)) {
            return new ResultDto("\u4e1a\u52a1\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01", "300", "", "", "");
        }
        String sign = "1";
        InsPreservationRecordVo vo = new InsPreservationRecordVo();
        vo.setIns_insurance_slip_id(orderId);
        vo.setRevise_type("2");
        vo.setInception_date(DateUtil.getTomorrow());
        List ipdVoSortList = this.insPreservationResultSetAPIService.findInsPreservationDetailVoByImportBatchId(Long.valueOf(Long.parseLong(orderId)), importBatchId);
        vo.setInsPreservationDetailVoList(ipdVoSortList);
        vo.resetName();
        String result = this.insPreservationDetailAPIService.batchDetailSortAndValidator(vo);
        if ("300".equals(result.split("#")[0])) {
            this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 3);
            return new ResultDto(result.split("#")[1], "300", "", "", "");
        }
        Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, sign);
        if (map != null && "300".equals(map.get("ret"))) {
            this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 3);
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                this.insPreservationRecordAPIService.recordRestPAC(vo);
                new Thread(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid())).start();
            }
            return new ResultDto((String)map.get("msg"), "300", "", "", "");
        }
        if (this.insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign), vo, vo.getInsPreservationDetailVoList())) {
            this.insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
            String m = "\u6279\u6539\u4fe1\u606f\u6210\u529f\u63d0\u4ea4\u5ba1\u6838\uff01";
            if (map != null && !map.containsKey("isPendingApproval")) {
                m = "\u6279\u6539\u4fe1\u606f\u5df2\u901a\u8fc7\u5ba1\u6838\uff01";
            }
            this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 2);
            return new ResultDto(m, "200", "", "", "");
        }
        this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 3);
        return new ResultDto("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_RECORD, title="\u3010\u8bf7\u6c42\u3011\u4e2a\u4eba\u4e2d\u5fc3-\u51cf\u5458")
    @LoginRequired
    @RequestMapping(value={"minus_preservation_service"})
    @ResponseBody
    public ResultDto minus_preservation_service(InsPreservationRecordVo vo, String sign) throws Exception {
        ArrayList<InsPreservationDetailVo> ipdVoSortList;
        if (!this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 1)) {
            return new ResultDto("\u4e1a\u52a1\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01", "300", "", "", "");
        }
        if ("1".equals(sign)) {
            ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                if (StringUtils.isEmpty((CharSequence)ipdVo.getName()) && StringUtils.isEmpty((CharSequence)ipdVo.getBirthday()) && StringUtils.isEmpty((CharSequence)ipdVo.getCareer()) && StringUtils.isEmpty((CharSequence)ipdVo.getId_card()) && StringUtils.isEmpty((CharSequence)ipdVo.getId_type()) && StringUtils.isEmpty((CharSequence)ipdVo.getSex())) continue;
                ipdVoSortList.add(ipdVo);
            }
            vo.setInsPreservationDetailVoList(ipdVoSortList);
            vo.resetName();
            String result = this.insPreservationDetailAPIService.batchDetailSortAndValidator(vo);
            if ("300".equals(result.split("#")[0])) {
                this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 3);
                return new ResultDto(result.split("#")[1], "300", "", "", "");
            }
        } else {
            ipdVoSortList = new ArrayList();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                if (!StringUtils.isNotEmpty((CharSequence)ipdVo.getBusiness_id()) && !StringUtils.isNotEmpty((CharSequence)ipdVo.getBusiness_type())) continue;
                ipdVoSortList.add(ipdVo);
            }
            vo.setInsPreservationDetailVoList(ipdVoSortList);
        }
        String str = this.insPreservationDetailAPIService.notUnderWarrantyIdCardNo(vo.getIns_insurance_slip_id(), vo.getInsPreservationDetailVoList());
        if ("300".equals(str.split("#")[0])) {
            this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 3);
            return new ResultDto(str.split("#")[1], "300", "", "", "");
        }
        Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, sign);
        if (map != null && "300".equals(map.get("ret"))) {
            this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 3);
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                this.insPreservationRecordAPIService.recordRestPAC(vo);
                new Thread(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid())).start();
            }
            return new ResultDto((String)map.get("msg"), "300", "", "", "");
        }
        if (this.insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign), vo, vo.getInsPreservationDetailVoList())) {
            if (!"1".equals(sign)) {
                this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 2);
                return new ResultDto("\u4fdd\u5b58\u6210\u529f\uff0c\u8bf7\u8fdb\u5165\u201c\u6279\u6539\u7533\u8bf7\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u4fdd\u5b58\u7684\u6279\u6539\u7533\u8bf7\uff01", "200", "", "", "");
            }
            this.insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
            String m = "\u6279\u6539\u4fe1\u606f\u6210\u529f\u63d0\u4ea4\u5ba1\u6838\uff01";
            if (map != null && !map.containsKey("isPendingApproval")) {
                m = "\u6279\u6539\u4fe1\u606f\u5df2\u901a\u8fc7\u5ba1\u6838\uff01";
            }
            this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 2);
            return new ResultDto(m, "200", "", "", "");
        }
        this.stopSubmitAgain("PC_MINUS_BQ:" + this.getToken(), 3);
        return new ResultDto("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_RECORD, title="\u3010\u8bf7\u6c42\u3011\u4e2a\u4eba\u4e2d\u5fc3-\u51cf\u5458")
    @LoginRequired
    @RequestMapping(value={"update_detail_minus_service"})
    @ResponseBody
    public ResultDto update_detail_minus_service(InsPreservationRecordVo vo, String sign) throws Exception {
        List ipdVoList = vo.getInsPreservationDetailVoList();
        if (ipdVoList == null) {
            return new ResultDto("\u5f53\u524d\u4fdd\u5168\u65e0\u6709\u6548\u4eba\u5458\u4fe1\u606f\u8bf7\u624b\u52a8\u5220\u9664\u8be5\u5355", "300", "", "", "");
        }
        vo.resetName();
        String valid = this.insPreservationDetailAPIService.detailSortAndValidator(vo);
        if ("300".equals(valid.split("#")[0])) {
            return new ResultDto(valid.split("#")[1], "300", "", "", "");
        }
        ArrayList<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
        for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
            if (!StringUtils.isNotEmpty((CharSequence)ipdVo.getOid())) continue;
            ipdVoSortList.add(ipdVo);
        }
        vo.setInsPreservationDetailVoList(ipdVoSortList);
        String str = this.insPreservationDetailAPIService.notUnderWarrantyIdCardNo(vo.getIns_insurance_slip_id(), vo.getInsPreservationDetailVoList());
        if ("300".equals(str.split("#")[0])) {
            return new ResultDto(str.split("#")[1], "300", "", "", "");
        }
        Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, sign);
        if (map != null && "300".equals(map.get("ret"))) {
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                this.insPreservationRecordAPIService.recordRestPAC(vo);
                new Thread(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid())).start();
            }
            return new ResultDto((String)map.get("msg"), "300", "", "", "");
        }
        if (this.insPreservationRecordAPIService.minusInsPreservationRecord(Integer.parseInt(sign), vo, vo.getInsPreservationDetailVoList())) {
            if (!"1".equals(sign)) {
                return new ResultDto("\u4fdd\u5b58\u6210\u529f\uff0c\u8bf7\u8fdb\u5165\u201c\u6279\u6539\u7533\u8bf7\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u4fdd\u5b58\u7684\u6279\u6539\u7533\u8bf7\uff01", "200", "", "", "");
            }
            this.insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
            String m = "\u6279\u6539\u4fe1\u606f\u6210\u529f\u63d0\u4ea4\u5ba1\u6838\uff01";
            if (map != null && !map.containsKey("isPendingApproval")) {
                m = "\u6279\u6539\u4fe1\u606f\u5df2\u901a\u8fc7\u5ba1\u6838\uff01";
            }
            return new ResultDto(m, "200", "", "", "");
        }
        return new ResultDto("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_RECORD, title="\u3010\u8bf7\u6c42\u3011\u4e2a\u4eba\u4e2d\u5fc3-\u66ff\u6362")
    @LoginRequired
    @RequestMapping(value={"replace_preservation_service"})
    @ResponseBody
    public ResultDto replace_preservation_service(InsPreservationRecordVo vo, String sign) {
        ArrayList<InsPreservationDetailVo> ipdVoSortList;
        if (!this.stopSubmitAgain("PC_REPLACE_BQ:" + this.getToken(), 1)) {
            return new ResultDto("\u4e1a\u52a1\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01", "300", "", "", "");
        }
        if ("1".equals(sign)) {
            ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                if (StringUtils.isEmpty((CharSequence)ipdVo.getName()) && StringUtils.isEmpty((CharSequence)ipdVo.getBirthday()) && StringUtils.isEmpty((CharSequence)ipdVo.getCareer()) && StringUtils.isEmpty((CharSequence)ipdVo.getId_card()) && StringUtils.isEmpty((CharSequence)ipdVo.getId_type()) && StringUtils.isEmpty((CharSequence)ipdVo.getSex())) continue;
                ipdVoSortList.add(ipdVo);
            }
            vo.setInsPreservationDetailVoList(ipdVoSortList);
            vo.resetName();
            String result = this.insPreservationDetailAPIService.batchDetailSortAndValidator(vo);
            if ("300".equals(result.split("#")[0])) {
                this.stopSubmitAgain("PC_REPLACE_BQ:" + this.getToken(), 3);
                return new ResultDto(result.split("#")[1], "300", "", "", "");
            }
        } else {
            ipdVoSortList = new ArrayList();
            for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
                if (!StringUtils.isNotEmpty((CharSequence)ipdVo.getBusiness_id()) && !StringUtils.isNotEmpty((CharSequence)ipdVo.getBusiness_type()) && !StringUtils.isNotEmpty((CharSequence)ipdVo.getOid())) continue;
                ipdVoSortList.add(ipdVo);
            }
            vo.setInsPreservationDetailVoList(ipdVoSortList);
        }
        String str = this.insPreservationDetailAPIService.isDuplicateIdCardNoToPreservationDetail(vo.getIns_insurance_slip_id(), vo.getInsPreservationDetailVoList());
        if ("300".equals(str.split("#")[0])) {
            this.stopSubmitAgain("PC_REPLACE_BQ:" + this.getToken(), 3);
            return new ResultDto(str.split("#")[1], "300", "", "", "");
        }
        Map map = this.insPreservationRecordAPIService.recordRestToRB(vo, sign);
        if (map != null && "300".equals(map.get("ret"))) {
            this.stopSubmitAgain("PC_REPLACE_BQ:" + this.getToken(), 3);
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get("msg"))) && ((String)map.get("msg")).contains("\u7cfb\u7edf\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5")) {
                this.insPreservationRecordAPIService.recordRestPAC(vo);
                new Thread(() -> this.insPreservationRecordAPIService.addFindPDTask(vo.getOid())).start();
            }
            return new ResultDto((String)map.get("msg"), "300", "", "", "");
        }
        if (this.insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign), vo, vo.getInsPreservationDetailVoList())) {
            if (!"1".equals(sign)) {
                this.stopSubmitAgain("PC_REPLACE_BQ:" + this.getToken(), 2);
                return new ResultDto("\u4fdd\u5b58\u6210\u529f\uff0c\u8bf7\u8fdb\u5165\u201c\u6279\u6539\u7533\u8bf7\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u4fdd\u5b58\u7684\u6279\u6539\u7533\u8bf7\uff01", "200", "", "", "");
            }
            this.insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
            String m = "\u6279\u6539\u4fe1\u606f\u6210\u529f\u63d0\u4ea4\u5ba1\u6838\uff01";
            if (map != null && !map.containsKey("isPendingApproval")) {
                m = "\u6279\u6539\u4fe1\u606f\u5df2\u901a\u8fc7\u5ba1\u6838\uff01";
            }
            this.stopSubmitAgain("PC_REPLACE_BQ:" + this.getToken(), 2);
            return new ResultDto(m, "200", "", "", "");
        }
        this.stopSubmitAgain("PC_REPLACE_BQ:" + this.getToken(), 3);
        return new ResultDto("\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"deleteRecordDetail"})
    @ResponseBody
    public JSONObject deleteRecordDetail(long oid) {
        JSONObject json = new JSONObject();
        String message = "\u4eba\u5458\u4fe1\u606f\u5220\u9664\u5931\u8d25\uff01";
        String status = "300";
        if (this.insPreservationDetailAPIService.deleteInsPreservationDetail(Long.valueOf(oid))) {
            message = "\u4eba\u5458\u4fe1\u606f\u5220\u9664\u6210\u529f\uff01";
            status = "200";
        }
        json.put((Object)"message", (Object)message);
        json.put((Object)"status", (Object)status);
        return json;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/uploadRoleFile"})
    @ResponseBody
    public ResultDto uploadRoleFile(MultipartHttpServletRequest request) throws Exception {
        MultipartFile roleFile = request.getFile("role_record");
        List list = null;
        if (roleFile == null) return new ResultDto("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
        com.alibaba.fastjson.JSONObject jo = this.insPreservationResultSetAPIService.readIPRSExcel(roleFile);
        if (!"200".equals(jo.get((Object)"ret"))) return new ResultDto(String.valueOf(jo.get((Object)"msg")), "300", "", "", "");
        list = (List)jo.get((Object)"list");
        if (list.size() < 1) {
            return new ResultDto("Excel\u4e2d\u65e0\u4eba\u5458\u6570\u636e\u6216\u5b58\u5728\u7a7a\u767d\u884c\uff01", "300", "", "", "");
        }
        if (list == null || list.isEmpty()) return new ResultDto("\u672a\u89e3\u6790\u5230\u53ef\u7528\u6570\u636e\uff01", "300", "", "", "");
        if (!this.setValueSession(list)) return new ResultDto("\u6570\u636e\u7f13\u5b58\u5931\u8d25\uff01", "300", "", "", "");
        return new ResultDto("\u6587\u4ef6\u89e3\u6790\u6210\u529f\uff01", "200", "", "", "");
    }

    @RequestMapping(value={"/replaceUploadRoleFile"})
    @ResponseBody
    public ResultDto replaceUploadRoleFile(MultipartHttpServletRequest request) throws Exception {
        MultipartFile roleFile = request.getFile("role_record");
        String replace_check_some = request.getParameter("replace_check_some");
        String ins_insurance_slip_id = request.getParameter("ins_insurance_slip_id");
        if (StringUtils.isEmpty((CharSequence)replace_check_some) || StringUtils.isEmpty((CharSequence)ins_insurance_slip_id)) {
            return new ResultDto("\u8ba2\u5355\u4fe1\u606f\u6216\u66ff\u6362\u4eba\u5458\u4fe1\u606f\u4e22\u5931\uff01", "300", "", "", "");
        }
        List list = null;
        if (roleFile != null) {
            com.alibaba.fastjson.JSONObject jo = this.insPreservationResultSetAPIService.readIPRSExcel(roleFile);
            if ("200".equals(jo.get((Object)"ret"))) {
                list = (List)jo.get((Object)"list");
                if (list.size() < 1) {
                    return new ResultDto("Excel\u4e2d\u65e0\u4eba\u5458\u6570\u636e\u6216\u5b58\u5728\u7a7a\u767d\u884c\uff01", "300", "", "", "");
                }
            } else {
                return new ResultDto(String.valueOf(jo.get((Object)"msg")), "300", "", "", "");
            }
            String[] strArr = replace_check_some.replace("ROLE", "").replace("PRESERVE", "").replace("THIS", "").replace(";", "").split("#");
            Map m = this.insPreservationResultSetAPIService.countCareer(strArr);
            if (m == null) {
                return new ResultDto("\u672a\u5339\u914d\u5230\u9009\u4e2d\u4eba\u5458\u804c\u4e1a\u4fe1\u606f\uff01", "300", "", "", "");
            }
            if (!(String.valueOf(m.get("career1")).equals(String.valueOf(jo.get((Object)"career1"))) && String.valueOf(m.get("career2")).equals(String.valueOf(jo.get((Object)"career2"))) && String.valueOf(m.get("career3")).equals(String.valueOf(jo.get((Object)"career3"))) && String.valueOf(m.get("career4")).equals(String.valueOf(jo.get((Object)"career4"))))) {
                return new ResultDto("\u5bf9\u5e94\u804c\u4e1a\u4eba\u5458\u4eba\u6570\u4e0d\u5339\u914d\uff01", "300", "", "", "");
            }
        } else {
            return new ResultDto("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
        }
        if (list != null && !list.isEmpty()) {
            String[] checkNum = replace_check_some.split("#");
            if (checkNum.length != list.size()) {
                return new ResultDto("\u4e0a\u4f20\u4eba\u5458\u4eba\u6570\u4e0e\u52fe\u9009\u4eba\u6570\u4e0d\u4e00\u81f4\uff01", "300", "", "", "");
            }
            if (this.setValueSession(list)) {
                return new ResultDto("\u6587\u4ef6\u89e3\u6790\u6210\u529f\uff01", "200", "", "", "");
            }
            return new ResultDto("\u6570\u636e\u7f13\u5b58\u5931\u8d25\uff01", "300", "", "", "");
        }
        return new ResultDto("\u672a\u89e3\u6790\u5230\u53ef\u7528\u6570\u636e\uff01", "300", "", "", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/minusUploadRoleFile"})
    @ResponseBody
    public ResultDto minusUploadRoleFile(MultipartHttpServletRequest request) throws Exception {
        MultipartFile roleFile = request.getFile("role_record");
        String ins_insurance_slip_id = request.getParameter("ins_insurance_slip_id");
        if (StringUtils.isEmpty((CharSequence)ins_insurance_slip_id)) {
            return new ResultDto("\u8ba2\u5355\u4fe1\u606f\u4fe1\u606f\u4e22\u5931\uff01", "300", "", "", "");
        }
        List list = null;
        if (roleFile == null) return new ResultDto("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
        com.alibaba.fastjson.JSONObject jo = this.insPreservationResultSetAPIService.readIPRSExcel(roleFile);
        if (!"200".equals(jo.get((Object)"ret"))) return new ResultDto(String.valueOf(jo.get((Object)"msg")), "300", "", "", "");
        list = (List)jo.get((Object)"list");
        if (list.size() < 1) {
            return new ResultDto("Excel\u4e2d\u65e0\u4eba\u5458\u6570\u636e\u6216\u5b58\u5728\u7a7a\u767d\u884c\uff01", "300", "", "", "");
        }
        ArrayList idCards = Lists.newArrayList();
        for (InsPreservationResultSetVo vo : list) {
            idCards.add(vo.getId_card());
        }
        list = this.insPreservationResultSetAPIService.getInsPreservationResultSetVoByIdCardsAndOrderId(Long.valueOf(Long.parseLong(ins_insurance_slip_id)), (List)idCards);
        if (list == null || list.isEmpty()) return new ResultDto("\u672a\u89e3\u6790\u5230\u53ef\u7528\u6570\u636e\uff01", "300", "", "", "");
        if (!this.setValueSession(list)) return new ResultDto("\u6570\u636e\u7f13\u5b58\u5931\u8d25\uff01", "300", "", "", "");
        return new ResultDto("\u6587\u4ef6\u89e3\u6790\u6210\u529f\uff01", "200", "", "", "");
    }

    @RequestMapping(value={"/down_result_set/{oid}"})
    public void downResultSet(@PathVariable Long oid, HttpServletResponse resp) {
        this.insPreservationResultSetAPIService.downResultSet(oid, resp);
    }

    private boolean stopSubmitAgain(String key, int type) {
        boolean bool = false;
        switch (type) {
            case 1: {
                String typeStr = JedisUtils.get((String)key);
                if (StringUtils.isNotEmpty((CharSequence)typeStr)) {
                    if (!"0".equals(typeStr)) break;
                    JedisUtils.set((String)key, (String)"1", (int)600);
                    bool = true;
                    break;
                }
                JedisUtils.set((String)key, (String)"1", (int)600);
                bool = true;
                break;
            }
            case 2: {
                JedisUtils.del((String)key);
                bool = true;
                break;
            }
            case 3: {
                JedisUtils.set((String)key, (String)"0", (int)600);
                bool = true;
            }
        }
        return bool;
    }

    private boolean setValueSession(List<InsPreservationResultSetVo> list) {
        JedisUtils.setObject((String)("iprsVoList:" + this.getToken()), list, (int)180);
        return true;
    }

    private List<InsPreservationResultSetVo> getValueSession() {
        List list = (List)JedisUtils.getObject((String)("iprsVoList:" + this.getToken()));
        JedisUtils.delObject((String)("iprsVoList:" + this.getToken()));
        return list;
    }
}

