/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.preservation.controller;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationDetailAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/pc/preservation"})
public class InsPreservationRecordController
extends BaseController {
    @Autowired
    private InsPreservationRecordAPIService insPreservationRecordAPIService;
    @Autowired
    private InsPreservationDetailAPIService insPreservationDetailAPIService;
    @Autowired
    private InsPreservationResultSetAPIService insPreservationResultSetAPIService;
    @Autowired
    private PolicyService policyService;
    private static String IPRLIST = "iprList";
    private static String REVISE_STATUS = "revise_status";
    private static String START_TIME = "start_time";
    private static String END_TIME = "end_time";
    private static String KEYWORD = "keyword";
    private static String IPRVO = "iprVo";
    private static String DETAILLIST = "detailList";
    private static String MIN = "min";
    private static String MAX = "max";
    private static String ORDERVO = "orderVo";

    @RequestMapping(value={"test/{type}"})
    public void test(@PathVariable String type) {
        this.insPreservationResultSetAPIService.initAllOrderToResultSet(type);
    }

    @RequestMapping(value={"/batchMinus"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u4eba\u5458\u7ba1\u7406-\u6279\u91cf\u51cf\u5458")
    public ModelAndView batchMinus() {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/batchMinus/batchMinus");
        view.addObject("insDate", (Object)DateUtil.getTomorrow());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/pc/preservation/batchMinus")
    @RequestMapping(value={"/minus_policy_list_view"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u4eba\u5458\u7ba1\u7406-\u6279\u91cf\u51cf\u5458-\u51cf\u5458\u4fdd\u5355\u5217\u8868")
    public ModelAndView minusPolicyListView() {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/batchMinus/minus_policy_list");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("insDate", (Object)DateUtil.getTomorrow());
        view.addObject("policyList", JedisUtils.getObject((String)("BLB:CACHE:POLICYS-" + userdetail.getOid())));
        JedisUtils.delObject((String)("BLB:CACHE:POLICYS-" + userdetail.getOid()));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/pc/preservation/batchMinus")
    @RequestMapping(value={"/uploadBatchMinusFile"})
    @ResponseBody
    public Result uploadBatchMinusFile(MultipartHttpServletRequest request) throws Exception {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        MultipartFile hireFile = request.getFile("batch_minus_record");
        if (hireFile != null) {
            return this.insPreservationResultSetAPIService.minusBatchUploadInsPer(Long.valueOf(Long.parseLong(userdetail.getOid())), hireFile);
        }
        return Result.fail((String)"\u64cd\u4f5c\u5931\u8d25:");
    }

    @LoginRequired(redirectUrl="redirect:/pc/preservation/batchMinus")
    @RequestMapping(value={"exportErrInsPer"})
    public Result exportErrInsPer() {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        return this.insPreservationResultSetAPIService.downErrInsPer(userdetail.getOid(), this.getResponse());
    }

    @LoginRequired(methodParamKey={"0#revise_status", "1#start_time", "2#end_time"}, requestParamKey={"keyword"}, redirectUrl="pc/preservation/recordList?revise_status={revise_status}&start_time={start_time}&end_time={end_time}&keyword={keyword}")
    @RequestMapping(value={"recordList"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u4eba\u5458\u7ba1\u7406-\u4fdd\u5168\u7533\u8bf7\u5355\u67e5\u8be2")
    public ModelAndView recordList(String revise_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/recordList");
        page.setNumPerPage(5);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        view.addObject(IPRLIST, (Object)this.insPreservationRecordAPIService.findInsPreservationRecordByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), revise_status, start_time, et, keyword));
        view.addObject(REVISE_STATUS, (Object)revise_status);
        view.addObject(START_TIME, (Object)start_time);
        view.addObject(END_TIME, (Object)end_time);
        view.addObject(KEYWORD, (Object)keyword);
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"getRecordListForPage"})
    public ModelAndView ListForPage(String revise_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String keyword = request.getParameter("keyword");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            keyword = new String(keyword.getBytes("iso-8859-1"), "UTF-8");
        }
        String et = "";
        if (StringUtils.isNotEmpty((CharSequence)end_time)) {
            et = end_time + " 23:59:59";
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/recordList_table");
        view.addObject(IPRLIST, (Object)this.insPreservationRecordAPIService.findInsPreservationRecordByKeyword(page, Long.valueOf(Long.parseLong(userdetail.getOid())), revise_status, start_time, et, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#preservationId"}, redirectUrl="pc/preservation/getRecordDetailByPreservationId/{preservationId}")
    @RequestMapping(value={"getRecordDetailByPreservationId/{preservationId}"})
    public ModelAndView getRecordDetailByPreservationId(@PathVariable Long preservationId) {
        ModelAndView view = new ModelAndView();
        InsPreservationRecordVo iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
        if ("1".equals(iprVo.getRevise_type()) && "1".equals(iprVo.getRevise_status())) {
            view.setViewName("/coninsweb/personalCenter/preservation/addRecordDetail");
        }
        if ("3".equals(iprVo.getRevise_type())) {
            view.setViewName("/coninsweb/personalCenter/preservation/recordRepDetail");
        } else {
            view.setViewName("/coninsweb/personalCenter/preservation/recordDetail");
        }
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())));
        view.addObject(ORDERVO, (Object)orderVo);
        view.addObject(IPRVO, (Object)iprVo);
        view.addObject(DETAILLIST, (Object)iprVo.getInsPreservationDetailVoList());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"recordDetailListForPage"})
    public ModelAndView recordDetailListForPage(Long preservationId, String keyword, DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/recordDetail_table");
        view.addObject(DETAILLIST, (Object)this.insPreservationDetailAPIService.findInsPreservationDetailByKeyword(page, preservationId, keyword));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"againRecord"})
    @ResponseBody
    public JSONObject againRecord(long oid) {
        String message;
        JSONObject json = new JSONObject();
        String status = "300";
        try {
            if (this.insPreservationRecordAPIService.againRecord(Long.valueOf(oid))) {
                message = "\u518d\u6b21\u63d0\u4ea4\u5ba1\u6838\u6210\u529f\uff01";
                status = "200";
            } else {
                message = "\u63d0\u4ea4\u5ba1\u6838\u5931\u8d25\uff01";
            }
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        json.put((Object)"message", (Object)message);
        json.put((Object)"status", (Object)status);
        return json;
    }

    @RequestMapping(value={"addAgainRecord"})
    @ResponseBody
    public ResultDto addAgainRecord(InsPreservationRecordVo vo) {
        List ipdVoList = vo.getInsPreservationDetailVoList();
        for (InsPreservationDetailVo ipdVo : ipdVoList) {
            String result = this.insPreservationDetailAPIService.personnelToCheck(ipdVo, vo.getRevise_type());
            if ("300".equals(result.split("#")[0])) {
                return new ResultDto(result.split("#")[1], "300", "", "", "");
            }
            ipdVo.setRevise_type("1");
        }
        if (this.insPreservationRecordAPIService.addAgainRecord(Long.valueOf(Long.parseLong(vo.getOid())), ipdVoList)) {
            return new ResultDto("\u518d\u6b21\u63d0\u4ea4\u5ba1\u6838\u6210\u529f\uff01", "200", "", "", "");
        }
        return new ResultDto("\u63d0\u4ea4\u5ba1\u6838\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"deleteInsPreservationRecord"})
    @ResponseBody
    public JSONObject deleteInsPreservationRecord(long oid) {
        JSONObject json = new JSONObject();
        String message = "\u4fdd\u5168\u7533\u8bf7\u5355\u5220\u9664\u5931\u8d25\uff01";
        String status = "300";
        if (this.insPreservationRecordAPIService.deleteInsPreservationRecord(Long.valueOf(oid))) {
            message = "\u4fdd\u5168\u7533\u8bf7\u5355\u5220\u9664\u6210\u529f\uff01";
            status = "200";
        }
        json.put((Object)"message", (Object)message);
        json.put((Object)"status", (Object)status);
        return json;
    }

    @RequestMapping(value={"revokeInsPreservationRecord"})
    @ResponseBody
    public JSONObject revokeInsPreservationRecord(long oid) {
        JSONObject json = new JSONObject();
        String message = "\u4fdd\u5168\u7533\u8bf7\u5355\u64a4\u9500\u5931\u8d25\uff01";
        String status = "300";
        if (this.insPreservationRecordAPIService.revokeInsPreservationRecord(Long.valueOf(oid))) {
            message = "\u4fdd\u5168\u7533\u8bf7\u5355\u64a4\u9500\u6210\u529f\uff01";
            status = "200";
        }
        json.put((Object)"message", (Object)message);
        json.put((Object)"status", (Object)status);
        return json;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"thr_preservation_view"})
    public ModelAndView thr_preservation_view(String operate, Long preservationId) {
        ModelAndView view = new ModelAndView();
        if (preservationId != null) {
            InsPreservationRecordVo iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
            if ("add".equals(operate)) {
                view.setViewName("/coninsweb/personalCenter/preservation/update_detail_add");
            } else if ("minus".equals(operate)) {
                view.setViewName("/coninsweb/personalCenter/preservation/update_detail_minus");
                List rsaList = this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null, Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())), "", "0", "", "");
                view.addObject("rsaNum", (Object)(rsaList != null ? rsaList.size() : 0));
                view.addObject("ipdNum", (Object)(iprVo.getInsPreservationDetailVoList() != null ? iprVo.getInsPreservationDetailVoList().size() : 0));
            } else {
                view.setViewName("/coninsweb/personalCenter/preservation/update_detail_replace");
            }
            OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())));
            view.addObject(ORDERVO, (Object)orderVo);
            view.addObject("iprVo", (Object)iprVo);
            String resultDate = this.insPreservationRecordAPIService.getEffectiveByPolicyId(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())));
            view.addObject(MIN, (Object)resultDate.split(",")[0]);
            view.addObject(MAX, (Object)resultDate.split(",")[1]);
        }
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(redirectUrl="redirect:/synopsis/unSession")
    @RequestMapping(value={"update_detail_add_upload"})
    public ModelAndView update_detail_add_upload(Long preservationId) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/update_detail_add_upload");
        if (preservationId != null) {
            InsPreservationRecordVo iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
            List list = iprVo.getInsPreservationDetailVoList();
            for (InsPreservationDetailVo ipdVo : this.getValueSession()) {
                list.add(ipdVo);
            }
            OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())));
            view.addObject(ORDERVO, (Object)orderVo);
            view.addObject("ipdVoList", (Object)list);
        }
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/down_preservation_detail/{preservationId}"})
    public void downPreservationDetail(@PathVariable Long preservationId, HttpServletResponse resp) {
        this.insPreservationDetailAPIService.downPreservationDetail(preservationId, resp);
    }

    @RequestMapping(value={"/down_preservation_list"})
    public void downPreservationList(HttpServletRequest req, HttpServletResponse resp) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return;
        }
        String userId = userdetail.getOid();
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String name = req.getParameter("name");
        this.insPreservationDetailAPIService.downPreservationList(userId, keyword, name, start_time, end_time, resp);
    }

    @RequestMapping(value={"/uploadRoleFile"})
    @ResponseBody
    public ResultDto uploadRoleFile(MultipartHttpServletRequest request) throws Exception {
        com.alibaba.fastjson.JSONObject jo;
        MultipartFile roleFile = request.getFile("role_record");
        List list = null;
        String[] arrStr = new String[]{"name", "id_type", "id_card", "tel", "career", "scheme", "sex", "birthday"};
        if (roleFile != null) {
            jo = this.insPreservationDetailAPIService.readIPDExcel(roleFile);
            if (!"200".equals(jo.get((Object)"ret"))) {
                return new ResultDto(String.valueOf(jo.get((Object)"msg")), "300", "", "", "");
            }
        } else {
            return new ResultDto("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
        }
        list = (List)jo.get((Object)"list");
        if (list != null && !list.isEmpty()) {
            if (this.setValueSession(list)) {
                return new ResultDto("\u6587\u4ef6\u89e3\u6790\u6210\u529f\uff01", "200", "", "", "");
            }
            return new ResultDto("\u6570\u636e\u7f13\u5b58\u5931\u8d25\uff01", "300", "", "", "");
        }
        return new ResultDto("\u672a\u89e3\u6790\u5230\u53ef\u7528\u6570\u636e\uff01", "300", "", "", "");
    }

    private boolean setValueSession(List<InsPreservationDetailVo> list) {
        JedisUtils.setObject((String)("iprsVoList:" + this.getToken()), list, (int)180);
        return true;
    }

    private List<InsPreservationDetailVo> getValueSession() {
        List list = (List)JedisUtils.getObject((String)("iprsVoList:" + this.getToken()));
        JedisUtils.delObject((String)("iprsVoList:" + this.getToken()));
        return list;
    }
}

