/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.insurance.tyx;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.ComBankCodeService;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.third.tyx.changan.TYX_CARequestService;
import com.bcxin.ins.third.tyx.huatai.TYX_HTRequestService;
import com.bcxin.ins.third.tyx.pingancai.PACRequestService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.IdCardVerify;
import com.bcxin.ins.util.IdNumberValidator;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.ValidatorUtil;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.MailPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/insurance/tyx/policy"})
public class TYXPolicyController
extends BaseController {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;
    @Autowired
    private PACRequestService pACRequestService;
    @Autowired
    private TYX_CARequestService tYX_CARequestService;
    @Autowired
    private TYX_HTRequestService tYX_HTRequestService;
    @Autowired
    private ComBankCodeService comBankCodeService;

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u4ea7\u54c1-\u8bbf\u95ee\u6295\u4fdd\u9875")
    @LoginRequired(methodParamKey={"1#product_id"}, redirectUrl="/insurance/tyx/policy/policyInit/{product_id}")
    @RequestMapping(value={"/policyInit/{product_id}"})
    public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) {
        ClientUserVo userdetail;
        ModelAndView view = new ModelAndView();
        String personNum = request.getParameter("personNum");
        int num = 0;
        if (StringUtils.isNotEmpty((CharSequence)personNum)) {
            num = Integer.parseInt(personNum);
        }
        ProductVo pd = this.productService.getProduct(product_id.longValue());
        GMRPolicyVo vo = new GMRPolicyVo();
        if (StringUtils.isNotEmpty((CharSequence)pd.getProduct_code()) && !pd.getProduct_code().contains("TYX-RB")) {
            MailPolicyVo mVo = new MailPolicyVo();
            mVo.setIs_send_einvoice("1");
            vo.setMailPolicyVo(mVo);
        }
        if (StringUtils.isEmpty((CharSequence)(userdetail = UserSupportUtil.getSessionUser()).getWeb_type())) {
            view.addObject("vo", (Object)vo);
            view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
            this.orderAllotInit(pd, view);
            this.setTokenByApi(view);
            return view;
        }
        List doList = null;
        if (userdetail.getWeb_type().contains("ARS")) {
            doList = this.policyService.getComAndEmpByUserID_BBDAPI(userdetail.getWeb_id(), userdetail.getWeb_type());
        }
        if (userdetail.getWeb_type().contains("SAAS") || userdetail.getWeb_type().contains("PASP")) {
            String cacheId = (String)request.getSession().getAttribute("saasCacheId");
            if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                request.getSession().removeAttribute("saasCacheId");
                doList = this.policyService.getComAndEmpByCacheId_API(cacheId, userdetail.getWeb_type());
            } else {
                doList = this.policyService.getComAndEmpByUserID_API(userdetail.getWeb_id(), userdetail.getWeb_type());
            }
        }
        if (doList != null) {
            List<RoleSubjectVo> voList = this.sortRoleList(doList, num, 0);
            vo.setRoleSubjectList(voList);
            if (doList.size() > 0 && doList.size() < 4) {
                int ct = 4 - doList.size();
                RoleSubjectVo nullVo = null;
                for (int i = 0; i < ct; ++i) {
                    nullVo = new RoleSubjectVo();
                    nullVo.setKind("2");
                    doList.add(nullVo);
                    nullVo = null;
                }
            }
        }
        view.addObject("vo", (Object)vo);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        this.orderAllotInit(pd, view);
        this.setTokenByApi(view);
        return view;
    }

    private List<RoleSubjectVo> sortRoleList(List<RoleSubjectVo> doList, int num, int type) {
        ArrayList<RoleSubjectVo> results = new ArrayList<RoleSubjectVo>();
        if (doList == null) {
            if (num > 0) {
                RoleSubjectVo appRole = new RoleSubjectVo();
                appRole.setKind("1");
                results.add(appRole);
                RoleSubjectVo insRole = null;
                for (int i = 0; i < num; ++i) {
                    insRole = new RoleSubjectVo();
                    insRole.setKind("2");
                    insRole.setMajor_group("1");
                    results.add(insRole);
                    insRole = null;
                }
                return results;
            }
            return null;
        }
        ArrayList<RoleSubjectVo> insurceRoleList = new ArrayList<RoleSubjectVo>();
        for (RoleSubjectVo vo : doList) {
            if ("1".equals(vo.getKind())) {
                results.add(vo);
                continue;
            }
            insurceRoleList.add(vo);
        }
        if (results.size() == 0) {
            RoleSubjectVo vo = new RoleSubjectVo();
            vo.setKind("1");
            results.add(vo);
        }
        if (type != 0) {
            results.addAll(insurceRoleList);
            return results;
        }
        if (insurceRoleList.size() <= 0) {
            return results;
        }
        int insRoleNum = insurceRoleList.size();
        if (insRoleNum < num) {
            results.addAll(insurceRoleList);
            int lastNum = num - insRoleNum;
            for (int i = 0; i < lastNum; ++i) {
                RoleSubjectVo rvo = new RoleSubjectVo();
                rvo.setKind("2");
                rvo.setMajor_group("1");
                results.add(rvo);
            }
        } else if (insRoleNum == num) {
            results.addAll(insurceRoleList);
        } else if (num == 0) {
            results.addAll(insurceRoleList);
        } else {
            for (int i = 0; i < num; ++i) {
                results.add((RoleSubjectVo)insurceRoleList.get(i));
            }
        }
        return results;
    }

    private String createOrderAndGetOrderIDByProductID(Long product_id, Long user_id, String recommendCode, String trade_serial_number) {
        Map map = this.policyService.createOrderFormByProductOid(product_id, user_id, recommendCode, trade_serial_number);
        if (map.get("order_id") != null) {
            return (String)map.get("order_id");
        }
        return "";
    }

    @LoginRequired(methodParamKey={"1#order_id"}, redirectUrl="/insurance/tyx/policy/policy/{order_id}")
    @RequestMapping(value={"/policy/{order_id}"})
    public ModelAndView enterInfo(HttpServletRequest request, @PathVariable Long order_id) {
        ModelAndView view = new ModelAndView();
        this.orderAllot(order_id, view);
        this.setTokenByApi(view);
        return view;
    }

    private void orderAllotInit(ProductVo pd, ModelAndView view) {
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setTrade_serial_number(String.valueOf(IdWorker.getId()));
        view.addObject("sigId", (Object)String.valueOf(IdWorker.getId()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        view.addObject("comTypeList", (Object)IdType.comList());
        view.addObject("personTypeList", (Object)IdType.personList());
        view.addObject("natureList", (Object)NatureLinkage.getListByProvince((String)""));
        view.addObject("idOptionList", (Object)SysDictUtils.getDictList((String)"idOption"));
        view.addObject("businessAreaList", (Object)SysDictUtils.getDictList((String)"businessArea"));
        if (StringUtils.isNotEmpty((CharSequence)pd.getProduct_code()) && "TYX".equals(pd.getProduct_code().split("-")[0])) {
            try {
                view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            view.setViewName("/coninsweb/insurance/tyx/policy/gmr_enterBasicInfo");
        }
    }

    @RequestMapping(value={"/natureChange"})
    @ResponseBody
    public Map<String, String> natureChange(HttpServletRequest request) {
        String nID = request.getParameter("nID");
        if (StringUtils.isNotEmpty((CharSequence)nID)) {
            Map map = NatureLinkage.getMapByProvince((String)nID);
            return map;
        }
        return null;
    }

    private void orderAllot(Long order_id, ModelAndView view) {
        try {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)dto);
            view.addObject("comTypeList", (Object)IdType.comList());
            view.addObject("personTypeList", (Object)IdType.personList());
            view.addObject("natureList", (Object)NatureLinkage.getListByProvince((String)""));
            view.addObject("idOptionList", (Object)SysDictUtils.getDictList((String)"idOption"));
            view.addObject("businessAreaList", (Object)SysDictUtils.getDictList((String)"businessArea"));
            view.addObject("dto", (Object)dto);
            if (StringUtils.isEmpty((CharSequence)dto.getProduct_code()) || !"TYX".equals(dto.getProduct_code().split("-")[0])) {
                return;
            }
            GMRPolicyVo vo = this.policyService.accordingToOrderIDToGetGMRPolicyVo(order_id);
            view.addObject("vo", (Object)vo);
            view.setViewName("/coninsweb/insurance/tyx/policy/gmr_enterBasicInfo");
            if (vo == null) {
                return;
            }
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            if (vo.getRoleSubjectList() != null) {
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getNature_two()) && StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getCom_nature())) {
                    view.addObject("natureTwoList", (Object)NatureLinkage.getListByProvince((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getCom_nature()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province())) {
                    view.addObject("cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city())) {
                    view.addObject("areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_province())) {
                    view.addObject("bankCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_province()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_city())) {
                    view.addObject("bankTypeList", (Object)this.comBankCodeService.getAllBankType(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_city()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_type())) {
                    view.addObject("bankAddrList", (Object)this.comBankCodeService.getAllBankAddr(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_city(), ((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_type()));
                }
            }
            if (vo.getSpecialExhibitionVo() != null) {
                if (StringUtils.isNotEmpty((CharSequence)vo.getSpecialExhibitionVo().getEx_province())) {
                    view.addObject("exCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getSpecialExhibitionVo().getEx_province()));
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getSpecialExhibitionVo().getEx_city())) {
                    view.addObject("exAreaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)vo.getSpecialExhibitionVo().getEx_city()));
                }
            }
            if (vo.getMailPolicyVo() != null && StringUtils.isNotEmpty((CharSequence)vo.getMailPolicyVo().getBank_province())) {
                view.addObject("bankCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getMailPolicyVo().getBank_province()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="/insurance/tyx/policy/confirmPage/{order_id}")
    @RequestMapping(value={"/confirmPage/{order_id}"})
    public ModelAndView confirmPage(@PathVariable Long order_id, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        if (!StringUtils.isEmpty((CharSequence)dto.getProduct_code()) && "TYX".equals(dto.getProduct_code().split("-")[0])) {
            view.setViewName("/coninsweb/insurance/tyx/policy/policyConfirm");
            GMRPolicyVo vo = this.policyService.accordingToOrderIDToGetGMRPolicyVo(order_id);
            List natureList = NatureLinkage.doList();
            List typeList = IdType.doList();
            view.addObject("vo", (Object)vo);
            view.addObject("typeList", (Object)typeList);
            view.addObject("natureList", (Object)natureList);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            if (vo.getSpecialExhibitionVo() != null) {
                view.addObject("ex_pca", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getSpecialExhibitionVo().getEx_province(), (String)vo.getSpecialExhibitionVo().getEx_city(), (String)vo.getSpecialExhibitionVo().getEx_county()));
            }
        }
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/pendingGMRPolicyVoPolicy"})
    @ResponseBody
    public ResultDto pendingGMRPolicyVoPolicy(GMRPolicyVo vo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String recommendCode = request.getParameter("recommendCode");
        return this.policyService.pendingGMRPolicyVoPolicy(vo, recommendCode);
    }

    @LoginRequired
    @RequestMapping(value={"/updateOrderFormStatus"})
    @ResponseBody
    public ResultDto updateOrderFormStatus(HttpServletRequest request) throws Exception {
        String order_id = request.getParameter("order_id");
        String status = request.getParameter("status");
        if (StringUtils.isEmpty((CharSequence)order_id) || StringUtils.isEmpty((CharSequence)status)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(order_id));
        vo.setPolicy_status(status);
        String orderID = this.policyService.updateOrderFormStatus(vo);
        if (StringUtils.isNotEmpty((CharSequence)orderID)) {
            return new ResultDto("\u8ba2\u5355\u5f55\u5165\u6210\u529f\u3002", "200", orderID, "300", "");
        }
        return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="/insurance/tyx/policy/policyPayment/{order_id}")
    @RequestMapping(value={"/policyPayment/{order_id}"})
    public ModelAndView savePolicy(@PathVariable long order_id, HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        try {
            OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(order_id));
            ProductVo pd = this.productService.getProduct(Long.parseLong(vo.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)vo);
            if (StringUtils.isNotEmpty((CharSequence)vo.getPay_methods()) && this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_ONE.intValue()) {
                AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(order_id));
                view.setViewName("/coninsweb/insurance/tyx/transaction/paymentNotice");
                view.addObject("anVo", (Object)anVo);
                view.addObject("nowTime", (Object)new Date());
                return view;
            }
            if (vo.getPolicy_status().equals("2")) {
                view.setViewName("/coninsweb/insurance/tyx/transaction/waitOffer");
            } else if (vo.getPolicy_status().equals("6")) {
                view.setViewName("/coninsweb/insurance/tyx/transaction/passUnderwriting");
            } else if (vo.getPolicy_status().equals("15")) {
                view.setViewName("/coninsweb/insurance/tyx/transaction/declinature");
            } else if (vo.getPolicy_status().equals("4")) {
                if (this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_ONE.intValue()) {
                    view.setViewName("/coninsweb/insurance/tyx/transaction/policyPayment");
                } else if (this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_TWO.intValue()) {
                    view.setViewName("/coninsweb/insurance/tyx/transaction/policyPayment_PA");
                } else if (this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_FOUR.intValue()) {
                    view.setViewName("/coninsweb/insurance/tyx/transaction/policyPayment_RB");
                } else if (this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_FIVE.intValue()) {
                    view.setViewName("/coninsweb/insurance/tyx/transaction/policyPayment_PAC");
                    this.TYX_PAC_Payment(order_id, view, vo);
                } else if (this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_SIX.intValue()) {
                    view.setViewName("/coninsweb/insurance/tyx/transaction/policyPayment_CA");
                    this.TYX_CA_Payment(order_id, view, vo);
                } else if (this.productService.api_request_sign(vo.getProduct_code()) == 7) {
                    view.setViewName("/coninsweb/insurance/tyx/transaction/policyPayment_QH");
                    view.addObject("payurl", (Object)vo.getShow_url());
                } else if (this.productService.api_request_sign(vo.getProduct_code()) == 8) {
                    view = new ModelAndView("/coninsweb/insurance/tyx/transaction/policyPayment_HT");
                    this.TYX_HT_Payment(order_id, view, vo);
                }
            } else if (vo.getPolicy_status().equals("5")) {
                view.setViewName("/coninsweb/insurance/tyx/transaction/finishPay");
            } else if (vo.getPolicy_status().equals("3")) {
                AdviceNoteVo anVo = null;
                if (vo.getProduct_code().contains("TYX-PAC")) {
                    view.setViewName("/coninsweb/insurance/tyx/transaction/paymentNoticePAC");
                    anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(order_id));
                } else if (vo.getProduct_code().contains("TYX-CA")) {
                    view.setViewName("/coninsweb/insurance/tyx/transaction/paymentNoticeCA");
                }
                view.addObject("anVo", (Object)anVo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        view.addObject("nowTime", (Object)new Date());
        this.setTokenByApi(view);
        return view;
    }

    private void TYX_PAC_Payment(@PathVariable long order_id, ModelAndView view, OrderFormVo vo) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)vo.getShow_url())) {
            view.addObject("payurl", (Object)vo.getShow_url());
        } else {
            String result = this.pACRequestService.requestPAC(Long.valueOf(Long.parseLong(vo.getOid())), "5", null);
            String[] strs = result.split("#");
            if ("200".equals(strs[0])) {
                this.policyService.payUrlChangePAC(Long.valueOf(order_id), strs[1], strs[2]);
                view.addObject("payurl", (Object)strs[2]);
            }
        }
    }

    private void TYX_CA_Payment(@PathVariable long order_id, ModelAndView view, OrderFormVo vo) throws Exception {
        boolean boo;
        String yxDate = DateUtil.convertDateToString((Date)new Date(), (String)"yyyyMMdd");
        boolean bl = boo = StringUtils.isEmpty((CharSequence)vo.getPay_order_number()) ? false : vo.getPay_order_number().contains(yxDate);
        if (StringUtils.isNotEmpty((CharSequence)vo.getShow_url()) && boo) {
            view.addObject("payurl", (Object)vo.getShow_url());
        } else {
            String result = this.tYX_CARequestService.request_ca_tyx(Long.valueOf(Long.parseLong(vo.getOid())), TransTypeEnum.ZFDZ.getValue(), null);
            String[] strs = result.split("#");
            if ("200".equals(strs[0])) {
                this.policyService.payUrlChangeCA(Long.valueOf(order_id), strs[1], strs[2]);
                view.addObject("payurl", (Object)strs[2]);
            }
        }
    }

    private void TYX_HT_Payment(@PathVariable long order_id, ModelAndView view, OrderFormVo vo) throws Exception {
        boolean boo;
        String yxDate = DateUtil.convertDateToString((Date)new Date(), (String)"yyyyMMdd");
        boolean bl = boo = StringUtils.isEmpty((CharSequence)vo.getPay_order_number()) ? false : vo.getPay_order_number().contains(yxDate);
        if (StringUtils.isNotEmpty((CharSequence)vo.getShow_url()) && boo) {
            view.addObject("payurl", (Object)vo.getShow_url());
        } else {
            String result = this.tYX_HTRequestService.request_ht_tyx(Long.valueOf(Long.parseLong(vo.getOid())), TransTypeEnum.ZFDZ.getValue(), null);
            String[] strs = result.split("#");
            if ("200".equals(strs[0])) {
                this.policyService.payUrlChangeCA(Long.valueOf(order_id), com.bcxin.mybatisplus.toolkit.IdWorker.getId() + "", strs[1]);
                view.addObject("payurl", (Object)strs[1]);
            }
        }
    }

    @RequestMapping(value={"/requestEPolicy/{oid}"})
    @ResponseBody
    public ResultDto requestEPolicy(@PathVariable Long oid) throws Exception {
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(oid);
        if (this.productService.api_request_sign(vo.getProduct_code()) == 2) {
            this.policyService.HTTP_PAS_TYX_DZBD(oid, null, vo);
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getInsure_path())) {
            return new ResultDto("", "200", vo.getInsure_path(), "", "");
        }
        return new ResultDto("\u7535\u5b50\u4fdd\u5355\u751f\u6210\u4e2d(\u8fd9\u53ef\u80fd\u9700\u8981\u534a\u4e2a\u5c0f\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5)...", "300", "", "", "");
    }

    @RequestMapping(value={"/sessionInfo"})
    @ResponseBody
    public ResultDto sessionInfo(HttpServletRequest reqeust, ModelMap model) {
        String name = reqeust.getParameter("name");
        String base64 = reqeust.getParameter("base64");
        model.addAttribute(name, (Object)base64);
        return new ResultDto("", "200", "", "", "");
    }

    @RequestMapping(value={"/deleteRoleInPolicyByOid"})
    @ResponseBody
    public ResultDto deleteRoleInPolicyByOid(HttpServletRequest request) {
        String role_id = request.getParameter("role_id");
        if (StringUtils.isEmpty((CharSequence)role_id)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u5220\u9664\u5931\u8d25\uff01", "300", "", "", "");
        }
        if (this.policyService.deleteRoleInPolicyByOid(role_id)) {
            return new ResultDto("\u5220\u9664\u6210\u529f\uff01", "200", "", "", "");
        }
        return new ResultDto("\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u5220\u9664\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/delectAllInsRole"})
    @ResponseBody
    public ResultDto delectAllInsRole(HttpServletRequest request) {
        String order_id = request.getParameter("order_id");
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        if (this.policyService.delectAllInsRole(order_id)) {
            return new ResultDto("\u5220\u9664\u6210\u529f\uff01", "200", "", "", "");
        }
        return new ResultDto("\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
    }

    private ResultDto uploadRoleFile(MultipartFile mFile) throws Exception {
        ArrayList list = null;
        String[] arrStr = new String[]{"name_cn", "id_type", "organization_code", "birth_date", "sex", "mobile", "major_group"};
        list = Lists.newArrayList();
        String msg = "";
        boolean cum = false;
        String cds = "";
        try {
            InputStream is = mFile.getInputStream();
            HSSFWorkbook hssfWorkbook = new HSSFWorkbook(is);
            block6: for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                RoleSubjectVo rsVo = null;
                for (int rowNum = 6; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    int hh = rowNum + 1;
                    if (hssfRow == null) continue;
                    if (StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(1)).trim()) && StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(2)).trim()) && StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(3)).trim()) && StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(6)).trim()) && StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(7)).trim()) && StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(8)).trim())) continue block6;
                    HSSFCell cell = null;
                    rsVo = new RoleSubjectVo();
                    HashMap map = Maps.newHashMap();
                    String cd = "";
                    for (int i = 1; i < 8; ++i) {
                        String _value;
                        block30: {
                            block35: {
                                block36: {
                                    block31: {
                                        block34: {
                                            block33: {
                                                block32: {
                                                    block29: {
                                                        cell = hssfRow.getCell(i);
                                                        _value = TYXPolicyController.getValue(cell).trim();
                                                        if (StringUtils.isEmpty((CharSequence)_value)) {
                                                            String n = i == 1 ? "\u59d3\u540d" : (i == 2 ? "\u8bc1\u4ef6\u7c7b\u578b" : (i == 3 ? "\u8bc1\u4ef6\u53f7" : (i == 4 ? "\u51fa\u751f\u65e5\u671f" : (i == 5 ? "\u6027\u522b" : (i == 6 ? "\u624b\u673a" : "\u804c\u4e1a")))));
                                                            msg = msg + "\u7b2c " + hh + " \u884c\uff1a" + n + "\u4e0d\u80fd\u4e3a\u7a7a;";
                                                            cum = true;
                                                            continue;
                                                        }
                                                        if (!"name_cn".equals(arrStr[i - 1])) break block29;
                                                        if (StringUtils.isNotEmpty((CharSequence)_value)) {
                                                            _value = _value.replace(" ", "");
                                                        }
                                                        break block30;
                                                    }
                                                    if (!"id_type".equals(arrStr[i - 1])) break block31;
                                                    if (!"\u5c45\u6c11\u8eab\u4efd\u8bc1".equals(_value)) break block32;
                                                    _value = "0";
                                                    break block30;
                                                }
                                                if (!"\u62a4\u7167".equals(_value)) break block33;
                                                _value = "3";
                                                break block30;
                                            }
                                            if (!"\u53f0\u80de\u8bc1".equals(_value)) break block34;
                                            _value = "4";
                                            break block30;
                                        }
                                        if (!"\u56de\u4e61\u8bc1".equals(_value)) break block30;
                                        _value = "5";
                                        break block30;
                                    }
                                    if (!"sex".equals(arrStr[i - 1])) break block35;
                                    if (!"\u7537".equals(_value)) break block36;
                                    _value = "1";
                                    break block30;
                                }
                                if (!"\u5973".equals(_value)) break block30;
                                _value = "2";
                                break block30;
                            }
                            if ("birth_date".equals(arrStr[i - 1])) {
                                block28: {
                                    try {
                                        if (_value.contains("-")) {
                                            DateUtil.parseDate((String)_value);
                                            break block28;
                                        }
                                        if (!HSSFDateUtil.isCellDateFormatted((Cell)cell)) break block28;
                                        Date d = cell.getDateCellValue();
                                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
                                        _value = formater.format(d);
                                    }
                                    catch (Exception e) {
                                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u51fa\u751f\u65e5\u671f\u6709\u8bef;";
                                        cum = true;
                                        break;
                                    }
                                }
                                if (IdNumberValidator.getAgeFromBirthday((String)_value) > 65 || IdNumberValidator.getAgeFromBirthday((String)_value) < 16) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u4eba\u5458\u7684\u5e74\u9f84\u8d85\u51fa\u9650\u5236\uff08\u533a\u95f4\uff1a16-65\u5468\u5c81\uff09;";
                                    cum = true;
                                    break;
                                }
                            } else if ("organization_code".equals(arrStr[i - 1])) {
                                if (!IdCardVerify.isValidatedAllIdcard((String)(_value = _value.toUpperCase()))) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u8bc1\u4ef6\u53f7\u7801\u4e0d\u662f\u6709\u6548\u8bc1\u4ef6\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d;";
                                    cum = true;
                                    break;
                                }
                                cd = _value;
                            } else if ("mobile".equals(arrStr[i - 1])) {
                                if (_value.contains("E")) {
                                    try {
                                        DecimalFormat df = new DecimalFormat("#");
                                        _value = df.format(cell.getNumericCellValue());
                                    }
                                    catch (Exception e) {
                                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef;";
                                        cum = true;
                                        break;
                                    }
                                }
                                if (!ValidatorUtil.validatePhone((String)_value)) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef;";
                                    cum = true;
                                    break;
                                }
                            } else if ("major_group".equals(arrStr[i - 1]) && !"1234".contains(_value = _value.replace(".0", ""))) {
                                msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u804c\u4e1a\u7f16\u7801\u65e0\u6548;";
                                cum = true;
                                break;
                            }
                        }
                        map.put(arrStr[i - 1], _value);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)cd) && cds.contains(cd)) {
                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u8be5\u8bc1\u4ef6\u53f7\u5df2\u5728\u672c\u6e05\u5355\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u5f55\u5165;";
                        cum = true;
                    }
                    cds = cds + cd + ";";
                    if (rsVo == null || map.size() <= 0) continue;
                    MyConverUtil.map2PO((Map)map, (Object)rsVo);
                    list.add(rsVo);
                    rsVo = null;
                }
            }
            if (cum) {
                return new ResultDto(msg, "300", "", "", "");
            }
            if (list != null && !list.isEmpty()) {
                if (list.size() > 2001 || list.size() < 3) {
                    return new ResultDto("\u8bf7\u63a7\u5236\u5bfc\u5165\u4eba\u6570\u57283~2001\u4eba\u4ee5\u5185\uff01", "300", "", "", "");
                }
                if (this.setValueSession(list)) {
                    return new ResultDto("\u6587\u4ef6\u89e3\u6790\u6210\u529f\uff01", "200", "", "", "");
                }
                return new ResultDto("\u6570\u636e\u7f13\u5b58\u5931\u8d25\uff01", "300", "", "", "");
            }
            return new ResultDto("\u672a\u89e3\u6790\u5230\u53ef\u7528\u6570\u636e\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            return new ResultDto("Excel\u6e05\u5355\u6a21\u677f\u6587\u4ef6\u6570\u636e\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u6807\u51c6\u7684Excel\u6e05\u5355\u6a21\u677f\u4e0a\u4f20\uff01\n\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u6a21\u677f\u6587\u4ef6\u5934\u90e8\u5185\u5bb9\u88ab\u5220\u9664\u6216\u6574\u4f53\u6837\u5f0f\u88ab\u6539\u53d8\uff1b\n2.\u76f4\u63a5\u5b83\u5904\u590d\u5236\u7684\u4eba\u5458\u4fe1\u606f\u9644\u5e26\u683c\u5f0f\u3002", "300", "", "", "");
        }
    }

    private static String getValue(HSSFCell hssfRow) {
        if (hssfRow.getCellType() == 4) {
            return String.valueOf(hssfRow.getBooleanCellValue());
        }
        if (hssfRow.getCellType() == 0) {
            return String.valueOf(hssfRow.getNumericCellValue());
        }
        String value = "";
        try {
            value = String.valueOf(hssfRow.getStringCellValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @RequestMapping(value={"/gzxUploadRoleFile"})
    @ResponseBody
    public ResultDto uploadRoleFile(MultipartHttpServletRequest request) throws Exception {
        MultipartFile roleFile = request.getFile("role_emp");
        if (roleFile != null) {
            return this.uploadRoleFile(roleFile);
        }
        return new ResultDto("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/role_upload_list"})
    public ModelAndView role_upload_list() {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/tyx/policy/role_upload_list");
        view.addObject("rsVoList", this.getValueSession());
        view.addObject("personTypeList", (Object)IdType.personList());
        view.addObject("productCode", (Object)this.getRequest().getParameter("productCode"));
        this.setTokenByApi(view);
        return view;
    }

    private boolean setValueSession(List<RoleSubjectVo> list) {
        JedisUtils.setObject((String)("rsVoList:" + this.getToken()), list, (int)180);
        return true;
    }

    private List<RoleSubjectVo> getValueSession() {
        List list = (List)JedisUtils.getObject((String)("rsVoList:" + this.getToken()));
        JedisUtils.delObject((String)("rsVoList:" + this.getToken()));
        return list;
    }
}

