/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.export;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.InsProductRuleXWCKAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.third.build.taibao.TransType;
import com.bcxin.ins.third.xyx.taibao.XYX_TBRequestService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.RuleXWCKVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class XYX_Transaction_API_Controller
extends BaseController {
    @Autowired
    private XYX_TBRequestService xYX_TBRequestService;
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private InsProductRuleXWCKAPIService insProductRuleXWCKAPIService;
    @Autowired
    private InsTransactionAPIService transactionService;

    @LoginRequired
    @RequestMapping(value={"/api/xyx/transaction/API_Underwriting"})
    @ResponseBody
    public ResultDto API_Underwriting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getResultDto(request, response);
    }

    private ResultDto getResultDto(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String oid = request.getParameter("policyId");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
        String result = this.xYX_TBRequestService.requestTB(Long.valueOf(Long.parseLong(oid)), TransType.EPIC_INS_XW.getValue(), null);
        String[] strs = result.split("#");
        if ("200".equals(strs[0])) {
            if (StringUtils.isNotEmpty((CharSequence)strs[1])) {
                PolicyTransactionVo pvo = new PolicyTransactionVo();
                pvo.setPolicy_id(oid);
                pvo.setPolicy_serial_number(strs[1]);
                pvo.setTrade_serial_number(IdWorker.getId() + "");
                pvo.setPayment_method("1");
                pvo.setPay_type("6");
                pvo.setOut_of_pocket(BigDecimal.ZERO);
                pvo.setPay_amount(BigDecimal.ZERO);
                pvo.setPath_sign("1");
                pvo.setTransaction_status("2");
                pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
                this.policyService.saveTransaction(pvo);
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("\uff08APP-GZX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
        }
        return new ResultDto(strs[1], "300", "", "", "");
    }

    @LoginRequired
    @RequestMapping(value={"/api/xyx/transaction/API_Underwriting_Later"})
    @ResponseBody
    public ResultDto API_Underwriting_Later(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getResultDto_Later(request, response);
    }

    private ResultDto getResultDto_Later(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] strs;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        String oid = request.getParameter("policyId");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
        String result = "";
        if (this.productService.api_request_sign(dto.getProduct_code()) == 2) {
            result = this.xYX_TBRequestService.requestTB(Long.valueOf(Long.parseLong(oid)), "2", null);
        }
        if ("200".equals((strs = result.split("#"))[0])) {
            if (StringUtils.isNotEmpty((CharSequence)strs[1])) {
                PolicyTransactionVo vo = new PolicyTransactionVo();
                vo.setPolicy_number(strs[1]);
                vo.setPolicy_id(String.valueOf(oid));
                this.transactionService.savePolicyExternalReference(vo);
                if (strs.length == 3) {
                    vo.setInsure_path(strs[2]);
                    this.transactionService.savePolicyOther(vo);
                }
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("\uff08APP-GZX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
        }
        return new ResultDto(strs[1], "300", "", "", "");
    }

    @RequestMapping(value={"/api/xyx/transaction/failMessage"})
    public ModelAndView failMessage(HttpServletRequest request) {
        String msg = request.getParameter("msg");
        ModelAndView view = new ModelAndView("/coninsweb/api/xyx/transaction/failMessage");
        view.addObject("msg", (Object)msg);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/api/xyx/syntony-service/{oid}"})
    public ModelAndView syntonyService(@PathVariable(value="oid") String oid, HttpServletRequest request) {
        this.logger.info("\u4fe1\u7528\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-star");
        this.logger.info("\u4fe1\u7528\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-syntony-service\uff1aoid:" + oid);
        ModelAndView view = new ModelAndView("/coninsweb/api/xyx/transaction/finishPay");
        if (StringUtils.isNotEmpty((CharSequence)oid)) {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)dto);
            this.logger.info("\u4fe1\u7528\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-OrderFormVo\uff1a" + dto.toString());
        }
        view.addObject("oid", (Object)oid);
        this.logger.info("\u4fe1\u7528\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-end");
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/api/xyx/printPolicy/{oid}"})
    public ModelAndView printPolicy(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/customs/transaction/print_customs_1");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        view.addObject("dto", (Object)dto);
        MicroExportVo vo = this.policyService.accordingToOrderIDToGetMicroExportVo(Long.valueOf(oid));
        RuleXWCKVo rxvo = this.insProductRuleXWCKAPIService.getRuleXWCKVoByProductIDAndCity(dto.getProduct_oid(), ((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city());
        view.addObject("rxvo", (Object)rxvo);
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
        view.addObject("reg_rule", (Object)(RegionUtils.getRegionNameByALLCode((String)vo.getLawsuit_province(), (String)vo.getLawsuit_city(), (String)vo.getLawsuit_area()) + vo.getLawsuit_address()));
        view.addObject("quyu", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getLawsuit_province(), (String)vo.getLawsuit_city(), (String)""));
        view.addObject("vo", (Object)vo);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/api/xyx/print-promissory-note/{oid}"})
    public ModelAndView print_promissory_note(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/customs/transaction/print_customs_2");
        MicroExportVo vo = this.policyService.accordingToOrderIDToGetMicroExportVo(Long.valueOf(oid));
        view.addObject("cityName", (Object)RegionUtils.getRegionNameByCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
        this.setTokenByApi(view);
        return view;
    }
}

