/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.export;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.InsProductRuleXWCKAPIService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.ins.vo.CommonExportVo_2;
import com.bcxin.ins.vo.CommonExportVo_3;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.RuleXWCKVo;
import com.bcxin.ins.vo.UnderwriteVo;
import com.xiaoleilu.hutool.thread.ThreadUtil;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/insurance/customs"})
@SessionAttributes(value={"favorite", "app_com_organizingPath", "app_com_businessPath", "app_com_taxPath", "ins_com_organizingPath", "ins_com_businessPath", "ins_com_taxPath", "tax_cert", "tax_prove", "bank_licence", "business_license", "auth_cert"})
public class XYX_Policy_Controller
extends BaseController {
    @Autowired
    private InsProductAPIService insProductAPIService;
    @Autowired
    private InsProductRuleXWCKAPIService insProductRuleXWCKAPIService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u4ea7\u54c1-\u8bbf\u95ee\u6295\u4fdd\u9875")
    @LoginRequired(methodParamKey={"1#product_id"}, redirectUrl="insurance/customs/policyInit/{product_id}")
    @RequestMapping(value={"/policyInit/{product_id}"})
    public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) throws Exception {
        ModelAndView view = new ModelAndView();
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        this.orderAllotInit(product_id, view);
        this.setTokenByApi(view);
        return view;
    }

    private String createOrderAndGetOrderIDByProductID(Long product_id, Long user_id, String recommendCode, String trade_serial_number) {
        Map map = this.policyService.createOrderFormByProductOid(product_id, user_id, recommendCode, trade_serial_number);
        if (map.get("order_id") != null) {
            return (String)map.get("order_id");
        }
        return "";
    }

    @LoginRequired(methodParamKey={"1#order_id"}, redirectUrl="insurance/customs/policy/{order_id}")
    @RequestMapping(value={"/policy/{order_id}"})
    public ModelAndView enterInfo(HttpServletRequest request, @PathVariable Long order_id, SessionStatus status, ModelMap model) {
        ModelAndView view = new ModelAndView();
        this.orderAllot(order_id, view);
        this.setTokenByApi(view);
        return view;
    }

    private void orderAllotInit(Long product_id, ModelAndView view) {
        ProductVo pd = this.insProductAPIService.accordingToInsProductIDToGetInsProductInProductVo(product_id);
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
        if (!StringUtils.isEmpty((String)pd.getProduct_code()) && "XYX-XWCK".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_mi");
            MicroExportVo vo = new MicroExportVo();
            this.setDay(vo);
            view.addObject("vo", (Object)vo);
            this.initEnumList(view);
        } else if (!StringUtils.isEmpty((String)pd.getProduct_code()) && "XYX-DQCK".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_1");
            this.initEnumList_qy(view);
        }
    }

    private void orderAllot(Long order_id, ModelAndView view) {
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = this.insProductAPIService.accordingToInsProductIDToGetInsProductInProductVo(Long.valueOf(Long.parseLong(dto.getProduct_oid())));
        view.addObject("pd", (Object)pd);
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
        if (!StringUtils.isEmpty((String)dto.getProduct_code()) && "XYX-XWCK".equals(dto.getProduct_code())) {
            MicroExportVo vo = this.policyService.accordingToOrderIDToGetMicroExportVo(order_id);
            if (vo.getRoleSubjectList().size() > 0 && StringUtils.isNotEmpty((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province())) {
                view.addObject("reg_cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
            }
            if (vo.getRoleSubjectList().size() > 0 && StringUtils.isNotEmpty((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city())) {
                view.addObject("reg_areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
            }
            view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_mi");
            this.setDay(vo);
            view.addObject("vo", (Object)vo);
            this.initEnumList(view);
        } else if (!StringUtils.isEmpty((String)dto.getProduct_code()) && "XYX-DQCK".equals(dto.getProduct_code())) {
            CommonExportVo_1 vo = this.policyService.accordingToOrderIDToGetCommonExportVo_1(order_id);
            view.addObject("vo", (Object)vo);
            if (vo.getRoleSubjectList().size() > 0 && StringUtils.isNotEmpty((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province())) {
                view.addObject("reg_cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
            }
            if (vo.getRoleSubjectList().size() > 0 && StringUtils.isNotEmpty((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city())) {
                view.addObject("reg_areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
            }
            view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_1");
            this.initEnumList_qy(view);
        }
        view.addObject("dto", (Object)dto);
    }

    private void setDay(MicroExportVo vo) {
        String tom = DateUtil.getTomorrow();
        String nextOne = "";
        try {
            nextOne = DateUtil.dateAdd((int)1, (String)tom, (int)1);
            nextOne = DateUtil.dateAdd((int)3, (String)nextOne, (int)-1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setInception_date(tom);
        vo.setPlanned_end_date(nextOne);
    }

    @LoginRequired(methodParamKey={"0#order_id", "1#page"}, redirectUrl="insurance/customs/policy/qy_policy/{order_id}/{page}")
    @RequestMapping(value={"/policy/qy_policy/{order_id}/{page}"})
    public ModelAndView qy_policy(@PathVariable Long order_id, @PathVariable int page, HttpServletRequest reqeust) throws Exception {
        ModelAndView view = new ModelAndView();
        try {
            if (page <= 0) {
                return view;
            }
            view.addObject("dto", (Object)this.policyService.accordingToOrderIDToGetPolicyDto(order_id));
            if (page == 1) {
                view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_1");
                CommonExportVo_1 vo = this.policyService.accordingToOrderIDToGetCommonExportVo_1(order_id);
                view.addObject("vo", (Object)vo);
                view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
                if (vo.getRoleSubjectList().size() > 0 && StringUtils.isNotEmpty((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province())) {
                    view.addObject("reg_cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
                }
                if (vo.getRoleSubjectList().size() > 0 && StringUtils.isNotEmpty((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city())) {
                    view.addObject("reg_areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
                }
            } else if (page == 2) {
                view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_2");
                view.addObject("vo", (Object)this.policyService.accordingToOrderIDToGetCommonExportVo_2(order_id));
            } else if (page == 3) {
                view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_3");
                view.addObject("vo", (Object)this.policyService.accordingToOrderIDToGetCommonExportVo_3(order_id));
            }
            this.initEnumList_qy(view);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="insurance/customs/policy/confirmPage/{order_id}")
    @RequestMapping(value={"/policy/confirmPage/{order_id}"})
    public ModelAndView confirmPage(@PathVariable Long order_id, HttpServletRequest reqeust) throws Exception {
        try {
            ModelAndView view = new ModelAndView();
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
            view.addObject("dto", (Object)dto);
            if (!StringUtils.isEmpty((String)dto.getProduct_code()) && "XYX-XWCK".equals(dto.getProduct_code())) {
                view.setViewName("/coninsweb/insurance/customs/policy/policyConfirm_mi");
                MicroExportVo vo = this.policyService.accordingToOrderIDToGetMicroExportVo(order_id);
                view.addObject("vo", (Object)vo);
                view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
                view.addObject("reg_rule", (Object)(RegionUtils.getRegionNameByALLCode((String)vo.getLawsuit_province(), (String)vo.getLawsuit_city(), (String)vo.getLawsuit_area()) + vo.getLawsuit_address()));
            } else if (!StringUtils.isEmpty((String)dto.getProduct_code()) && "XYX-DQCK".equals(dto.getProduct_code())) {
                view.setViewName("/coninsweb/insurance/customs/policy/policyConfirm_my");
                CommonExportVo_1 vo1 = this.policyService.accordingToOrderIDToGetCommonExportVo_1(order_id);
                CommonExportVo_2 vo2 = this.policyService.accordingToOrderIDToGetCommonExportVo_2(order_id);
                CommonExportVo_3 vo3 = this.policyService.accordingToOrderIDToGetCommonExportVo_3(order_id);
                view.addObject("vo1", (Object)vo1);
                view.addObject("vo2", (Object)vo2);
                view.addObject("vo3", (Object)vo3);
                view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_district()));
            }
            this.setTokenByApi(view);
            return view;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void initEnumList(ModelAndView view) {
        try {
            view.addObject("listComType", (Object)SysDictUtils.getDictList((String)"comType"));
            view.addObject("listComNature", (Object)SysDictUtils.getDictList((String)"comNature"));
            view.addObject("listIndustry", (Object)SysDictUtils.getDictList((String)"industry"));
            view.addObject("listPayLimit", (Object)SysDictUtils.getDictList((String)"payLimit"));
            view.addObject("listProRata", (Object)SysDictUtils.getDictList((String)"proRata"));
            view.addObject("listAnnualCurrency", (Object)SysDictUtils.getDictList((String)"annualCurrency"));
            view.addObject("listDisputes", (Object)SysDictUtils.getDictList((String)"disputes"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initEnumList_qy(ModelAndView view) {
        view.addObject("listType", (Object)SysDictUtils.getDictList((String)"organizationType"));
        view.addObject("listCurrency", (Object)SysDictUtils.getDictList((String)"currencyRequired"));
        view.addObject("listPaymentTerms", (Object)SysDictUtils.getDictList((String)"paymentTerms"));
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/policy/pendingCommonExportVo_1Policy"})
    @ResponseBody
    public ResultDto pendingCommonExportVo_1Policy(CommonExportVo_1 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        String recommendCode = reqeust.getParameter("recommend_code");
        return this.policyService.pendingCommonExportVo_1Policy(vo, recommendCode);
    }

    @RequestMapping(value={"/policy/pendingCommonExportVo_2Policy"})
    @ResponseBody
    public ResultDto pendingCommonExportVo_2Policy(CommonExportVo_2 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        return this.policyService.pendingCommonExportVo_2Policy(vo);
    }

    @RequestMapping(value={"/policy/pendingCommonExportVo_3Policy"})
    @ResponseBody
    public ResultDto pendingCommonExportVo_3Policy(CommonExportVo_3 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        return this.policyService.pendingCommonExportVo_3Policy(vo);
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/policy/pendingMicroExportPolicy"})
    @ResponseBody
    public ResultDto pendingMicroExportPolicy(MicroExportVo vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        String recommendCode = reqeust.getParameter("recommend_code");
        return this.policyService.pendingMicroExportPolicy(vo, recommendCode);
    }

    @LoginRequired
    @RequestMapping(value={"/policy/updateOrderFormStatus"})
    @ResponseBody
    public ResultDto updateOrderFormStatus(HttpServletRequest reqeust) throws Exception {
        String order_id = reqeust.getParameter("order_id");
        String status = reqeust.getParameter("status");
        if (StringUtils.isEmpty((String)order_id) || StringUtils.isEmpty((String)status)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(order_id));
        vo.setPolicy_status(status);
        try {
            String orderID = this.policyService.updateOrderFormStatus(vo);
            if (StringUtils.isNotEmpty((String)orderID)) {
                return new ResultDto("\u8ba2\u5355\u5f55\u5165\u6210\u529f\u3002", "200", orderID, "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/policy/requestEPolicy/{product_code}/{oid}"})
    @ResponseBody
    public ResultDto requestEPolicy(@PathVariable String product_code, @PathVariable Long oid) throws Exception {
        if (product_code.indexOf("XYX-XWCK") != -1) {
            String path = this.policyService.HTTP_TPC_XYX_DZBD(oid);
            if (StringUtils.isNotEmpty((String)path)) {
                return new ResultDto("", "200", path, "", "");
            }
            return new ResultDto("\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u4eba\u5458", "300", "", "", "");
        }
        return new ResultDto("\u7535\u5b50\u4fdd\u5355\u4e0b\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u4eba\u5458", "300", "", "", "");
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="insurance/customs/policy/policyPayment/{order_id}")
    @RequestMapping(value={"/policy/policyPayment/{order_id}"})
    public ModelAndView savePolicy(@PathVariable long order_id) {
        try {
            OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(order_id));
            ModelAndView view = new ModelAndView();
            if (vo.getPolicy_status().equals("2")) {
                view.setViewName("/coninsweb/insurance/customs/transaction/waitOffer");
            } else if (vo.getPolicy_status().equals("6")) {
                view.setViewName("/coninsweb/insurance/customs/transaction/passUnderwriting");
            } else if (vo.getPolicy_status().equals("15")) {
                view.setViewName("/coninsweb/insurance/customs/transaction/declinature");
            } else if (vo.getPolicy_status().equals("3")) {
                UnderwriteVo underwriteVo = this.policyService.accordingToOrderIDGainInsUnderwrite(Long.valueOf(order_id));
                view.setViewName("/coninsweb/insurance/customs/transaction/offer");
                view.addObject("underwriteVo", (Object)underwriteVo);
            } else if (vo.getPolicy_status().equals("16")) {
                AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(order_id));
                String path_sign = this.policyService.accordingToOrderIDGainPathSign(Long.valueOf(order_id));
                view.setViewName("/coninsweb/insurance/customs/transaction/paymentNotice");
                view.addObject("path_sign", (Object)path_sign);
                view.addObject("anVo", (Object)anVo);
            } else if (vo.getPolicy_status().equals("5")) {
                if (!StringUtils.isEmpty((String)vo.getProduct_code()) && "XYX-XWCK".equals(vo.getProduct_code())) {
                    ThreadUtil.excAsync(() -> this.policyService.yxTimer(Long.valueOf(order_id)), (boolean)false);
                    view.setViewName("/coninsweb/insurance/customs/transaction/finishPay_xw");
                } else {
                    view.setViewName("/coninsweb/insurance/customs/transaction/finishPay");
                }
            }
            view.addObject("nowTime", (Object)new Date());
            view.addObject("dto", (Object)vo);
            this.setTokenByApi(view);
            return view;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/policy/getRuleXWCKVo/{product_id}/{city_code}"})
    @ResponseBody
    public String getRuleXWCKVo(@PathVariable String product_id, @PathVariable String city_code) {
        RuleXWCKVo vo = this.insProductRuleXWCKAPIService.getRuleXWCKVoByProductIDAndCity(product_id, city_code);
        if (vo != null) {
            try {
                return JSONObject.toJSONString((Object)vo);
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    @RequestMapping(value={"/policy/uploadPayMentFile"})
    @ResponseBody
    public ResultDto uploadPayMentFile(HttpServletRequest request) {
        String doPayments = request.getParameter("doPayments");
        String payAmount = request.getParameter("payAmount");
        String policyOid = request.getParameter("policyOid");
        String paymentPath = request.getParameter("payment_path");
        if (StringUtils.isEmpty((String)doPayments) || StringUtils.isEmpty((String)payAmount) || StringUtils.isEmpty((String)policyOid) || StringUtils.isEmpty((String)paymentPath)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u64cd\u4f5c\u5931\u8d25\uff01", "300", "", "", "");
        }
        String orderID = this.policyService.uploadPayMentFileToTranction(paymentPath, policyOid, doPayments, payAmount);
        if (StringUtils.isNotEmpty((String)orderID)) {
            new Thread(() -> this.policyService.JFPZ_SendEmail(Long.valueOf(Long.parseLong(policyOid)), paymentPath)).start();
            return new ResultDto("\u4e0a\u4f20\u6210\u529f\uff01", "200", "true", "", "");
        }
        return new ResultDto("\u6570\u636e\u5b58\u50a8\u5931\u8d25\uff01", "300", "", "", "");
    }

    @LoginRequired(methodParamKey={"0#oid"}, redirectUrl="insurance/customs/policy/finishPay/{oid}")
    @RequestMapping(value={"/policy/finishPay/{oid}"})
    public ModelAndView finishPay(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/customs/transaction/finishPay");
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        view.addObject("dto", (Object)vo);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/sessionInfo"})
    public ResultDto sessionInfo(HttpServletRequest reqeust, ModelMap model) {
        String name = reqeust.getParameter("name");
        String base64 = reqeust.getParameter("base64");
        model.addAttribute(name, (Object)base64);
        return new ResultDto("", "200", "", "", "");
    }
}

