/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.api.build;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.third.build.dubang.Build_DBRequestService;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.InsureVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialLitigationVo_1;
import com.bcxin.ins.vo.SpecialLitigationVo_2;
import com.bcxin.ins.vo.SpecialLitigationVo_3;
import com.bcxin.ins.vo.SpecialPerformanceVo_1;
import com.bcxin.ins.vo.SpecialPerformanceVo_2;
import com.bcxin.ins.vo.SpecialPerformanceVo_3;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class Build_Transaction_Controller
extends BaseController {
    private Logger communicatorLog = LoggerFactory.getLogger(Build_Transaction_Controller.class);
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private Build_DBRequestService build_DBRequestService;
    @Autowired
    private InsTransactionAPIService insTransactionAPIService;
    @Autowired
    private InsTransactionAPIService transactionService;
    private String CODE = "code";
    private String MSG = "msg";
    private String CODE_301 = "301";
    private String POLICYID = "policyId";
    private String POLICYPAYMENTTYPE = "policyPaymentType";
    private String OID = "oid";
    private String PAYMENT_PATH = "payment_path";
    private String MESSAGE = "message";
    private String STATUS = "status";
    private String ENDUPLOAD = "endUpload";

    @LoginRequired
    @RequestMapping(value={"/insurance/build/transaction/policyPayment"})
    public void policyPayment(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        String oid = request.getParameter(this.POLICYID);
        String payType = request.getParameter(this.POLICYPAYMENTTYPE);
        this.policyService.policyPayment_bd_cpic(oid, payType, userdetail.getOid(), response);
    }

    @LoginRequired(methodParamKey={"0#oid"}, redirectUrl="insurance/build/transaction/policyVerify/{oid}")
    @RequestMapping(value={"/insurance/build/transaction/policyVerify/{oid}"})
    public ModelAndView policyVerify(@PathVariable(value="oid") Long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/build/transaction/finishPay");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(oid);
        if (dto != null) {
            this.policyService.port_107002(dto);
            dto = this.policyService.accordingToOrderIDToGetPolicyDto(oid);
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                view.addObject(this.CODE, (Object)"200");
                view.addObject(this.MSG, (Object)"\u652f\u4ed8\u6210\u529f\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)dto.getExternal_reference()) && StringUtils.isNotEmpty((CharSequence)dto.getPolicy_serial_number())) {
                view.addObject(this.CODE, (Object)"300");
                view.addObject(this.MSG, (Object)"\u672a\u5b8c\u6210\u652f\u4ed8\uff01");
            } else if (StringUtils.isEmpty((CharSequence)dto.getPolicy_serial_number())) {
                view.addObject(this.CODE, (Object)this.CODE_301);
                view.addObject(this.MSG, (Object)"\u672a\u5b8c\u6210\u652f\u4ed8\uff01");
            }
            view.addObject("dto", (Object)dto);
        } else {
            view.addObject(this.CODE, (Object)this.CODE_301);
            view.addObject(this.MSG, (Object)"\u8ba2\u5355\u4fe1\u606f\u4e22\u5931\uff01");
        }
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/insurance/build/transaction/lastPolicyVerify/{oid}"})
    @ResponseBody
    public ResultDto lastPolicyVerify(@PathVariable(value="oid") Long oid) {
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(oid);
        if (dto != null) {
            this.policyService.port_107002(dto);
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return new ResultDto("\u652f\u4ed8\u6210\u529f\uff01", "200", "", "", "");
            }
            if (StringUtils.isEmpty((CharSequence)dto.getExternal_reference()) && StringUtils.isNotEmpty((CharSequence)dto.getPolicy_serial_number())) {
                return new ResultDto("\u672a\u5b8c\u6210\u652f\u4ed8\uff01\uff01", "300", dto.getShow_url(), "", "");
            }
            if (StringUtils.isEmpty((CharSequence)dto.getPolicy_serial_number())) {
                return new ResultDto("\u4e3a\u5b8c\u6210\u6838\u4fdd\uff01\uff01", this.CODE_301, dto.getShow_url(), "", "");
            }
        } else {
            return new ResultDto("\u8ba2\u5355\u4fe1\u606f\u4e22\u5931\uff01\uff01", this.CODE_301, dto.getShow_url(), "", "");
        }
        return new ResultDto("\u7cfb\u7edf\u51fa\u9519\uff01\uff01", this.CODE_301, "", "", "");
    }

    @RequestMapping(value={"/insurance/build/transaction/failMessage"})
    public ModelAndView failMessage(HttpServletRequest request) {
        String msg = request.getParameter(this.MSG);
        ModelAndView view = new ModelAndView("/coninsweb/insurance/build/transaction/failMessage");
        view.addObject(this.MSG, (Object)msg);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/transaction/uploadPayMentFile"})
    @ResponseBody
    public ResultDto uploadPayMentFile(HttpServletRequest request) {
        String paymentPath = request.getParameter(this.PAYMENT_PATH);
        String oid = request.getParameter(this.OID);
        return this.policyService.uploadPayMentFile_com(paymentPath, oid);
    }

    @LoginRequired(methodParamKey={"0#oid"}, redirectUrl="insurance/transaction/printPolicy/{oid}")
    @RequestMapping(value={"/insurance/transaction/printPolicy/{oid}"})
    public ModelAndView printPolicy(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/pc/index");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        view.addObject("dto", (Object)dto);
        if (!StringUtils.isEmpty((CharSequence)dto.getProduct_code()) && "BZX-SSBQ".equals(dto.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/transaction/policy/policyPrint_ss");
            SpecialLitigationVo_1 vo1 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_1(Long.valueOf(oid));
            SpecialLitigationVo_2 vo2 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_2(Long.valueOf(oid));
            SpecialLitigationVo_3 vo3 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_3(Long.valueOf(oid));
            view.addObject("vo1", (Object)vo1);
            view.addObject("vo2", (Object)vo2);
            view.addObject("vo3", (Object)vo3);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_district()));
        } else if (!StringUtils.isEmpty((CharSequence)dto.getProduct_code()) && "BZX-GCLY".equals(dto.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/transaction/policy/policyPrint_ly");
            SpecialPerformanceVo_1 vo1 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_1(Long.valueOf(oid));
            SpecialPerformanceVo_2 vo2 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_2(Long.valueOf(oid));
            SpecialPerformanceVo_3 vo3 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_3(Long.valueOf(oid));
            view.addObject("vo1", (Object)vo1);
            view.addObject("vo2", (Object)vo2);
            view.addObject("vo3", (Object)vo3);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_district()));
        }
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/transaction/uploadInsureFile"})
    public JSONObject uploadInsureFile(InsureVo insInsuranceSlip, HttpServletRequest request) {
        JSONObject json = new JSONObject();
        String message = "";
        String status = "300";
        boolean endUpload = false;
        InsInsuranceSlip oldPolicy = this.insInsuranceSlipService.selectById(insInsuranceSlip.getIns_insurance_slip_id());
        InsTransaction transaction = this.transactionService.getTranctionByorderIDAndStatus(oldPolicy.getIns_insurance_slip_id());
        if (StringUtils.isNotEmpty((CharSequence)insInsuranceSlip.getUser_insure_path())) {
            oldPolicy.setUser_insure_path(insInsuranceSlip.getUser_insure_path());
            if (StringUtils.isNotEmpty((CharSequence)oldPolicy.getUser_insure_path()) && StringUtils.isNotEmpty((CharSequence)transaction.getPay_order_url())) {
                endUpload = true;
            }
            this.insInsuranceSlipService.updateById((Object)oldPolicy);
            if (endUpload) {
                String emailTitle = "\u8ba2\u5355\u5df2\u4ed8\u6b3e\u63d0\u9192";
                String string = "\u60a8\u6709\u8ba2\u5355\u5ba2\u6237\u5df2\u4ed8\u6b3e\u5e76\u4e0a\u4f20\u7f34\u8d39\u51ed\u8bc1\u3002";
            }
            new Thread(() -> this.policyService.JFPZ_SendEmail(oldPolicy.getIns_insurance_slip_id(), transaction.getPay_order_url())).start();
            message = "\u4e0a\u4f20\u6210\u529f\uff01";
            status = "200";
        } else {
            message = "\u4e0a\u4f20\u5931\u8d25\uff01";
        }
        json.put(this.MESSAGE, (Object)message);
        json.put(this.STATUS, (Object)status);
        json.put(this.ENDUPLOAD, (Object)endUpload);
        return json;
    }

    @RequestMapping(value={"/insurance/transaction/getQRCode/{oid}"})
    @ResponseBody
    public String getQRCode(@PathVariable long oid) {
        JSONObject json = new JSONObject();
        String result = this.build_DBRequestService.requestDB(Long.valueOf(oid), "2", null);
        json.put(this.MESSAGE, (Object)result.split("#")[1]);
        json.put(this.STATUS, (Object)result.split("#")[0]);
        return json.toJSONString();
    }

    @RequestMapping(value={"/insurance/transaction/isPaySuccess/{oid}"})
    @ResponseBody
    public String isPaySuccess(@PathVariable long oid) {
        InsTransaction it;
        JSONObject json = new JSONObject();
        List tranList = this.insTransactionAPIService.selectInsTransactionByInsOrderForm(Long.valueOf(oid));
        String status = "300";
        if (tranList.size() > 0 && "1".equals((it = (InsTransaction)tranList.get(0)).getTransaction_status())) {
            status = "200";
        }
        json.put(this.STATUS, (Object)status);
        return json.toJSONString();
    }

    @RequestMapping(value={"/insurance/transaction/isPolicyUnderwrite/{oid}"})
    @ResponseBody
    public String isPolicyUnderwrite(@PathVariable long oid) {
        JSONObject json = new JSONObject();
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        String status = "300";
        if (orderVo != null && "6".equals(orderVo.getPolicy_status())) {
            status = "200";
        }
        json.put(this.STATUS, (Object)status);
        return json.toJSONString();
    }

    @RequestMapping(value={"/insurance/transaction/policyUnderwrite/{oid}"})
    public ModelAndView policyUnderwrite(@PathVariable(value="oid") String oid, HttpServletRequest request) {
        this.logger.info("\u6295\u6807\u4fdd\u8bc1\u4fdd\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-star");
        this.logger.info("\u6295\u6807\u4fdd\u8bc1\u4fdd\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-policyUnderwrite\uff1aoid:" + oid);
        ModelAndView view = new ModelAndView("/coninsweb/insurance/build/transaction/finishPay_db");
        if (StringUtils.isNotEmpty((CharSequence)oid)) {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)dto);
            this.logger.info("\u6295\u6807\u4fdd\u8bc1\u4fdd\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-OrderFormVo\uff1a" + dto.toString());
        }
        view.addObject("oid", (Object)oid);
        this.logger.info("\u6295\u6807\u4fdd\u8bc1\u4fdd\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-end");
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/insurance/transaction/uploadInsureFile_user"})
    @ResponseBody
    public ResultDto uploadInsureFile_user(InsureVo insInsuranceSlip, HttpServletRequest request) {
        InsInsuranceSlip oldPolicy = this.insInsuranceSlipService.selectById(insInsuranceSlip.getIns_insurance_slip_id());
        if (StringUtils.isNotEmpty((CharSequence)insInsuranceSlip.getUser_insure_path())) {
            oldPolicy.setUser_insure_path(insInsuranceSlip.getUser_insure_path());
            this.insInsuranceSlipService.updateById((Object)oldPolicy);
            return new ResultDto("\u4e0a\u4f20\u6210\u529f\uff01", "200", "", "", "");
        }
        return new ResultDto("\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
    }

    @LoginRequired(methodParamKey={"0#oid"}, redirectUrl="insurance/transaction/finishPay/{oid}")
    @RequestMapping(value={"/insurance/transaction/finishPay/{oid}"})
    public ModelAndView finishPay(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/transaction/finishPay");
        view.addObject("pd", (Object)this.productService.getProduct(oid));
        view.addObject("dto", (Object)this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid)));
        this.setTokenByApi(view);
        return view;
    }
}

