/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.api.build;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.third.build.yangguang.YGGCService;
import com.bcxin.ins.third.build.yangguang.yggc.Result;
import com.bcxin.ins.third.build.yangguang.yggc.ResultDTO;
import com.bcxin.ins.third.build.yangguang.yggc.YGGC;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.OfficeType;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialBidVo;
import com.bcxin.ins.vo.SpecialPerformanceVo_1;
import com.bcxin.ins.vo.SpecialPerformanceVo_2;
import com.bcxin.ins.vo.SpecialPerformanceVo_3;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/insurance/build"})
public class Build_Policy_Controller
extends BaseController {
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private YGGCService yGGCService;

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u4ea7\u54c1-\u8bbf\u95ee\u6295\u4fdd\u9875")
    @LoginRequired(methodParamKey={"1#product_id"}, redirectUrl="insurance/build/policyInit/{product_id}")
    @RequestMapping(value={"/policyInit/{product_id}"})
    public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) throws Exception {
        ModelAndView view = new ModelAndView();
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        this.orderAllotInit(product_id, view);
        this.setTokenByApi(view);
        return view;
    }

    private void orderAllotInit(Long product_id, ModelAndView view) {
        ProductVo pd = this.productService.getProduct(product_id.longValue());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-TB-GCTB".equals(pd.getProduct_code()) || !StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-YG-GCTB".equals(pd.getProduct_code()) || !StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-DB-GCTB".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_bd");
            view.addObject("otList", (Object)OfficeType.listT((String)(pd.getProduct_code().contains("DB") ? "DB" : "OT")));
            this.initEnumList(view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && "BZX-GCLY".equals(pd.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_ly_1");
            this.initEnumList(view);
        }
    }

    private void orderAllot(Long order_id, ModelAndView view) {
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        if (StringUtils.isEmpty((CharSequence)dto.getProduct_code())) {
            return;
        }
        if ("BZX-TB-GCTB".equals(dto.getProduct_code()) || "BZX-YG-GCTB".equals(dto.getProduct_code()) || "BZX-DB-GCTB".equals(dto.getProduct_code())) {
            view.addObject("otList", (Object)OfficeType.listT((String)(pd.getProduct_code().contains("DB") ? "DB" : "OT")));
            SpecialBidVo vo = this.policyService.accordingToOrderIDToGetSpecialBidVo(order_id);
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            if (StringUtils.isNotEmpty((CharSequence)vo.getProvince())) {
                view.addObject("cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getProvince()));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getCity())) {
                view.addObject("areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)vo.getCity()));
            }
            if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province())) {
                view.addObject("reg_cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
            }
            if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city())) {
                view.addObject("reg_areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getMailPolicyVo().getBank_province())) {
                view.addObject("bankCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getMailPolicyVo().getBank_province()));
            }
            if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province())) {
                view.addObject("reg_city_1_List", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province()));
            }
            if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city())) {
                view.addObject("reg_area_1_List", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city()));
            }
            view.addObject("vo", (Object)vo);
            view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_bd");
            this.initEnumList(view);
        } else if ("BZX-GCLY".equals(dto.getProduct_code())) {
            SpecialPerformanceVo_1 vo = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_1(order_id);
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            if (StringUtils.isNotEmpty((CharSequence)vo.getProvince())) {
                view.addObject("cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getProvince()));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getProvince())) {
                view.addObject("areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)vo.getCity()));
            }
            view.addObject("vo", (Object)vo);
            view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_ly_1");
            this.initEnumList(view);
        }
    }

    private void initEnumList(ModelAndView view) {
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
    }

    @LoginRequired(methodParamKey={"1#order_id"}, redirectUrl="insurance/build/policy/{order_id}")
    @RequestMapping(value={"/policy/{order_id}"})
    public ModelAndView enterInfo(HttpServletRequest request, @PathVariable Long order_id, SessionStatus status, ModelMap model) {
        ModelAndView view = new ModelAndView();
        try {
            this.orderAllot(order_id, view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#order_id", "1#page"}, redirectUrl="insurance/build/policy/pg_policy/{order_id}/{page}")
    @RequestMapping(value={"/policy/pg_policy/{order_id}/{page}"})
    public ModelAndView pg_policy(@PathVariable Long order_id, @PathVariable int page, HttpServletRequest reqeust) throws Exception {
        ModelAndView view = new ModelAndView();
        if (page <= 0) {
            return view;
        }
        OrderFormVo dto = null;
        try {
            dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        view.addObject("dto", (Object)dto);
        if (page == 1) {
            view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_ly_1");
            SpecialPerformanceVo_1 vo = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_1(order_id);
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            if (StringUtils.isNotEmpty((CharSequence)vo.getProvince())) {
                view.addObject("cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getProvince()));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getProvince())) {
                view.addObject("areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)vo.getCity()));
            }
            view.addObject("vo", (Object)vo);
        } else if (page == 2) {
            view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_ly_2");
            SpecialPerformanceVo_2 vo = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_2(order_id);
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            if (StringUtils.isNotEmpty((CharSequence)vo.getMailPolicyVo().getBank_province())) {
                view.addObject("bankCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getMailPolicyVo().getBank_province()));
            }
            if (vo.getRoleSubjectList().size() <= 0) {
                view.addObject("vo", (Object)vo);
                return view;
            }
            if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province())) {
                view.addObject("reg_cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
            }
            if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city())) {
                view.addObject("reg_areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
            }
            if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province())) {
                view.addObject("reg_city_1_List", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province()));
            }
            if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city())) {
                view.addObject("reg_area_1_List", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city()));
            }
            view.addObject("vo", (Object)vo);
        } else if (page == 3) {
            view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_ly_3");
            SpecialPerformanceVo_3 vo = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_3(order_id);
            view.addObject("vo", (Object)vo);
        }
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="insurance/build/policy/confirmPage/{order_id}")
    @RequestMapping(value={"/policy/confirmPage/{order_id}"})
    public ModelAndView confirmPage(@PathVariable Long order_id, HttpServletRequest reqeust) throws Exception {
        ModelAndView view = new ModelAndView();
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        view.addObject("dto", (Object)dto);
        if (StringUtils.isEmpty((CharSequence)dto.getProduct_code())) {
            return view;
        }
        if ("BZX-TB-GCTB".equals(dto.getProduct_code()) || "BZX-YG-GCTB".equals(dto.getProduct_code()) || "BZX-DB-GCTB".equals(dto.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/policy/policyConfirm_bd");
            SpecialBidVo vo = this.policyService.accordingToOrderIDToGetSpecialBidVo(order_id);
            view.addObject("otList", (Object)OfficeType.listT((String)(dto.getProduct_code().contains("DB") ? "DB" : "OT")));
            view.addObject("vo", (Object)vo);
            view.addObject("reg_policy", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getProvince(), (String)vo.getCity(), (String)vo.getArea_code()));
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        } else if ("BZX-GCLY".equals(dto.getProduct_code())) {
            view.setViewName("/coninsweb/insurance/build/policy/policyConfirm_ly");
            SpecialPerformanceVo_1 vo1 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_1(order_id);
            SpecialPerformanceVo_2 vo2 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_2(order_id);
            SpecialPerformanceVo_3 vo3 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_3(order_id);
            view.addObject("vo1", (Object)vo1);
            view.addObject("vo2", (Object)vo2);
            view.addObject("vo3", (Object)vo3);
            view.addObject("reg_policy", (Object)RegionUtils.getRegionNameByALLCode((String)vo1.getProvince(), (String)vo1.getCity(), (String)vo1.getArea_code()));
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_district()));
        }
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/policy/pendingSpecialPerformance_1VoPolicy"})
    @ResponseBody
    public ResultDto pendingSpecialPerformance_1VoPolicy(SpecialPerformanceVo_1 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        String recommendCode = reqeust.getParameter("recommend_code");
        return this.policyService.pendingSpecialPerformance_1VoPolicy(vo, recommendCode);
    }

    @RequestMapping(value={"/policy/pendingSpecialPerformance_2VoPolicy"})
    @ResponseBody
    public ResultDto pendingSpecialPerformance_2VoPolicy(SpecialPerformanceVo_2 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        return this.policyService.pendingSpecialPerformance_2VoPolicy(vo);
    }

    @RequestMapping(value={"/policy/pendingSpecialPerformance_3VoPolicy"})
    @ResponseBody
    public ResultDto pendingSpecialPerformance_3VoPolicy(SpecialPerformanceVo_3 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        return this.policyService.pendingSpecialPerformance_3VoPolicy(vo);
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/policy/pendingSpecialBidPolicy"})
    @ResponseBody
    public ResultDto pendingSpecialBidPolicy(SpecialBidVo vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        String recommendCode = reqeust.getParameter("recommend_code");
        return this.policyService.pendingSpecialBidPolicy(vo, recommendCode);
    }

    @RequestMapping(value={"/policy/json"})
    @ResponseBody
    public ModelAndView testJson(HttpServletRequest reqeust, HttpServletResponse response) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/build/transaction/testJson");
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired
    @RequestMapping(value={"/policy/updateOrderFormStatus"})
    @ResponseBody
    public ResultDto updateOrderFormStatus(HttpServletRequest reqeust) throws Exception {
        String result;
        String order_id = reqeust.getParameter("order_id");
        String status = reqeust.getParameter("status");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(order_id));
        String url = null;
        if (StringUtils.isNotEmpty((CharSequence)dto.getProduct_code()) && "BZX-YG-GCTB".equals(dto.getProduct_code())) {
            try {
                SpecialBidVo specialBidVo = this.policyService.accordingToOrderIDToGetSpecialBidVo(Long.valueOf(order_id));
                Result result2 = this.yGGCService.underwritingHttpSend(JSON.toJSONString((Object)YGGC.getDemo((OrderFormVo)dto, (SpecialBidVo)specialBidVo)), "1");
                String errorCode = ((ResultDTO)result2.getTbResultList().get(0)).getErrorCode();
                String policyNo = ((ResultDTO)result2.getTbResultList().get(0)).getPolicyNo();
                String premiumP = specialBidVo.getPremium();
                if (!"SUCCESS00000".equals(errorCode)) {
                    String operateMessage = ((ResultDTO)result2.getTbResultList().get(0)).getOperateMessage();
                    return new ResultDto("\u5ba1\u6838\u5931\u8d25\uff1a" + operateMessage, "300", order_id, "", "");
                }
                R r = this.yGGCService.payUrlZFB(policyNo, premiumP);
                if (r.getSuccess().booleanValue()) {
                    PolicyTransactionVo pvo = new PolicyTransactionVo();
                    pvo.setPolicy_id(dto.getOid());
                    pvo.setPolicy_serial_number(policyNo);
                    this.policyService.saveTransaction(pvo);
                    url = r.getMsg();
                }
            }
            catch (Exception e) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                e.printStackTrace();
            }
        } else if (StringUtils.isNotEmpty((CharSequence)dto.getProduct_code()) && "BZX-DB-GCTB".equals(dto.getProduct_code()) && "300".equals((result = this.policyService.HTTP_DB_BUILD_HB(order_id)).split("#")[0])) {
            return new ResultDto(result.split("#")[1], "300", "", "", "");
        }
        if (StringUtils.isEmpty((CharSequence)order_id) || StringUtils.isEmpty((CharSequence)status)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(order_id));
        vo.setPolicy_status(status);
        String orderID = this.policyService.updateOrderFormStatus(vo);
        if (StringUtils.isNotEmpty((CharSequence)orderID)) {
            return new ResultDto("\u8ba2\u5355\u5f55\u5165\u6210\u529f\u3002", "200", orderID, "", url);
        }
        return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
    }

    @LoginRequired(methodParamKey={"0#oid"}, redirectUrl="insurance/build/policy/policyPayment/{oid}")
    @RequestMapping(value={"/policy/policyPayment/{oid}"})
    @Transactional
    public ModelAndView savePolicy(@PathVariable long oid) {
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        ModelAndView view = null;
        if (vo.getPolicy_status().equals("2")) {
            view = new ModelAndView("/coninsweb/insurance/build/transaction/waitOffer");
        } else if (vo.getPolicy_status().equals("6")) {
            view = new ModelAndView("/coninsweb/insurance/build/transaction/finishPay");
            view.addObject("code", (Object)"200");
            view.addObject("msg", (Object)"\u652f\u4ed8\u6210\u529f\uff01");
        } else if (vo.getPolicy_status().equals("15")) {
            view = new ModelAndView("/coninsweb/insurance/build/transaction/declinature");
        } else if (vo.getPolicy_status().equals("4")) {
            if (!StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && "BZX-TB-GCTB".equals(vo.getProduct_code())) {
                view = new ModelAndView("/coninsweb/insurance/build/transaction/policyPayment");
            } else if (!StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && "BZX-YG-GCTB".equals(vo.getProduct_code())) {
                view = new ModelAndView("/coninsweb/insurance/build/transaction/policyPaymentYG");
                this.GCTB_YG_Payment(oid, vo, view);
            } else if (!StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && "BZX-DB-GCTB".equals(vo.getProduct_code())) {
                view = new ModelAndView("/coninsweb/insurance/build/transaction/policyPaymentDB");
            } else if (!StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && "BZX-GCLY".equals(vo.getProduct_code())) {
                AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(oid));
                String path_sign = this.policyService.accordingToOrderIDGainPathSign(Long.valueOf(oid));
                view = new ModelAndView("/coninsweb/insurance/transaction/paymentNotice");
                view.addObject("anVo", (Object)anVo);
                view.addObject("path_sign", (Object)path_sign);
            }
        } else if (vo.getPolicy_status().equals("5")) {
            view = new ModelAndView("/coninsweb/insurance/build/transaction/finishPay_ly");
        }
        view.addObject("dto", (Object)vo);
        view.addObject("nowTime", (Object)new Date());
        this.setTokenByApi(view);
        return view;
    }

    private void GCTB_YG_Payment(@PathVariable long oid, OrderFormVo vo, ModelAndView view) {
        String url = null;
        boolean isSuccess = true;
        try {
            SpecialBidVo specialBidVo = this.policyService.accordingToOrderIDToGetSpecialBidVo(Long.valueOf(oid));
            Result result = this.yGGCService.underwritingHttpSend(JSON.toJSONString((Object)YGGC.getDemo((OrderFormVo)vo, (SpecialBidVo)specialBidVo)), "1");
            String errorCode = ((ResultDTO)result.getTbResultList().get(0)).getErrorCode();
            String policyNo = ((ResultDTO)result.getTbResultList().get(0)).getPolicyNo();
            String premiumP = specialBidVo.getPremium();
            if ("SUCCESS00000".equals(errorCode)) {
                R r = this.yGGCService.payUrlZFB(policyNo, premiumP);
                if (r.getSuccess().booleanValue()) {
                    PolicyTransactionVo pvo = new PolicyTransactionVo();
                    pvo.setPolicy_id(vo.getOid());
                    pvo.setPolicy_serial_number(policyNo);
                    this.policyService.saveTransaction(pvo);
                    url = r.getMsg();
                }
            } else {
                String operateMessage = ((ResultDTO)result.getTbResultList().get(0)).getOperateMessage();
                isSuccess = false;
                url = "/insurance/build/policy/updateOrderFormStatus";
                view.addObject("wrongMessage", (Object)operateMessage);
            }
            view.addObject("oid", (Object)oid);
            view.addObject("isSuccess", (Object)isSuccess);
            view.addObject("url", (Object)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/policy/downloadInsurancePolicy/{oid}"})
    @ResponseBody
    public ResultDto downloadInsurancePolicy(@PathVariable long oid) {
        String downloadUrl = this.policyService.HTTP_YG_BUILD_DZBD(String.valueOf(oid));
        if (StringUtils.isNotEmpty((CharSequence)downloadUrl)) {
            return new ResultDto("\u7535\u5b50\u4fdd\u5355\u4e0b\u8f7d\u5730\u5740\u83b7\u53d6\u6210\u529f", "200", "\u8bf7\u6c42ID:" + oid, "", downloadUrl);
        }
        return new ResultDto("\u4fdd\u5355\u4e0b\u8f7d\u8bf7\u6c42\u5931\u8d25", "300", "\u8bf7\u6c42ID:" + oid, "", "");
    }

    @RequestMapping(value={"/policy/requestPlanEndTime"})
    @ResponseBody
    public ResultDto requestPlanEndTime(HttpServletRequest request) throws Exception {
        Date planTime;
        String bidtime = request.getParameter("bidtime");
        String bidPeriod = request.getParameter("bidPeriod");
        String productCode = request.getParameter("productCode");
        if (StringUtils.isEmpty((CharSequence)productCode) || StringUtils.isEmpty((CharSequence)bidtime) || StringUtils.isEmpty((CharSequence)bidPeriod)) {
            return new ResultDto("", "301", "", "", "");
        }
        int bpd = Integer.parseInt(bidPeriod) + 28;
        Date planTimeLast = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)3, (String)bidtime, (int)Integer.parseInt(bidPeriod)));
        Date planTimeNow = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)3, (String)bidtime, (int)bpd));
        if (productCode.contains("BZX-TB")) {
            planTime = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)1, (String)bidtime, (int)1));
            if (DateUtil.calculateTwoDateDvalue((Date)planTime, (Date)planTimeLast) < 0L) {
                return new ResultDto("\u4fdd\u9669\u671f\u95f4\u5927\u4e8e\u4e00\u5e74\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6295\u6807\u6709\u6548\u671f\uff01", "300", "", "", "");
            }
            if (DateUtil.calculateTwoDateDvalue((Date)planTime, (Date)planTimeNow) < 0L) {
                planTimeNow = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)3, (String)DateUtil.dateAdd((int)1, (String)bidtime, (int)1), (int)-1));
            }
        } else if (productCode.contains("BZX-YG")) {
            planTime = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)1, (String)bidtime, (int)1));
            if (DateUtil.calculateTwoDateDvalue((Date)planTime, (Date)planTimeLast) < 0L) {
                return new ResultDto("\u4fdd\u9669\u671f\u95f4\u5927\u4e8e\u4e00\u5e74\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6295\u6807\u6709\u6548\u671f\uff01", "300", "", "", "");
            }
            if (DateUtil.calculateTwoDateDvalue((Date)planTime, (Date)planTimeNow) < 0L) {
                planTimeNow = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)3, (String)DateUtil.dateAdd((int)1, (String)bidtime, (int)1), (int)-1));
            }
        } else if (productCode.contains("BZX-DB")) {
            planTime = DateUtil.convertStringToDate((String)DateUtil.dateAdd((int)2, (String)bidtime, (int)3));
            if (DateUtil.calculateTwoDateDvalue((Date)planTime, (Date)planTimeLast) < 0L) {
                return new ResultDto("\u4fdd\u9669\u671f\u95f4\u4e0d\u80fd\u5927\u4e8e\u4e09\u4e2a\u6708\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6295\u6807\u6709\u6548\u671f\uff01", "300", "", "", "");
            }
            if (DateUtil.calculateTwoDateDvalue((Date)planTime, (Date)planTimeNow) < 0L) {
                planTimeNow = planTime;
            }
        }
        if (planTimeNow != null) {
            String plannedEnd = DateUtil.convertDateToString((Date)planTimeNow, (String)"yyyy-MM-dd");
            return new ResultDto(plannedEnd, "200", "", "", "");
        }
        return new ResultDto("\u83b7\u53d6\u5931\u6548\u65e5\u671f\u5931\u8d25", "300", "", "", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/policy/computePremium"})
    @ResponseBody
    public ResultDto computePremium(HttpServletRequest request) {
        String insuredAmount = request.getParameter("insuredAmount");
        String productCode = request.getParameter("productCode");
        String provinceCode = request.getParameter("provinceCode");
        String cityCode = request.getParameter("cityCode");
        String aptitudeLevel = request.getParameter("aptitudeLevel");
        String officeType = request.getParameter("officeType");
        if (StringUtils.isEmpty((CharSequence)insuredAmount) || StringUtils.isEmpty((CharSequence)productCode) || StringUtils.isEmpty((CharSequence)provinceCode) || StringUtils.isEmpty((CharSequence)cityCode)) {
            return new ResultDto("", "300", "", "", "");
        }
        BigDecimal premium = BigDecimal.ZERO;
        if ("350200".equals(cityCode)) {
            premium = this.numPremium(insuredAmount, aptitudeLevel, officeType);
        } else if (productCode.contains("BZX-DB")) {
            premium = this.numPremium(insuredAmount, aptitudeLevel, officeType);
        } else {
            if (!productCode.contains("BZX-TB")) return new ResultDto("", "300", "", "", "");
            if (!"350000".equals(provinceCode)) return new ResultDto("", "300", "", "", "");
            premium = this.numPremiumOt(insuredAmount);
        }
        if (premium.compareTo(BigDecimal.ZERO) < 0) return new ResultDto("", "300", "", "", "");
        return new ResultDto(String.valueOf(premium.setScale(2, 4)), "200", "", "", "");
    }

    private BigDecimal numPremiumOt(String insuredAmount) {
        BigDecimal ia = BigDecimal.valueOf(Double.parseDouble(insuredAmount));
        BigDecimal premium = BigDecimal.ZERO;
        if (ia.compareTo(BigDecimal.ZERO) >= 0 && BigDecimal.valueOf(Double.parseDouble("100000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("150"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("100000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("800000")).compareTo(ia) >= 0) {
            premium = ia.multiply(BigDecimal.valueOf(Double.parseDouble("0.0015")));
        }
        return premium;
    }

    private BigDecimal numPremium(String insuredAmount, String aptitudeLevel, String officeType) {
        BigDecimal ia = BigDecimal.valueOf(Double.parseDouble(insuredAmount));
        BigDecimal premium = BigDecimal.ZERO;
        if (ia.compareTo(BigDecimal.ZERO) >= 0 && BigDecimal.valueOf(Double.parseDouble("100000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("300"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("100000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("200000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("350"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("200000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("300000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("400"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("300000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("400000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("450"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("400000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("500000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("500"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("500000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("600000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("550"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("600000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("700000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("600"));
        } else if (ia.compareTo(BigDecimal.valueOf(Double.parseDouble("700000"))) >= 0 && BigDecimal.valueOf(Double.parseDouble("800000")).compareTo(ia) >= 0) {
            premium = BigDecimal.valueOf(Double.parseDouble("650"));
        }
        return premium.multiply(this.alNum(aptitudeLevel)).multiply(this.otNum(officeType));
    }

    private BigDecimal alNum(String aptitudeLevel) {
        if ("1".equals(aptitudeLevel)) {
            return BigDecimal.valueOf(Double.parseDouble("0.7"));
        }
        if ("2".equals(aptitudeLevel)) {
            return BigDecimal.valueOf(Double.parseDouble("0.95"));
        }
        if ("3".equals(aptitudeLevel)) {
            return BigDecimal.valueOf(Double.parseDouble("1"));
        }
        if ("4".equals(aptitudeLevel)) {
            return BigDecimal.valueOf(Double.parseDouble("1.3"));
        }
        if ("5".equals(aptitudeLevel)) {
            return BigDecimal.valueOf(Double.parseDouble("1.5"));
        }
        return BigDecimal.valueOf(Double.parseDouble("1"));
    }

    private BigDecimal otNum(String officeType) {
        if ("7".equals(officeType) || "0001".equals(officeType)) {
            return BigDecimal.valueOf(Double.parseDouble("0.7"));
        }
        return BigDecimal.valueOf(Double.parseDouble("1"));
    }
}

