/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.common.controller;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.ME;
import com.bcxin.ins.dto.ResultDto;
import com.bcxin.ins.entity.user.SysClientCompany;
import com.bcxin.ins.entity.user.SysClientUserPost;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.common.ModelSendService;
import com.bcxin.ins.service.common.SysClientUserPostService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.user.ClientCompanyService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.IdCardVerify;
import com.bcxin.ins.util.IpAddress;
import com.bcxin.ins.util.MathUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.Sha1Util;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.EmailMsgType;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsOrderSearchVo;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/pc"})
public class PersonalCenterController
extends BaseController {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private SysClientUserPostService sysClientUserPostService;
    @Autowired
    private ClientUserService userService;
    @Autowired
    private ClientCompanyService companyService;
    @Autowired
    private ModelSendService mss;

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237")
    @LoginRequired(redirectUrl="redirect:/pc/index")
    @RequestMapping(value={"index"})
    public ModelAndView personalCenterIndex(DwzPage page) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (page == null) {
            page = new DwzPage();
        }
        page.setNumPerPage(5);
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/index");
        new Thread(() -> {
            try {
                if (GlobalResources.IS_POLICY_TP107001_OPEN.equals("YES")) {
                    this.policyService.policyEndStatus(userdetail.getOid());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
        String keyword = this.getRequest().getParameter("keyword");
        String starDate = this.getRequest().getParameter("starDate");
        String endDate = this.getRequest().getParameter("endDate");
        try {
            InsOrderSearchVo search = InsOrderSearchVo.build((Long)Long.parseLong(userdetail.getOid()), (String)"1", (String)"", (String)keyword, (String)starDate, (String)endDate, (String)"", (DwzPage)page);
            view.addObject("policyTotals", (Object)this.policyService.findTotalPolicyNum(search));
            view.addObject("orderList", (Object)this.policyService.findPolicyForPage(search));
            view.addObject("policyStatus", (Object)"1");
            view.addObject("num", (Object)this.getNum(userdetail));
            view.addObject("date", (Object)DateUtil.getCurrentDateTime());
        }
        catch (Exception ex) {
            this.logger.error("\u6211\u7684\u8d26\u6237", (Throwable)ex);
        }
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"claimList"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u7406\u8d54\u67e5\u8be2")
    public ModelAndView claimListInit(DwzPage page) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/pc/claimList");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/claimList_new");
        page.setNumPerPage(5);
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/mailAddress"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u90ae\u5bc4\u5730\u5740")
    public String mailAddress(@RequestParam Map<Object, Object> params, Model model) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return DSUtil.operation() + "/pc/mailAddress";
        }
        model.addAttribute("userdetail", (Object)userdetail);
        model.addAttribute("row", (Object)this.sysClientUserPostService.selectByMap(new ME().put("sys_client_user_id", (Object)userdetail.getOid()).getM()));
        this.setTokenByApi(model);
        return "/coninsweb/personalCenter/mailAddress";
    }

    @RequestMapping(value={"/tb-mail-address/{uid}"})
    @ResponseBody
    public Object tbMailAddress(@PathVariable String uid) {
        List ar = this.sysClientUserPostService.selectByMap(new ME().put("sys_client_user_id", (Object)uid).getM());
        if (ar != null && ar.size() > 0) {
            SysClientUserPost scup = (SysClientUserPost)ar.get(0);
            String address = RegionUtils.getRegionNameByALLCode((String)scup.getProvince(), (String)scup.getCity(), (String)scup.getDistrict()) + scup.getAddress();
            scup.setAddress(address);
            return scup;
        }
        return null;
    }

    @RequestMapping(value={"/mailAddress/save"})
    @ResponseBody
    public Object mailAddressSave(@RequestParam Map<Object, Object> params, Model model) {
        if (UserSupportUtil.getSessionUser() == null) {
            return DSUtil.operation() + "/pc/mailAddress";
        }
        return this.sysClientUserPostService.add(params);
    }

    @RequestMapping(value={"myAccount"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u6211\u7684\u8d44\u6599")
    public ModelAndView myAccount() {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/pc/myAccount");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/myAccount");
        if ("2".equals(userdetail.getTerminal_type())) {
            view.addObject("idTypeList", (Object)IdType.companyList());
            view.addObject("companyIdTypeList", (Object)IdType.companyCodeList());
            view.addObject("natureList", (Object)NatureLinkage.getListByProvince((String)""));
            if (StringUtils.isNotEmpty((String)userdetail.getEnterprise_type())) {
                view.addObject("natureTwoList", (Object)NatureLinkage.getListByProvince((String)userdetail.getEnterprise_type()));
            }
        }
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    private String getNum(ClientUserVo userdetail) {
        int num = 0;
        if ("1".equals(userdetail.getIs_certification())) {
            num = 60;
        }
        if ("1".equals(userdetail.getC_is_certification())) {
            num = 60;
        }
        if (StringUtils.isNotEmpty((String)userdetail.getEmail())) {
            num += 20;
        }
        if (StringUtils.isNotEmpty((String)userdetail.getTelephone())) {
            num += 20;
        }
        return num + "";
    }

    @RequestMapping(value={"/myAccount/saveInfo"})
    @ResponseBody
    public ResultDto saveAccountInfo(SysClientCompany company, HttpServletRequest request) {
        ClientUserVo vo = UserSupportUtil.getSessionUser();
        company.setIs_certification("1");
        if (this.companyService.saveCompany(company, vo)) {
            return new ResultDto("\u4fdd\u5b58\u6210\u529f", "200", "", "", "");
        }
        return new ResultDto("\u4fdd\u5b58\u5931\u8d25", "300", "", "", "");
    }

    @RequestMapping(value={"realNameAuthentication"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u5b9e\u540d\u8ba4\u8bc1")
    public ModelAndView realNameAuthentication() {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/pc/realNameAuthentication");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/realNameAuthentication");
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/sendAuthCode"})
    @ResponseBody
    public ResultDto sendAuthCode(HttpServletRequest request) {
        return new ResultDto("\u624b\u673a\u53d1\u9001\u5931\u8d25", "300", "", "", "");
    }

    @RequestMapping(value={"/sendEmailCode"})
    @ResponseBody
    public ResultDto sendEmailCode(HttpServletRequest request) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String type = request.getParameter("type");
        if (StringUtils.isNotEmpty((String)userdetail.getEmail())) {
            String code = MathUtil.getRandomCode();
            EmailModel em = new EmailModel(code, EmailMsgType.SMYZM);
            if (StringUtils.isNotEmpty((String)type)) {
                em = new EmailModel(code, EmailMsgType.TYYZM);
            }
            em.addTo(userdetail.getEmail());
            try {
                SendEmailAndMsgUtil.sendEmail((EmailModel)em);
                String keyac = "authenticationCode:" + IpAddress.getIpAddress((HttpServletRequest)this.getRequest());
                JedisUtils.set((String)keyac, (String)code, (int)300);
                return new ResultDto("", "200", "", "", "");
            }
            catch (Exception e) {
                return new ResultDto("\u670d\u52a1\u5668\u672a\u54cd\u5e94\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\uff01", "300", "", "", "");
            }
        }
        return new ResultDto("\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a", "300", "", "", "");
    }

    @RequestMapping(value={"/sendEmailAgainCode"})
    @ResponseBody
    public ResultDto sendEmailAgainCode(HttpServletRequest request) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String email = request.getParameter("email");
        if (StringUtils.isNotEmpty((String)email)) {
            String code = MathUtil.getRandomCode();
            EmailModel em = new EmailModel(code, EmailMsgType.BDYZM);
            em.addTo(email);
            try {
                SendEmailAndMsgUtil.sendEmail((EmailModel)em);
                String keyauac = "authenticationAgainCode:" + IpAddress.getIpAddress((HttpServletRequest)this.getRequest());
                JedisUtils.set((String)keyauac, (String)code, (int)300);
                return new ResultDto("", "200", "", "", "");
            }
            catch (Exception e) {
                return new ResultDto("\u670d\u52a1\u5668\u672a\u54cd\u5e94\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\uff01", "300", "", "", "");
            }
        }
        return new ResultDto("\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a", "300", "", "", "");
    }

    @RequestMapping(value={"/sendPhoneAgainCode"})
    @ResponseBody
    public ResultDto sendPhoneAgainCode(HttpServletRequest request) {
        return new ResultDto("\u624b\u673a\u53d1\u9001\u5931\u8d25", "300", "", "", "");
    }

    @RequestMapping(value={"/checkAuthCode"})
    @ResponseBody
    public ResultDto checkAuthCode(@RequestParam String code, HttpServletRequest request) {
        if (StringUtils.isNotEmpty((String)code)) {
            String keyac = "authenticationCode:" + IpAddress.getIpAddress((HttpServletRequest)this.getRequest());
            String codeAuth = JedisUtils.get((String)keyac);
            if (StringUtils.isEmpty((String)codeAuth)) {
                return new ResultDto("", "300", "", "", "");
            }
            if (codeAuth.equals(code)) {
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("", "300", "", "", "");
        }
        return new ResultDto("", "300", "", "", "");
    }

    @RequestMapping(value={"/checkAuthAgainCode"})
    @ResponseBody
    public ResultDto checkAuthAgainCode(@RequestParam String code, HttpServletRequest request) {
        if (StringUtils.isNotEmpty((String)code)) {
            String keyauac = "authenticationAgainCode:" + IpAddress.getIpAddress((HttpServletRequest)this.getRequest());
            String codeAuth = JedisUtils.get((String)keyauac);
            if (StringUtils.isEmpty((String)codeAuth)) {
                return new ResultDto("", "300", "", "", "");
            }
            if (codeAuth.equals(code)) {
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("", "300", "", "", "");
        }
        return new ResultDto("", "300", "", "", "");
    }

    @RequestMapping(value={"/realNameAuthentication/saveInfo"})
    @ResponseBody
    public ResultDto saveInfo(HttpServletRequest request) {
        String realName = request.getParameter("real_name");
        String realCard = request.getParameter("real_card");
        if (StringUtils.isNotEmpty((String)realName) && IdCardVerify.isValidatedAllIdcard((String)realCard)) {
            ClientUserVo vo = UserSupportUtil.getSessionUser();
            if (this.userService.updClientUserVoInfo(vo, realName, realCard)) {
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("\u4fdd\u5b58\u5931\u8d25", "300", "", "", "");
        }
        return new ResultDto("\u8eab\u4efd\u8bc1\u9519\u8bef", "300", "", "", "");
    }

    @RequestMapping(value={"/email/saveInfo"})
    @ResponseBody
    public ResultDto saveEmailInfo(HttpServletRequest request) {
        String email = request.getParameter("again_email");
        if (StringUtils.isNotEmpty((String)email)) {
            ClientUserVo vo = UserSupportUtil.getSessionUser();
            if (!this.userService.getUserEmailForRegister(email, "BLB")) {
                return new ResultDto("\u90ae\u7bb1\u5df2\u7ecf\u88ab\u6ce8\u518c\uff0c\u8bf7\u66f4\u6362\u90ae\u7bb1", "300", "", "", "");
            }
            if (this.userService.updClientUserVoEmail(vo, email)) {
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("\u66f4\u65b0\u90ae\u7bb1\u5931\u8d25", "300", "", "", "");
        }
        return new ResultDto("\u6570\u636e\u4e22\u5931", "300", "", "", "");
    }

    @RequestMapping(value={"/phone/saveInfo"})
    @ResponseBody
    public ResultDto savePhoneInfo(HttpServletRequest request) {
        String phone = request.getParameter("again_phone");
        if (StringUtils.isNotEmpty((String)phone)) {
            ClientUserVo vo = UserSupportUtil.getSessionUser();
            if (!this.userService.getUserMobileForRegister(phone, "BLB")) {
                return new ResultDto("\u4fdd\u5b58\u5931\u8d25", "300", "", "", "");
            }
            if (this.userService.updClientUserVoPhone(vo, phone)) {
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("\u4fdd\u5b58\u5931\u8d25", "300", "", "", "");
        }
        return new ResultDto("\u8eab\u4efd\u8bc1\u9519\u8bef", "300", "", "", "");
    }

    @RequestMapping(value={"phoneInit"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u7ed1\u5b9a\u624b\u673a\u53f7\u7801")
    public ModelAndView phoneInit() {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/pc/phoneInit");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/phoneInit");
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"emailInit"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u7ed1\u5b9a\u90ae\u7bb1")
    public ModelAndView emailInit() {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/pc/emailInit");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/emailInit");
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"updPwdInit"})
    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u6211\u7684\u8d26\u6237-\u4fee\u6539\u5bc6\u7801")
    public ModelAndView updPwdInit() {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/pc/updPwdInit");
        }
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/updPwdInit");
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/pwd/checkOldPwd"})
    @ResponseBody
    public ResultDto checkOldPwd(HttpServletRequest request) {
        String oldPwd = request.getParameter("oldPwd");
        if (StringUtils.isNotEmpty((String)oldPwd)) {
            ClientUserVo vo = UserSupportUtil.getSessionUser();
            if (Sha1Util.validatePassword((String)oldPwd, (String)vo.getPassword())) {
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("\u5bc6\u7801\u9519\u8bef", "300", "", "", "");
        }
        return new ResultDto("\u5bc6\u7801\u9519\u8bef", "300", "", "", "");
    }

    @RequestMapping(value={"/pwd/savePwd"})
    @ResponseBody
    public ResultDto savePwd(HttpServletRequest request) {
        String newPwd = request.getParameter("newPwd");
        if (StringUtils.isNotEmpty((String)newPwd)) {
            ClientUserVo vo = UserSupportUtil.getSessionUser();
            if (this.userService.getUserPassword(vo.getLogin_name(), newPwd)) {
                vo.setPassword(Sha1Util.entryptPassword((String)newPwd));
                UserSupportUtil.setSessionUser((ClientUserVo)vo);
                return new ResultDto("", "200", "", "", "");
            }
            return new ResultDto("\u4fdd\u5b58\u65b0\u5bc6\u7801\u5931\u8d25", "300", "", "", "");
        }
        return new ResultDto("\u4fdd\u5b58\u65b0\u5bc6\u7801\u5931\u8d25", "300", "", "", "");
    }

    @RequestMapping(value={"/down_security_personnel/{oid}"})
    public void downSecurityPersonnel(@PathVariable Long oid, HttpServletResponse resp) {
        this.policyService.downSecurityPersonnel(oid, resp);
    }
}

