/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.common.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.dto.ResultDto;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.third.gzzrx.pingancai.GZZRX_PACRequestService;
import com.bcxin.ins.util.BASE64Util;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.FileHelp;
import com.bcxin.ins.util.FileUtils;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.MultipartFileImpl;
import com.bcxin.ins.util.OSSFileUtil;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.service.IobsService;
import com.xiaoleilu.hutool.http.HttpUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class FileUploadController
extends BaseController {
    private static String IMG_PATH = "/upload/img/";
    private static String FLASH_PATH = "/upload/flash/";
    private static String MEDIA_PATH = "/upload/media/";
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private GZZRX_PACRequestService gZZRX_PACRequestService;

    @RequestMapping(value={"/dwz/fileUpload"}, method={RequestMethod.GET, RequestMethod.POST})
    public void upImg(MultipartFile filedata, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        String url = OSSFileUtil.huaweiOBSFileUpload((MultipartFile)filedata, (String)"");
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            String cdnUrl;
            if (!GlobalResources.IS_TEST_ENVI.booleanValue() && StringUtils.isNotEmpty((CharSequence)(cdnUrl = GlobalResources.HW_CDN_URL))) {
                url = cdnUrl + url.substring(url.indexOf("upload") - 1);
            }
            PrintWriter out = response.getWriter();
            out.println("{\"err\":\"\",\"msg\":\"" + url + "\"}");
            out.flush();
            out.close();
        }
        System.out.println("url:" + url);
    }

    @RequestMapping(value={"/base64/fileToString"})
    public JSONObject fileToString(@RequestParam(value="file") MultipartFile imageFile, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject json = new JSONObject();
        String fileName = imageFile.getOriginalFilename();
        String fileType = fileName.split("\\.")[1];
        byte[] bytes = imageFile.getBytes();
        String fileString = BASE64Util.encryptBASE64Byte((byte[])bytes);
        json.put("fileType", (Object)fileType);
        json.put("fileString", (Object)fileString);
        return json;
    }

    @RequestMapping(value={"/downloadAttachment"})
    public void downloadAttachment(@RequestParam(value="oid") long oid, @RequestParam(value="name") String name, @RequestParam(value="code") String code, HttpServletResponse response) {
        InsInsuranceSlip policy = this.insInsuranceSlipService.selectById(Long.valueOf(oid));
        String attachPath = "";
        attachPath = "1".equals(code) ? policy.getInsure_path() : policy.getLg_path();
        long fileLength = new File(attachPath).length();
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(attachPath));
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            int bytesRead;
            response.reset();
            response.setHeader("Content-Disposition", "attachment; filename=" + new String(name.getBytes("gbk"), "iso-8859-1") + ".pdf");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Length", String.valueOf(fileLength));
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/t/test"})
    public ModelAndView test() {
        ModelAndView view = new ModelAndView("/flows/PolicySale/test");
        return view;
    }

    @RequestMapping(value={"/dwz/uploadfy"})
    @ResponseBody
    public R uploadfy(HttpServletRequest request) {
        String names = request.getParameter("name");
        String base64 = request.getParameter("base64");
        String savePath = "/policy/";
        this.logger.info(base64);
        if (StringUtils.isNotEmpty((CharSequence)base64)) {
            try {
                String fileData = base64.split(",")[1];
                byte[] bytes = BASE64Util.decryptBASE64Byte((String)fileData);
                String files = DateUtil.generatorRadomNumber() + "." + names;
                String result = savePath + files;
                String path = GlobalResources.COM_IMG_RE + savePath;
                FileHelp.byteFile((byte[])bytes, (String)path, (String)files);
                result = "/getResource?path=" + result;
                return new R(Boolean.valueOf(true), result);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new R(Boolean.valueOf(false), "\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
            }
        }
        return new R(Boolean.valueOf(false), "\u6587\u4ef6\u5b58\u50a8\u5931\u8d25");
    }

    @RequestMapping(value={"/file/ajaxFormDataLoad"})
    @ResponseBody
    public ResultDto ajaxFormDataLoad(@RequestParam(value="file", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (file != null) {
            String directoryName = request.getParameter("directoryName");
            String url = OSSFileUtil.huaweiOBSFileUpload((MultipartFile)file, (String)directoryName);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                String cdnUrl;
                if (!GlobalResources.IS_TEST_ENVI.booleanValue() && StringUtils.isNotEmpty((CharSequence)(cdnUrl = GlobalResources.HW_CDN_URL))) {
                    url = cdnUrl + url.substring(url.indexOf("upload") - 1);
                }
            } else {
                return new ResultDto("\u4e0a\u4f20\u5931\u8d25:" + file.getOriginalFilename(), "300", "", "", "");
            }
            System.out.println("url:" + url);
            return new ResultDto(url, "200", "", "", "");
        }
        return new ResultDto("\u4f20\u8f93\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/file/ajaxFormDataLoadPA"})
    @ResponseBody
    public ResultDto ajaxFormDataLoadPA(@RequestParam(value="file", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (file != null) {
            String fileName = request.getParameter("fileName");
            String directoryName = request.getParameter("directoryName");
            String fileId = request.getParameter("fileId");
            String url = OSSFileUtil.huaweiOBSFileUpload((MultipartFile)file, (String)directoryName);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                String cdnUrl;
                if (!GlobalResources.IS_TEST_ENVI.booleanValue() && StringUtils.isNotEmpty((CharSequence)(cdnUrl = GlobalResources.HW_CDN_URL))) {
                    url = cdnUrl + url.substring(url.indexOf("upload") - 1);
                }
            } else {
                return new ResultDto("\u4e0a\u4f20\u5931\u8d25:" + file.getOriginalFilename(), "300", "", "", "");
            }
            System.out.println("url:" + url);
            if (this.gZZRX_PACRequestService.isUploadPA(file.getInputStream(), fileId, fileName)) {
                System.out.println("fileName:" + fileName);
                System.out.println("directoryName:" + directoryName);
                System.out.println("fileId:" + fileId);
                return new ResultDto(url, "200", "", "", "");
            }
            return new ResultDto("\u540c\u6b65\u7406\u8d54\u9644\u4ef6token\u83b7\u53d6\u5931\u8d25\uff01", "300", "", "", "");
        }
        return new ResultDto("\u4f20\u8f93\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/file/ajaxFormDataLoadOther"})
    @ResponseBody
    public ResultDto ajaxFormDataLoadOther(@RequestParam(value="file", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (file != null) {
            String fileName = request.getParameter("fileName");
            String directoryName = request.getParameter("directoryName");
            String url = OSSFileUtil.huaweiOBSFileUpload((MultipartFile)file, (String)directoryName);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                String cdnUrl;
                if (!GlobalResources.IS_TEST_ENVI.booleanValue() && StringUtils.isNotEmpty((CharSequence)(cdnUrl = GlobalResources.HW_CDN_URL))) {
                    url = cdnUrl + url.substring(url.indexOf("upload") - 1);
                }
            } else {
                return new ResultDto("\u4e0a\u4f20\u5931\u8d25:" + file.getOriginalFilename(), "300", "", "", "");
            }
            System.out.println("url:" + url);
            return new ResultDto(url, "200", "", "", "");
        }
        return new ResultDto("\u4f20\u8f93\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/file/reader/playerList/{sign}"})
    public ModelAndView playerList(HttpServletRequest request, @PathVariable String sign) {
        String keyword = request.getParameter("keyword");
        if (!GlobalConstants.getConfig((String)"readerKey").equals(sign) || StringUtils.isEmpty((CharSequence)keyword)) {
            throw new RuntimeException("\u975e\u6cd5\u8bf7\u6c42");
        }
        ModelAndView view = new ModelAndView("/coninsweb/synopsis/playerTable");
        view.addObject("playerList", (Object)this.insInsuranceSlipService.findOperationRecordByExNo(keyword));
        return view;
    }

    @RequestMapping(value={"/file/reader/{sign}"})
    public ModelAndView reader(HttpServletRequest request, @PathVariable String sign) {
        if (!GlobalConstants.getConfig((String)"readerKey").equals(sign)) {
            throw new RuntimeException("\u975e\u6cd5\u8bf7\u6c42");
        }
        ModelAndView view = new ModelAndView("/coninsweb/synopsis/rrwebPlayer");
        view.addObject("sign", (Object)sign);
        return view;
    }

    @RequestMapping(value={"/file/reader/txt/{sign}"})
    @ResponseBody
    public String readerTxt(HttpServletRequest request, @PathVariable String sign) {
        String path = request.getParameter("path");
        if (!GlobalConstants.getConfig((String)"readerKey").equals(sign) || StringUtils.isEmpty((CharSequence)path)) {
            throw new RuntimeException("\u975e\u6cd5\u8bf7\u6c42");
        }
        return HttpUtil.get((String)path);
    }

    @RequestMapping(value={"/file/ajaxFormCanvasLoad"})
    @ResponseBody
    public void ajaxFormCanvasLoad(@RequestParam(value="file", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (file != null) {
            String sigId = request.getParameter("sigId");
            String orderId = request.getParameter("orderId");
            String oType = request.getParameter("oType");
            String sign = request.getParameter("sign");
            String directoryName = request.getParameter("directoryName");
            String fileType = Files.getFileExtension((String)file.getOriginalFilename());
            String base64 = FileUtils.convertToBase64((MultipartFile)file);
            new Thread(() -> this.saveVideoTxt(sigId, orderId, oType, sign, directoryName, fileType, base64)).start();
        }
    }

    private synchronized void saveVideoTxt(String sigId, String orderId, String oType, String sign, String directoryName, String fileType, String base64) {
        String url = OSSFileUtil.huaweiOBSFileUpload_base64((String)base64, (String)fileType, (String)directoryName, (String)sign);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            String cdnUrl;
            if (!GlobalResources.IS_TEST_ENVI.booleanValue() && StringUtils.isNotEmpty((CharSequence)(cdnUrl = GlobalResources.HW_CDN_URL))) {
                url = cdnUrl + url.substring(url.indexOf("upload") - 1);
            }
            this.insInsuranceSlipService.saveInsOperationRecord(orderId, sigId, oType, url);
            if (StringUtils.isNotEmpty((CharSequence)sigId) && StringUtils.isNotEmpty((CharSequence)orderId)) {
                this.insInsuranceSlipService.updateOrderIdBySigId(orderId, sigId);
            }
        }
        System.out.println("url:" + url);
    }

    @RequestMapping(value={"/file/ajaxFormHtmlLoad"})
    @ResponseBody
    public void ajaxFormHtmlLoad(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String file = request.getParameter("file");
        String sigId = request.getParameter("sigId");
        String orderId = request.getParameter("orderId");
        String oType = request.getParameter("oType");
        String fileName = request.getParameter("fileName");
        String directoryName = request.getParameter("directoryName");
        String width = request.getParameter("width");
        String height = request.getParameter("height");
        String length = request.getParameter("length");
        MultipartFileImpl multipartFile = null;
        try {
            String b64 = BASE64Util.decryptBASE64((String)file);
            String html = URLDecoder.decode(b64, "utf-8");
            System.out.println("****html:" + html);
            multipartFile = new MultipartFileImpl(fileName, html.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String url = OSSFileUtil.huaweiOBSFileUpload(multipartFile, (String)directoryName);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            String cdnUrl;
            if (!GlobalResources.IS_TEST_ENVI.booleanValue() && StringUtils.isNotEmpty((CharSequence)(cdnUrl = GlobalResources.HW_CDN_URL))) {
                url = cdnUrl + url.substring(url.indexOf("upload") - 1);
            }
            System.out.println("orderId:" + orderId + ",sigId:" + sigId + ",oType:" + oType + ",width:" + width + ",height:" + height + ",length:" + length + ",url:" + url);
        }
        System.out.println("url:" + url);
    }

    @RequestMapping(value={"/file/uploadFileForPA"})
    @ResponseBody
    public ResultDto uploadFileForPA(@RequestParam(value="file", required=false) MultipartFile file) throws IOException {
        if (file != null) {
            String fileId = UUID.randomUUID().toString();
            String folder = "/report/";
            String url = FileHelp.reportUpload((MultipartFile)file, (String)GlobalResources.COM_IMG_RE, (String)folder, (String)GlobalResources.DONOW_PATH);
            System.out.println("url:" + url);
            if (StringUtils.isEmpty((CharSequence)url)) {
                return new ResultDto("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
            }
            if (this.gZZRX_PACRequestService.isUploadPA(file.getInputStream(), fileId, url.split(folder)[1])) {
                System.out.println("fileId:" + fileId);
                HashMap map = Maps.newHashMap();
                map.put("fileId", fileId);
                map.put("url", url);
                return new ResultDto(JSON.toJSONString((Object)map), "200", "", "", "");
            }
            return new ResultDto("\u540c\u6b65\u7406\u8d54\u9644\u4ef6token\u83b7\u53d6\u5931\u8d25\uff01", "300", "", "", "");
        }
        return new ResultDto("\u4f20\u8f93\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/file/uploadFileForOther"})
    @ResponseBody
    public ResultDto uploadFileForOther(@RequestParam(value="file", required=false) MultipartFile file) {
        if (file != null) {
            String fileId = UUID.randomUUID().toString();
            String folder = "/report/";
            String url = FileHelp.reportUpload((MultipartFile)file, (String)GlobalResources.COM_IMG_RE, (String)folder, (String)GlobalResources.DONOW_PATH);
            System.out.println("url:" + url);
            if (StringUtils.isEmpty((CharSequence)url)) {
                return new ResultDto("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
            }
            HashMap map = Maps.newHashMap();
            map.put("fileId", fileId);
            map.put("url", url);
            return new ResultDto(JSON.toJSONString((Object)map), "200", "", "", "");
        }
        return new ResultDto("\u4f20\u8f93\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01", "300", "", "", "");
    }

    private boolean uploadPA(InputStream inputStream, Map<String, String> iobsParamMap, String fileId, String originalName) throws IOException {
        long length = inputStream.available();
        Response response = new IobsService().uploadStream(iobsParamMap.get("bucket"), fileId, inputStream, originalName, iobsParamMap.get("token"), length);
        System.out.println("\u8fd4\u56de\u7ed3\u679c:" + JSON.toJSONString((Object)response));
        if (response.isOK()) {
            return true;
        }
        System.out.println("error code\uff1a" + response.error());
        return false;
    }

    @RequestMapping(value={"/file/ajaxFormDataDelete"})
    public void ajaxFormDataDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = request.getParameter("url");
    }

    @RequestMapping(value={"/getResource"})
    public void getResource(String path, HttpServletResponse response) {
        String upload_path = GlobalResources.COM_IMG_RE;
        this.downloadFile(path, response, upload_path);
    }

    private void downloadFile(String path, HttpServletResponse response, String upload_path) {
        File file = new File(upload_path + path);
        try (ServletOutputStream out = response.getOutputStream();
             FileInputStream is = new FileInputStream(file);){
            response.addHeader("Content-Disposition", "attachment;filename=" + file.getName());
            int read = 0;
            byte[] buffer = new byte[8192];
            while ((read = ((InputStream)is).read(buffer)) != -1) {
                System.out.println(read);
                out.write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }

    public static String readFile(String filename) {
        StringBuilder content = new StringBuilder();
        try (FileReader fileReader = new FileReader(filename);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content.toString();
    }
}

