/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.task.base.config;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.entity.common.ComTaskCron;
import com.bcxin.ins.task.base.config.TaskConfig;
import com.bcxin.ins.task.base.service.TaskCronService;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.mapper.Wrapper;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@EnableScheduling
public class TaskInit
implements SchedulingConfigurer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    TaskCronService taskCronService;

    @Bean(destroyMethod="shutdown")
    public Executor taskScheduler() {
        return Executors.newScheduledThreadPool(StrUtil.toInteger((Object)GlobalConstants.getConfig((String)"task.pool")));
    }

    public void execute() {
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.taskScheduler());
        if ("true".equals(GlobalConstants.getConfig((String)"task.status"))) {
            try {
                List list = this.taskCronService.selectList((Wrapper)new EntityWrapper((Object)new ComTaskCron()));
                if (list.size() > 0) {
                    TaskConfig taskConfig = TaskConfig.getInstance();
                    for (ComTaskCron t : list) {
                        taskConfig.start(t);
                    }
                }
            }
            catch (Exception e) {
                this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u5931\u8d25.", (Throwable)e);
            }
        }
    }
}

