/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.web.commons;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.filter.ExceptionFilter;

@Activate(group={"provider"})
public class GlobalExceptionFilter
extends ExceptionFilter {
    public GlobalExceptionFilter() {
        System.out.println("GlobalExceptionFilter");
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Object data = invocation.getObjectAttachment("API.CURRENT_TENANT_USER_INFO");
        if (data != null) {
            TenantContext.getInstance();
            TenantContext.getUserContext().init((TenantUserContext.UserModel)data);
        }
        return super.invoke(invoker, invocation);
    }

    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        if (appResponse.hasException() && !ExceptionUtil.is((Throwable)appResponse.getException(), TenantExceptionAbstract.class)) {
            super.onResponse(appResponse, invoker, invocation);
        }
    }

    public void onError(Throwable e, Invoker<?> invoker, Invocation invocation) {
        super.onError(e, invoker, invocation);
    }
}

