package com.bcxin.web.commons;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.filter.ExceptionFilter;


@Activate(group = CommonConstants.PROVIDER)
public class GlobalExceptionFilter extends ExceptionFilter {
    public GlobalExceptionFilter() {
        System.out.println("GlobalExceptionFilter");
    }

    /**
     * 执行调用之前先绑定当前登入用户信息
     * @param invoker
     * @param invocation
     * @return
     * @throws RpcException
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Object data = invocation.getObjectAttachment(TenantUserContext.CURRENT_TENANT_USER_INFO);
        if (data != null) {
            TenantContext.getInstance().getUserContext().init((TenantUserContext.UserModel) data);
        }

        return super.invoke(invoker, invocation);
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {

        /**
         * 当异常为非自定义异常的时候，直接走dubbo默认的异常机制
         */
        if (appResponse.hasException() && !ExceptionUtil.is(appResponse.getException(), TenantExceptionAbstract.class)) {
            super.onResponse(appResponse, invoker, invocation);
        }
        //super.onResponse(appResponse, invoker, invocation);
    }

    @Override
    public void onError(Throwable e, Invoker<?> invoker, Invocation invocation) {
        super.onError(e, invoker, invocation);
    }
}
