package com.bcxin.rest.web.commons;

import com.bcxin.Infrastructures.exceptions.*;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

@ControllerAdvice
public class RestResponseEntityExceptionHandler extends ResponseEntityExceptionHandler {
    @ExceptionHandler
    public ResponseEntity exceptionHandle(Exception ex) {
        String detail = ExceptionUtil.getStackMessage(ex);
        ex.printStackTrace();
        MethodArgumentNotValidException invalidException = ExceptionUtil.cast(ex, MethodArgumentNotValidException.class);
        if (invalidException != null) {
            Collection<String> errors = invalidException.getBindingResult()
                    .getAllErrors().stream()
                    .map(ii -> {
                        StringBuilder msg = new StringBuilder();
                        Object[] arguments = ii.getArguments();
                        if (arguments != null && arguments.length > 0) {
                            String fieldName = Arrays.stream(arguments).map(arg -> {
                                DefaultMessageSourceResolvable dmsr = (DefaultMessageSourceResolvable) arg;
                                if (dmsr != null) {
                                    return dmsr.getDefaultMessage();
                                }

                                return null;
                            }).filter(arg -> arg != null).collect(Collectors.joining(","));

                            msg.append(fieldName);
                            msg.append(" ");
                        }

                        msg.append(ii.getDefaultMessage());

                        return msg.toString();
                    }).collect(Collectors.toList());

            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, errors);
        }

        DataOperationTenantException dtx = ExceptionUtil.cast(ex, DataOperationTenantException.class);
        if (dtx != null) {
            return ResponseBuilder.build(HttpStatus.METHOD_NOT_ALLOWED, dtx.getData(), dtx.getCode(), dtx.getMessage(), null);
        }

        UnAuthorizedTenantException authorizedException = ExceptionUtil.cast(ex, UnAuthorizedTenantException.class);
        if (authorizedException != null) {
            return ResponseBuilder.build(HttpStatus.UNAUTHORIZED, detail, ex.getMessage(), null);
        }

        ForbidTenantException forbidException = ExceptionUtil.cast(ex, ForbidTenantException.class);
        if (forbidException != null) {
            return ResponseBuilder.build(HttpStatus.FORBIDDEN, detail, forbidException.getMessage(), null);
        }

        NotFoundTenantException notFoundException = ExceptionUtil.cast(ex, NotFoundTenantException.class);
        if (notFoundException != null) {
            return ResponseBuilder.build(HttpStatus.NOT_FOUND, detail, notFoundException.getMessage(), null);
        }

        NotAllowedTenantException notAllowedException = ExceptionUtil.cast(ex, NotAllowedTenantException.class);
        if (notAllowedException != null) {
            return ResponseBuilder.build(HttpStatus.METHOD_NOT_ALLOWED, detail, notAllowedException.getMessage(), null);
        }

        ConflictTenantException conflictTenantException = ExceptionUtil.cast(ex, ConflictTenantException.class);
        if (conflictTenantException != null) {
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detail, conflictTenantException.getMessage(), null);
        }

        TenantExceptionAbstract tenantException = ExceptionUtil.cast(ex, TenantExceptionAbstract.class);
        if (tenantException != null) {
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detail, tenantException.getMessage(), null);
        }

        String detailException = ExceptionUtil.getStackMessage(ex);
        if (detailException.contains("IdentityNotFoundException") || detailException.contains("找不到身份信息")) {
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detailException, "账号/密码不正确", null);
        }
        if (detailException.contains("IdentityNotMatchedException") || detailException.contains("账号/密码不正确")) {
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detailException, "账号/密码不正确", null);
        }

        if (detailException.contains("TenantException:") && detailException.contains("\n")) {
            String msg = detailException.substring(detailException.indexOf("TenantException:") + 16, detailException.indexOf("\r"));
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detail, msg, null);
        }

        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detail, "系统异常, 请联系管理员", null);
    }

    @Override
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ValidationErrorResponse validationErrorResponse = new ValidationErrorResponse("请求参数不符合要求");
        for (ObjectError error : ex.getBindingResult().getAllErrors()) {
            if (error instanceof FieldError) {
                FieldError fieldError = (FieldError) error;
                validationErrorResponse.addFieldMessage(fieldError.getField(), fieldError.getDefaultMessage(), fieldError.getRejectedValue());
            } else {
                validationErrorResponse.addFieldMessage(error.getObjectName(), error.getDefaultMessage());
            }
        }

        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, validationErrorResponse);
    }
}
