package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

@Getter
public class OrganizationGetResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String unifySocialCreditCode;
    private final String unifySocialCreditCodeFile;
    private final String logoPath;
    private final LocationResponse placeOfRegister;
    private final LocationResponse placeOfBusiness;


    public OrganizationGetResponse(String id, String name, String unifySocialCreditCode,
                                   String unifySocialCreditCodeFile,
                                   String logoPath,
                                   LocationResponse placeOfRegister, LocationResponse placeOfBusiness) {
        this.id = id;
        this.name = name;
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
        this.logoPath = logoPath;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
    }
    @Getter
    public static class LocationResponse extends ResponseAbstract {
        private final ItemValueResponse province;
        private final ItemValueResponse city;
        private final ItemValueResponse district;
        private final String address;

        public LocationResponse(ItemValueResponse province, ItemValueResponse city,
                                ItemValueResponse district, String address) {
            this.province = province;
            this.city = city;
            this.district = district;
            this.address = address;
        }
    }

    @Getter
    public static class ItemValueResponse extends ResponseAbstract {
        private final String code;
        private final String name;

        public ItemValueResponse(String code, String name) {
            this.code = code;
            this.name = name;
        }
    }
}
