package com.bcxin.api.interfaces.tenants.responses;
import com.bcxin.Infrastructures.enums.Sex;
import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;

@Getter
public class MyDepartImContactGetResponse implements Serializable {
    private final String id;
    private final String name;
    private final String parentId;
    private final int displayOrder;
    private final Collection<ImContactItem> contacts;

    public MyDepartImContactGetResponse(String id, String name, String parentId, int displayOrder,Collection<ImContactItem> contacts) {
        this.id = id;
        this.name = name;
        this.parentId = parentId;
        this.displayOrder = displayOrder;
        this.contacts = contacts;
    }

    public static MyDepartImContactGetResponse create(String id, String name,
                                                      String parentId, int displayOrder,
                                                      Collection<ImContactItem> contacts) {
        return new MyDepartImContactGetResponse(id, name, parentId, displayOrder, contacts);
    }

    @Getter
    public static class ImContactItem implements Serializable {
        private final String id;
        private final String name;
        private final String headPhoto;
        private final String telephone;
        private final String imIdentity;
        private final Sex sex;

        public String getSexText() {
            switch (sex) {
                case Male:
                    return "男";
                case Female:
                    return "女";
                case Other:
                    return "其他";
                default:
                    return "未知";
            }
        }

        public ImContactItem(String id, String name, Sex sex, String headPhoto, String telephone, String imIdentity) {
            this.id = id;
            this.name = name;
            this.headPhoto = headPhoto;
            this.telephone = telephone;
            this.imIdentity = imIdentity;
            this.sex = sex;
        }

        public static ImContactItem create(String id, String name, Sex sex, String headPhoto, String telephone, String imIdentity) {
            return new ImContactItem(id, name, sex, headPhoto, telephone, imIdentity);
        }
    }
}
