package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.*;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

import java.util.Date;

@Getter
public class EmployeeGetResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String telephone;
    private final String departId;
    private final String departName;
    private final CredentialType credentialType;
    private final String credentialNumber;
    private final UserCheckedStatus checkedStatus;
    private final OccupationType occupationType;
    private final RealNameAuthenticatedStatus authenticatedStatus;
    private final Date hiredDate;

    public EmployeeGetResponse(String id, String name, String telephone, String departId,String departName,
                               CredentialType credentialType, String credentialNumber,
                               UserCheckedStatus checkedStatus, OccupationType occupationType,
                               RealNameAuthenticatedStatus authenticatedStatus, Date hiredDate) {
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.departId = departId;
        this.departName = departName;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.checkedStatus = checkedStatus;
        this.occupationType = occupationType;
        this.authenticatedStatus = authenticatedStatus;
        this.hiredDate = hiredDate;
    }

    public String getHiredDateText() {
        return DateUtil.format2ShortDate(this.getHiredDate());
    }

    public static EmployeeGetResponse create(String id, String name, String telephone, String departId, String departName,
                                             CredentialType credentialType, String credentialNumber,
                                             UserCheckedStatus checkedStatus, OccupationType occupationType,
                                             RealNameAuthenticatedStatus authenticatedStatus, Date hiredDate) {
        return new EmployeeGetResponse(id, name, telephone,departId, departName, credentialType, credentialNumber, checkedStatus,
                occupationType, authenticatedStatus, hiredDate);
    }


    /*

    public String getOccupationTypeText() {
        if(this.getOccupationType()==null) {
            return null;
        }

        switch (this.getOccupationType()) {
            case Normal:
                return "一般职员";
            case SecurityGuard:
                return "保安员";
            case Police:
                return "警员";

        }

        return this.getOccupationType().name();
    }


    public String getCredentialTypeText() {
        if (this.getCredentialTypeText() == null) {
            return null;
        }

        switch (this.getCredentialType()) {
            case IdCard:
                return "居民身份证（户口簿）";
            case IdCardOfXiangGang:
                return "香港特区护照/身份证";
            case IdCardOfAoMen:
                return "澳门特区护照/身份证明";
            case IdCardOfTaiwan:
                return "台湾居民来往大陆通行证";
            case Passport:
                return "外国护照";
            case Arms:
                return "退伍军人证";
            case PoliceNo:
                return "警号";
        }

        return this.getOccupationType().name();
    }
     */
}
