package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.enums.DepartImPermissionType;
import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;

@Getter
public class DepartmentTreeGetResponse extends DepartmentGetResponse {
    private final Collection<DepartmentTreeGetResponse> children;
    private final Collection<DataItem> allowedDeparts;


    public DepartmentTreeGetResponse(String id, String name, String parentId, int displayOrder,
                                     int totalMember,
                                     int level,
                                     DepartImPermissionType departIMPermissionType,
                                     Collection<String> allowedDepartIds,
                                     Collection<DepartmentTreeGetResponse> children, Collection<DataItem> allowedDeparts) {
        super(id, name, parentId, displayOrder, totalMember, departIMPermissionType, allowedDepartIds, level);
        this.children = children;
        this.allowedDeparts = allowedDeparts;
    }


    public static DepartmentTreeGetResponse create(String id, String name, String parentId, int displayOrder,
                                                   int totalMember,
                                                   int level,
                                                   DepartImPermissionType departIMPermissionType,
                                                   Collection<String> allowedDepartIds,
                                                   Collection<DepartmentTreeGetResponse> children,
                                                   Collection<DataItem> allowedDeparts) {
        return new DepartmentTreeGetResponse(id, name, parentId,displayOrder,totalMember,level,  departIMPermissionType,
                allowedDepartIds, children, allowedDeparts);
    }

    @Getter
    public static class DataItem implements Serializable {
        private final String id;
        private final String name;

        public DataItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public static DataItem create(String id, String name) {
            return new DataItem(id, name);
        }
    }
}
