package com.bcxin.api.interfaces.tenants.requests.organizations;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel("地址信息")
@Data
public class LocationRequest implements Serializable {
    /**
     * 省份
     */
    @ApiModelProperty(value = "省份")
    private ItemValueRequest province;

    /**
     * 城市
     */
    @ApiModelProperty(value = "城市")
    private ItemValueRequest city;

    /**
     * 区域
     */
    @ApiModelProperty(value = "区域")
    private ItemValueRequest district;

    /**
     * 详细地址
     */
    @ApiModelProperty(value = "详细地址")
    private String address;

    @Data
    public static class ItemValueRequest  implements Serializable {
        @ApiModelProperty(value = "名称")
        private String code;
        @ApiModelProperty(value = "编码")
        private String name;
    }
}
