package com.bcxin.api.interfaces.tenants.requests.organizations;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel("企业注册信息")
@Data
public class CompanyRegistrationRequest extends RequestAbstract {
    /**
     * 机构信息
     */
    @ApiModelProperty(value = "机构信息")
    @NotEmpty
    private String institutionalCode;
    /**
     * 行业类型
     */
    @ApiModelProperty(value = "行业类型")
    @NotEmpty
    private String industryCode;

    /**
     * 组织统一社会信用代码
     */
    @ApiModelProperty(value = "组织统一社会信用代码")
    @NotEmpty
    private String unifySocialCreditCode;

    /**
     * 组织统一社会信用代码扫描件
     */
    @ApiModelProperty(value = "组织统一社会信用代码扫描件")
    @NotEmpty
    private String unifySocialCreditCodeFile;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    @NotEmpty
    private String name;

    /**
     * 注册地
     */
    @ApiModelProperty(value = "注册地")
    @NotNull
    private LocationRequest placeOfRegister;

    /**
     * 经营地
     */
    @ApiModelProperty(value = "经营地")
    @NotNull
    private LocationRequest placeOfBusiness;

    /**
     * 管理员
     */
    @ApiModelProperty(value = "管理员")
    @NotNull
    private ContactRequest administrator;

    /**
     * 总经理
     */
    @ApiModelProperty(value = "总经理")
    @NotNull
    private ContactRequest generalManager;

    /**
     * 副总经理
     */
    @ApiModelProperty(value = "副总经理")
    @NotNull
    private ContactRequest deputyGeneralManager;

    @ApiModel("企业人员信息")
    @Data
    public static class ContactRequest implements Serializable {
        @ApiModelProperty(value = "姓名")
        @NotEmpty
        private String name;
        @ApiModelProperty(value = "手机")
        @NotEmpty
        private String telephone;
        @ApiModelProperty(value = "证件类型")
        @NotNull
        private CredentialType credentialType;
        @ApiModelProperty(value = "证件号")
        @NotEmpty
        private String credentialNumber;
    }
}
