package com.bcxin.api.interfaces.tenants.requests.employees;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class UpdateEmployeeRequest extends RequestAbstract {
    /**
     * 所属本部门
     */
    @NotEmpty
    @ApiModelProperty(value = "所属本部门")
    private String departId;
    /**
     * 入职时间
     */
    @NotNull
    @ApiModelProperty(value = "入职时间")
    private Date hiredDate;

    /**
     * 职位
     */
    @ApiModelProperty(value = "职位")
    private String position;

    /**
     * 上级用户
     */
    @ApiModelProperty(value = "上级用户")
    private String superiorId;

    /**
     * 转正时间
     */
    @ApiModelProperty(value = "转正时间")
    private Date positiveDate;
}
