package com.bcxin.api.interfaces.tenants.requests.employees;

import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.models.CredentialModel;
import com.bcxin.Infrastructures.validations.Credential;
import com.bcxin.Infrastructures.validations.Telephone;
import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class EmployeeRequest extends RequestAbstract {
    @NotEmpty
    private String name;

    @NotEmpty
    @Telephone
    private String telephone;
    /**
     * 所属本部门
     */
    @NotEmpty
    private String departId;
    /**
     * 职业类型
     */
    @NotNull
    private OccupationType occupationType;
    /**
     * 入职时间
     */
    @NotNull
    private Date hiredDate;

    /**
     * 证件
     */
    @NotNull
    @Credential(message = "身份证号码无效或者")
    private CredentialModel credential;
}
