package com.bcxin.api.interfaces.tenants.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;

@Getter
public class ImportDepartmentRequest extends RequestAbstract {
    private final String name;
    private final String parentTreeName;
    private final String displayOrder;
    private final String permissionType;

    public ImportDepartmentRequest(String name, String parentTreeName, String displayOrder,String permissionTypeText) {
        this.name = name;
        this.permissionType = permissionTypeText;
        this.parentTreeName = parentTreeName;
        this.displayOrder = displayOrder;
    }

    public static ImportDepartmentRequest create(String name, String parentTreeName, String displayOrder,String permissionTypeText) {
        return new ImportDepartmentRequest(name, parentTreeName, displayOrder, permissionTypeText);
    }
}
