package com.bcxin.api.interfaces.tenants.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import com.bcxin.api.interfaces.enums.DepartImPermissionType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;

@Data
public class DepartmentRequest extends RequestAbstract {
    @NotEmpty(message = "部门名称不能为空")
    private String name;
    private String parentId;

    private int displayOrder;

    @NotNull(message = "通讯录权限不能为空")
    @ApiModelProperty(value = "通讯录权限类型", allowEmptyValue = false,
            allowableValues = "JustOnDepart, OnDepartAndSub, JustSelf, Whole, Special")
    private DepartImPermissionType permissionType;

    @ApiModelProperty("当通讯录权限指定为: 可见指定部门; 用户需要选择该列表")
    private Collection<String> allowedDepartIds;
}
