package com.bcxin.api.interfaces.tenants;

import com.bcxin.Infrastructures.Pagination;
import com.bcxin.api.interfaces.tenants.criterias.OrganizationCriteria;
import com.bcxin.api.interfaces.tenants.requests.organizations.ApproveCompanyRequest;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyRegistrationRequest;
import com.bcxin.api.interfaces.tenants.responses.OrganizationAppGetResponse;
import com.bcxin.api.interfaces.tenants.responses.OrganizationGetResponse;
import com.bcxin.api.interfaces.tenants.responses.OrganizationResponse;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component
public interface OrganizationRpcProvider {
    String register(CompanyRegistrationRequest request);

    OrganizationGetResponse get(String id);

    Collection<OrganizationAppGetResponse> getOrganApps(String id);

    Collection<String> getApps(String id);

    void approve(String id, ApproveCompanyRequest request);

    Pagination<OrganizationResponse> search(OrganizationCriteria criteria);
}
