package com.bcxin.api.interfaces.salary.res;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;

import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;

@Data
public class GroupPageQueryRes implements Serializable{
	/**
	    * id
	    */
	    private Long id;

	    /**
	    * 薪资组名称 
	    */
	    private String groupName;

	    /**
	    * 算薪人员 
	    */
	    private String payEmp;
	    /**
	     * 算薪人员 工号
	     */
	    private String payEmpNo;
	    /**
	    * 算薪人员 人数
	    */
	    private int payEmpSize;


	    /**
	    * 计薪月份 2020-04
	    */
	    private String month;



	    /**
	    * 备注 
	    */
	    private String remark;
	    /**
	     * 算薪状态  0 未算薪、1 已生成税前工资、2 算税中、3 算税失败、4算税部分成功 5算税成功、6 已生成税后工资；
	     */
	     private int computeState;
	     /**
	      * 锁定状态  0 未锁定（默认）  1锁定
	      */
	     private Integer lockState;
	      /**
	      * 排除人员 
	      */
	      @Column(name="exclude_emp")
	      private String excludeEmp;

	      /**
	      * 计薪周期从当月的
	      */
	      @Column(name="cycle_from")
	      private String cycleFrom;

	      /**
	      * 计薪周期到当月的
	      */
	      @Column(name="cycle_to")
	      private String cycleTo;


	      /**
	      * 发薪日 1 当月 2 次月
	      */
	      @Column(name="pay_moth")
	      private Integer payMoth;

	      /**
	      * 发薪日 1-12号
	      */
	      @Column(name="pay_day")
	      private Integer payDay;

	      /**
	      * 日标准计薪时长 小时/ 天
	      */
	      @Column(name="payroll_hour")
	      private Integer payrollHour;

	      /**
	      * 配薪方式 1 模板 2 复制已有薪资组规则 3 导入薪资规则
	      */
	      @Column(name="pay_way")
	      private String payWay;

	      /**
	      * 薪资规则 json 字段{ } 
	      */
	      @Column(name="pay_rule")
	      private String payRule;

	      /**
	      * 状态 0草稿 1生效
	      */
	      @Column(name="state")
	      private int state;
	      

	      /**
	      * 创建时间
	      */
	      @Column(name="create_time")
	      private Date createTime;

	      /**
	      * 更改时间
	      */
	      @Column(name="update_time")
	      private Date updateTime;
	      /**
	       * 锁定时间
	       */
//	      @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
	      private Date lockTime;

	    public GroupPageQueryRes() {}
}
