package com.bcxin.api.interfaces.salary.req;

import java.math.BigDecimal;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;

import com.alibaba.excel.annotation.ExcelProperty;
import com.bcxin.Infrastructures.components.models.ExcelModelAbstract;

import lombok.Data;

/**
 * @description 考勤
 */
@Data
public class SalaryTaxHead extends ExcelModelAbstract {

    private static final long serialVersionUID = 1L;


    /**
    * 姓名 
    */
	@ExcelProperty(value="姓名")
	@NotNull
    private String name;

    /**
    * 证件号 
    */
	@ExcelProperty(value="证件号")
	@NotNull
    private String certiNo;
	/**
	 * 部门 
	 */
	@ExcelProperty(value="部门")
	private String dept;

    /**
    * 应发工资
    */
	@ExcelProperty(value="应发工资")
    private BigDecimal shouldSalary;
    /**
     * 个人社保合计
     */
    @ExcelProperty(value="个人社保合计")
    private BigDecimal socialSecurity;
    /**
     * 个人公积金合计
     */
    @ExcelProperty(value="个人公积金合计")
    private BigDecimal publicFunds;
    /**
     * 个税
     */
    @ExcelProperty(value="个税")
    private BigDecimal tax;



    public SalaryTaxHead() {
    }

}