package com.bcxin.api.interfaces.salary.req;

import java.math.BigDecimal;

import com.alibaba.excel.annotation.ExcelProperty;
import com.bcxin.Infrastructures.components.models.ExcelModelAbstract;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
/**
 * 批量导入工资模板
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SalaryPayrollHead extends ExcelModelAbstract{
    //设置excel表头名称
	@ExcelProperty(index = 0)
    private String name;
    @ExcelProperty(index = 1)
    private String certiType;
    // 证件号码
    @ExcelProperty(index = 2)
    private String certiNo;
    @ExcelProperty(index = 3)
    private String bankNo;

    @ExcelProperty(index = 4)
    private String bank;
    @ExcelProperty(index = 5)
    private String province;
    @ExcelProperty(index = 6)
    private String city;
    @ExcelProperty(index = 7)
    private String phone;
    @ExcelProperty(index = 8)
    private String email;
    @ExcelProperty(index = 9)
    private String dept;
    @ExcelProperty(index = 10)
    private String employeeNo;
    @ExcelProperty(index = 11)
    private String level;
    
    @ExcelProperty(index = 12)
    private String ratio;
    @ExcelProperty(index = 13)
    private String  remark;
    @ExcelProperty(index = 14)
    private String notes;
    
    @ExcelProperty(index = 15)
    private BigDecimal actualSalary;
    
    
    @ExcelProperty(index =16)
    private BigDecimal basicSalary;
    @ExcelProperty(index = 17)
    private BigDecimal trafficSubsidy;
    @ExcelProperty(index = 18)
    private BigDecimal mealSubsidy;
    @ExcelProperty(index = 19)
    private BigDecimal houseSubsidy;
    @ExcelProperty(index = 20)
    private BigDecimal ageSalary;
    
    @ExcelProperty(index = 21)
    private BigDecimal tax;
    @ExcelProperty(index = 22)
    private BigDecimal socialSecurity;
    @ExcelProperty(index = 23)
    private BigDecimal fund;
    
    @ExcelProperty(index = 24)
    private BigDecimal oldIns;
    @ExcelProperty(index = 25)
    private BigDecimal medicalIns;
    @ExcelProperty(index = 26)
    private BigDecimal workIns;
    @ExcelProperty(index = 27)
    private BigDecimal injuryIns;
    @ExcelProperty(index = 28)
    private BigDecimal birthIns;
    @ExcelProperty(index = 29)
    private BigDecimal entFund;
    
    
    @ExcelProperty(index =30)
    private BigDecimal childEdu;
    @ExcelProperty(index = 31)
    private BigDecimal houseRent;
    @ExcelProperty(index = 32)
    private BigDecimal houseIoan;
    @ExcelProperty(index = 33)
    private BigDecimal careOlder;
    @ExcelProperty(index = 34)
    private BigDecimal reEdu;
    @ExcelProperty(index = 35)
    private BigDecimal taxDeduct;
    @ExcelProperty(index = 36)
    private BigDecimal getShouldTax;
    @ExcelProperty(index = 37)
    private BigDecimal shouldTax;
    @ExcelProperty(index = 38)
    private BigDecimal totalDeduct;
    @ExcelProperty(index =39)
    private BigDecimal totalShouldDeduct;
    @ExcelProperty(index = 40)
    private BigDecimal totalPayed;
    
    
    @ExcelProperty(index = 41)
    private Integer yearVacationDay;
    @ExcelProperty(index = 42)
    private Integer illVacationDay;
    @ExcelProperty(index = 43)
    private Integer eventVacationDay;
    @ExcelProperty(index = 44)
    private Integer absentDay;
    @ExcelProperty(index = 45)
    private Integer exchangeDay;
    @ExcelProperty(index = 46)
    private Integer workDay;
    
    // 加班统计
    @ExcelProperty(index = 47)
    private Integer overtimeWorkHour;
    @ExcelProperty(index = 48)
    private Integer overtimeNonHoliHour;
    @ExcelProperty(index =49)
    private Integer overtimeHoliHour;
    
    // 其他项目
    @ExcelProperty(index = 50)
    private String other1;	
    
    
    
}
