package com.bcxin.api.interfaces.salary.req;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;

import lombok.Data;

/**
 * @description 工资项
 */
@Data
public class SalaryItemSaveReq implements Serializable {


    /**
    * id
    */
    private Long id;

    /**
    * 项目名称 
    */
    private String item;

    /**
    * 项目值  默认值
    */
    private String itemValue;

    /**
    * 数据类型 1 数字 2 文本
    */
    private int dataType;

    /**
    * 所属项目组id
    */
    private String itemGroup;
    
    /**
    * 所属类别
    */
    private String category;

    /**
    * 列表状态 0 不显示 1 显示
    */
    private int listState;
    
    /**
    * 	
    */
    @Column(name="payroll_show")
    private int payrollShow;

    /**
    *   税前税后款项 1 税前 2 税后
    */
    private int taxState;

    /**
    *  字段配置规则 
    */
    @Column(name="rule")
    private String rule;

    public SalaryItemSaveReq() {
    }

}