package com.bcxin.api.interfaces.salary.req;

import javax.validation.constraints.NotNull;

import com.alibaba.excel.annotation.ExcelProperty;
import com.bcxin.Infrastructures.components.models.ExcelModelAbstract;

import lombok.Data;

/**
 * @description 考勤
 */
@Data
public class SalaryAttendanceHead extends ExcelModelAbstract {

    private static final long serialVersionUID = 1L;


    /**
    * 姓名 
    */
	@ExcelProperty(value="姓名")
	@NotNull
    private String name;

    /**
    * 员工号 
    */
	@NotNull
	@ExcelProperty(value="员工号")
    private String employeeNo;
	/**
	 * 部门 
	 */
	@ExcelProperty(value="部门")
	private String dept;

    /**
    * 入离职缺勤天数
    */
	@ExcelProperty(value="入离职缺勤天数")
    private Integer lostDay;

    /**
    * 实际出勤天数
    */
	@ExcelProperty(value="实际出勤天数")
    private Integer actualDay;
	/**
	 * 应出勤天数
	 */
	@ExcelProperty(value="应出勤天数")
	private Integer shouldlDay;


    public SalaryAttendanceHead() {
    }

}