package com.bcxin.api.interfaces.salary.req;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;

@Data
public class PayrollVo extends PageBasic implements IAggregate{
    private static final long serialVersionUID = 1L;
	private String id;
	/**批次*/
	private String batchNo;
	/**薪资类型*/
	private String salaryType;
	/**工资单名称*/
	private String payrollName;
	/**工资发放日期*/
	private String payrollDate;
	/**总金额*/
	private BigDecimal totalMoney;
	/**总笔数*/
	private int totalCount;
	/**员工已读数*/
	private int readCount;
	/**员工已确认数*/
	private int confirmCount;
	
	/**确认开关*/
	private int confirmSwitch;
	/**反馈开关*/
	private int feedBackSwitch;
	/**撤回员工数*/
	private int revokeCount;
	
	/**员工反馈数*/
	private int feedBackCount;
	
	/**发送状态 1 部分发送  2 发送*/
	private Integer sendStatus;
	/**审批状态 */
	private Integer approveStatus;
	/**审批人 */
	private String approver;
	/**审批人ID */
	private String approverId;
	
	private String tenantUserId;
	
	/**上传时间(发送时间) */
//	@JsonFormat(pattern = "yyyy-MM-dd HH:mm",timezone="GMT+8")
	private Date createTime;
	/**上传人 */
	private String handler;
	
	/**问候语*/
	private String greet;
	/**温馨提示*/
	private String hint;
	/**限时查看*/
	private Integer time;
	/**限时查看单位*/
	private int unit;
	
//	List<Map<String,Object>>details;
	List<PayrollDetailVo>details;
	
}
