package com.bcxin.api.interfaces.salary.req;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.validation.constraints.NotNull;

import lombok.Data;

@Data
public class PayrollConfigReq implements Serializable {
	@NotNull
	private Long id;
	/**员工反馈 0 关闭 1 开启*/
	private Integer feedBackSwitch;
	/**短信通知(资单发送成功后将通过短信通知员工) 0 关闭 1 开启*/
	private int msgSwitch;
	/**邮件通知  0 关闭 1 开启 */
	private Integer emailSwitch;
	/**工资单确认方式  0 无需确认 1 点击确认 2 签名确认   {way:0,value:6}*/
	private String confirmWay;
	/**显示水印 0 关闭 1 开启 */
	private Integer showSwitch;
	/**显示单位名称 0 关闭 1 开启 */
	private Integer showCompanyName;
	
	/** 金额预警 0 关闭 1 开启 */
	private Integer moneyWarn;
	
	/**实发金额预警下线 */
	private BigDecimal minSalary;
	/**实发金额预警上线 */
	private BigDecimal maxSalary;
	/**一人多卡预警 0 关闭  1 开启 */
	private Integer mulCard;
	/**离职员工预警 0 关闭  1 开启 */
	private Integer leaveWarn;
	/**年龄预警 0 关闭  1 开启 */
	private Integer ageWarn;
	/**女性年龄预警值  */
	private Integer womanWarn;
	/**男性年龄预警值  0 关闭  1 开启 */
	private Integer manWarn;
	
	/**银行卡校验 0 关闭  1 开启 */
	private Integer bankNoWarn;
	
	/**工资单审批 0 关闭  1 开启  开启后，工资单发放需要经过审批，才能发送至员工个人 */
	private Integer checkPayroll;
	
}
