package com.bcxin.api.interfaces.salary.cmd;

import java.io.Serializable;
import java.util.Date;

import javax.validation.constraints.NotNull;

import org.springframework.format.annotation.DateTimeFormat;

import com.bcxin.api.interfaces.salary.req.PageBasic;
import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;
@Data
public class PayrollEmployeeCmd extends PageBasic{
	@NotNull
	/**员工姓名*/
	private String name;
	/**发送日期*/
	@NotNull
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm",timezone="GMT+8")
	private Date createTimeFrom;
	
	@NotNull
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm",timezone="GMT+8")
	private Date createTimeTo;
	
}
