package com.bcxin.api.interfaces.rbacs.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

@Getter
public class RoleDetailGetResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final Collection<ResourceItem> resources=new ArrayList<>();

    public RoleDetailGetResponse(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public void assignResourceItem(ResourceItem resourceItem) {
        this.getResources().add(resourceItem);
    }

    @Getter
    public static class ResourceItem implements Serializable {
        private final String id;
        private final String code;
        private final String name;
        private final Collection<ResourceItem> resources = new ArrayList<>();

        public ResourceItem(String id, String code,String name) {
            this.id = id;
            this.code = code;
            this.name = name;
        }

        public void assignResourceItem(ResourceItem resourceItem) {
            this.getResources().add(resourceItem);
        }

        public static ResourceItem create(String id,String code, String name) {
            return new ResourceItem(id,code, name);
        }
    }

    public static RoleDetailGetResponse create(String id, String name) {
        return new RoleDetailGetResponse(id, name);
    }
}
