package com.bcxin.api.interfaces.rbacs.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class CategoryDetailGetResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final Collection<ResourceGetResponse> responses;

    public CategoryDetailGetResponse(String id, String name,
                                     Collection<ResourceGetResponse> responses) {
        this.id = id;
        this.name = name;
        this.responses = responses;
    }

    public static CategoryDetailGetResponse create(String id, String name,
                                                   Collection<ResourceGetResponse> responses) {
        return new CategoryDetailGetResponse(id,  name, responses);
    }
}
