package com.bcxin.api.interfaces.rbacs.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class BatchCategoryResourceRequest extends RequestAbstract {
    private final Collection<CategoryRequest> categories;

    public BatchCategoryResourceRequest(Collection<CategoryRequest> categories) {
        this.categories = categories;
    }

    @Getter
    public static class CategoryRequest extends RequestAbstract {
        private final String id;
        private final String name;
        private final Collection<CategoryResourceRequest> resources;

        public CategoryRequest(String id, String name, Collection<CategoryResourceRequest> resources) {
            this.id = id;
            this.name = name;
            this.resources = resources;
        }
    }

    @Getter
    public static class CategoryResourceRequest extends RequestAbstract {
        private final String id;
        private final String name;

        public CategoryResourceRequest(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}
