package com.bcxin.api.interfaces.rbacs;

import java.util.List;
import java.util.Map;

import com.bcxin.Infrastructures.Pagination;
import com.bcxin.api.interfaces.salary.cmd.PayDistributionCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrollDetailUpdateCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrollEmployeeCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrollSendCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrolllUploadCmd;
import com.bcxin.api.interfaces.salary.cmd.SalaryGroupSendPayrollCmd;
import com.bcxin.api.interfaces.salary.cmd.TrendCmd;
import com.bcxin.api.interfaces.salary.req.PayrollConfigReq;
import com.bcxin.api.interfaces.salary.req.PayrollDetailVo;
import com.bcxin.api.interfaces.salary.req.PayrollVo;
import com.bcxin.api.interfaces.salary.req.SalaryDetailHead;
import com.bcxin.api.interfaces.salary.res.PayDistributionRes;
import com.bcxin.api.interfaces.salary.res.TrendRes;
import com.bcxin.api.interfaces.salary.res.YearAddRes;

public interface ISalaryPayrollService {

	Pagination<PayrollVo> pageList(PayrollVo req);

	PayrollConfigReq payrollQuery();

	void payrollUpdate(PayrollConfigReq req);

	Pagination<PayrollVo>  payrollDetail(PayrollDetailVo req);

	void updateDetail(PayrollDetailVo req);

	void delPayroll(PayrollVo req);

	String save(PayrolllUploadCmd parm);

	void updatePayrollDetail(PayrollDetailUpdateCmd cmd);

	void delPayrollDetail(String payrollId, List<String>items);

	Object saveDetail(PayrolllUploadCmd parm);

	List<Map<String, Object>> checkPayrollDetails(List<PayrollDetailVo> datas);

	Map<String, Object> queryPayrollByGorupId(PayrollSendCmd parm);

	Map<String, Object> pageEmployeeList(PayrollEmployeeCmd req);

	List<SalaryDetailHead> listEmployee(List<String> _ids);

	TrendRes trend(TrendCmd cmd);

	List<YearAddRes> yearAdd(TrendCmd cmd);

	List<PayDistributionRes> payDistribution(PayDistributionCmd cmd);

	Map<String, Object> groupGenPayroll(SalaryGroupSendPayrollCmd parm);

}
