package com.bcxin.api.interfaces.rbacs;

import java.util.List;

import javax.validation.constraints.NotNull;

import com.bcxin.Infrastructures.Pagination;
import com.bcxin.api.interfaces.salary.req.BatchDelGroupUserReq;
import com.bcxin.api.interfaces.salary.req.DeptEmployeeReq;
import com.bcxin.api.interfaces.salary.req.GroupCreateNextReq;
import com.bcxin.api.interfaces.salary.req.GroupLockReq;
import com.bcxin.api.interfaces.salary.req.GroupPageQueryReq;
import com.bcxin.api.interfaces.salary.req.GroupStatisticsReq;
import com.bcxin.api.interfaces.salary.req.ItemGroupReq;
import com.bcxin.api.interfaces.salary.req.SalaryGroupEmployeeVO;
import com.bcxin.api.interfaces.salary.req.SalaryGroupSaveReq;
import com.bcxin.api.interfaces.salary.res.EmployeeBasicRes;
import com.bcxin.api.interfaces.salary.res.GroupPageQueryRes;
import com.bcxin.api.interfaces.salary.res.GroupStatisticsRes;
import com.bcxin.api.interfaces.salary.res.SalaryOrgRes;

public interface ISalaryGroupService {
	Long save(SalaryGroupSaveReq salaryGroup);
	
	Pagination<GroupPageQueryRes> pageQuery(GroupPageQueryReq req);
	
	void deleteById(Long id);
	
	List<ItemGroupReq> findItemGroup();

	void itemGroupSave(ItemGroupReq req);

	void itemGroupDel(@NotNull Integer id);

	void batchDelGroupUser(BatchDelGroupUserReq req);

	Pagination<SalaryGroupEmployeeVO> list(SalaryGroupEmployeeVO req); 
	
	List<SalaryOrgRes> selectSalaryOrgList();

	List<EmployeeBasicRes> listDeptEmployee(DeptEmployeeReq req);

	GroupStatisticsRes statistics(GroupStatisticsReq req);

	void lock(GroupLockReq req);

	void createNext(GroupCreateNextReq req);

	GroupPageQueryRes getById(Long groupId);
}
