package com.bcxin.api.interfaces.identities.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

@Getter
public class PrepareResetPasswordResponse extends ResponseAbstract {
    private final String jwt;
    private final String code;
    private final boolean success;

    public PrepareResetPasswordResponse(String jwt, boolean success, String code) {
        this.jwt = jwt;
        this.code = code;
        this.success = success;
    }

    public static PrepareResetPasswordResponse create(String jwt, boolean success, String code) {
        return new PrepareResetPasswordResponse(jwt, success, code);
    }
}
