package com.bcxin.api.interfaces.identities.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;

@Getter
public class SignUpRequest extends RequestAbstract {
    private final String tenantUserId;
    private final String telephone;
    private final String name;

    public SignUpRequest(String tenantUserId,String telephone, String name) {
        this.tenantUserId = tenantUserId;
        this.telephone = telephone;
        this.name = name;
    }

    public static SignUpRequest create(String tenantUserId,String telephone, String name) {
        return new SignUpRequest(tenantUserId, telephone, name);
    }
}
