package com.bcxin.api.interfaces.identities;

import com.bcxin.api.interfaces.identities.requests.*;
import com.bcxin.api.interfaces.identities.responses.PrepareResetPasswordResponse;
import com.bcxin.api.interfaces.identities.responses.SignInResponse;
import org.springframework.stereotype.Component;

@Component
public interface IdentityRpcProvider {
    SignInResponse signIn(SignInRequest request);

    void signUp(SignUpRequest request);

    String getByName();

    void changePassword(ChangePasswordRequest request);

    SignInResponse signIn(WeChatSignInRequest request);

    void change(ChangeBasicIdentityRequest request);

    void bindWechat(BindWechatRequest request);

    void unbindWechat(String id);

    PrepareResetPasswordResponse prepareResetPassword(PrepareResetPasswordRequest request);

    void restPassword(ResetPasswordRequest request);
}
