package com.bcxin.Infrastructures.utils;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtil {
    /**
     * 将CheckedException转换为UncheckedException.
     */
    public static RuntimeException unchecked(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException) e;
        } else {
            return new RuntimeException(e);
        }
    }

    /**
     * 将ErrorStack转化为String.
     */
    public static String getStackTraceAsString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    /**
     * 判断异常是否由某些底层的异常引起.
     */
    public static boolean isCausedBy(Exception ex, Class<? extends Exception>... causeExceptionClasses) {
        Throwable cause = ex.getCause();
        while (cause != null) {
            for (Class<? extends Exception> causeClass : causeExceptionClasses) {
                if (causeClass.isInstance(cause)) {
                    return true;
                }
            }
            cause = cause.getCause();
        }
        return false;
    }

    public static <T extends Exception> T cast(Exception ex, Class<T> targetClass) {
        assert ex != null;

        if (!targetClass.isAssignableFrom(ex.getClass())) {
            return null;
        }

        return (T) ex;
    }

    public static <T extends Exception> boolean is(Throwable ex, Class<T> targetClass) {
        assert ex != null;

        return targetClass.isAssignableFrom(ex.getClass());
    }

    public static String getStackMessage(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        Throwable whileTr = throwable;
        while (whileTr != null) {
            sb.append(String.format("exception=%s, detail=%s;", whileTr.getClass().getName(), whileTr.toString()));
            whileTr = whileTr.getCause();
        }

        return sb.toString();
    }
}
