package com.bcxin.Infrastructures.components;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.Infrastructures.events.DomainEventResultAbstract;
import com.bcxin.Infrastructures.events.IntegrationEventAbstract;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

import java.util.Map;

public interface EventDispatcher {
    /**
     * 领域事件
     * @param domainEvent
     */
    void dispatch(DomainEventAbstract domainEvent);

    /**
     * 集成事件
     * @param event
     */
    void dispatch(IntegrationEventAbstract event);

    @Component
    public static class EventDispatcherImpl implements EventDispatcher
    {
        private final ApplicationEventPublisher applicationEventPublisher;

        public EventDispatcherImpl(ApplicationEventPublisher applicationEventPublisher) {
            this.applicationEventPublisher = applicationEventPublisher;
        }

        @Override
        public void dispatch(DomainEventAbstract domainEvent) {
            this.applicationEventPublisher.publishEvent(domainEvent);
        }

        @Override
        public void dispatch(IntegrationEventAbstract event) {
            this.applicationEventPublisher.publishEvent(event);
        }
    }
}
